/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.npw.WizardUtils;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowLicensesUsedAction
extends DumbAwareAction {
    public ShowLicensesUsedAction() {
        super("_Licenses");
    }

    public void actionPerformed(AnActionEvent e) {
        LicenseDialog licenseDialog = new LicenseDialog(ShowLicensesUsedAction.getEventProject((AnActionEvent)e));
        licenseDialog.init();
        try {
            licenseDialog.show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class LicenseDialog
    extends DialogWrapper {
        protected LicenseDialog(@Nullable Project project) {
            super(project);
            this.getWindow().setMinimumSize((Dimension)JBUI.size((int)600, (int)400));
        }

        protected void init() {
            super.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            StringBuilder sb = new StringBuilder(5000);
            File licenseDir = new File(PathManager.getHomePath(), "license");
            assert (licenseDir.exists()) : licenseDir;
            LicenseDialog.collectLicenses(sb, licenseDir);
            List<String> extraPlugins = Arrays.asList("android", "google-appindexing", "google-cloud-testing", "google-cloud-tools", "google-cloud-tools-core", "google-login", "google-services", "firebase");
            for (String plugin : extraPlugins) {
                File licenses = new File(PathManager.getPreInstalledPluginsPath(), PathUtil.toSystemDependentName((String)(plugin + "/lib/licenses")));
                if (!licenses.isDirectory()) continue;
                LicenseDialog.collectLicenses(sb, licenses);
            }
            String text = "<html>" + sb.toString() + "</html>";
            JTextPane label = new JTextPane();
            label.setContentType("text/html");
            label.setText(text);
            JBScrollPane pane = new JBScrollPane((Component)label);
            pane.setPreferredSize((Dimension)JBUI.size((int)600, (int)400));
            panel.add((Component)pane, "Center");
            return panel;
        }

        private static void collectLicenses(@NotNull StringBuilder sb, @NotNull File licenseDir) {
            if (sb == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/android/tools/idea/actions/ShowLicensesUsedAction$LicenseDialog", "collectLicenses"));
            }
            if (licenseDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "licenseDir", "com/android/tools/idea/actions/ShowLicensesUsedAction$LicenseDialog", "collectLicenses"));
            }
            for (File file : WizardUtils.listFiles(licenseDir)) {
                sb.append("<br><br>------------ License file: ");
                sb.append(file.getName());
                sb.append("------------");
                sb.append("<br><br>");
                sb.append(LicenseDialog.getLicenseText(file));
            }
        }

        @NotNull
        private static String getLicenseText(@NotNull File f) {
            String string;
            if (f == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/android/tools/idea/actions/ShowLicensesUsedAction$LicenseDialog", "getLicenseText"));
            }
            try {
                string = Files.toString((File)f, (Charset)Charsets.UTF_8).replaceAll("\\<.*?\\>", "").replace("\n", "<br>");
            }
            catch (IOException e) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/ShowLicensesUsedAction$LicenseDialog", "getLicenseText"));
                }
                return "";
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/ShowLicensesUsedAction$LicenseDialog", "getLicenseText"));
            }
            return string;
        }
    }
}

