/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.idea.apk.viewer.AaptInvoker;
import com.android.tools.idea.apk.viewer.AndroidApplicationInfo;
import com.android.tools.idea.apk.viewer.ApkEntry;
import com.android.tools.idea.apk.viewer.ApkEntryImpl;
import com.android.tools.idea.apk.viewer.ApkFileSystem;
import com.android.tools.idea.apk.viewer.ApkViewPanel;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class ApkParser {
    private static final ListeningExecutorService ourExecutorService = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE);
    private final VirtualFile myApkRoot;
    private final File myApk;
    private ListenableFuture<DefaultMutableTreeNode> myTreeStructure;
    private ListenableFuture<DefaultMutableTreeNode> myTreeStructureWithCompressedSizes;
    private ListenableFuture<AndroidApplicationInfo> myApplicationInfo;
    private ListenableFuture<Long> myCompressedFullApkSize;

    public ApkParser(@NotNull VirtualFile baseFile, @NotNull VirtualFile apkRoot) {
        if (baseFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/android/tools/idea/apk/viewer/ApkParser", "<init>"));
        }
        if (apkRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apkRoot", "com/android/tools/idea/apk/viewer/ApkParser", "<init>"));
        }
        if (!apkRoot.getFileSystem().equals((Object)ApkFileSystem.getInstance())) {
            throw new IllegalArgumentException("Invalid APK");
        }
        this.myApkRoot = apkRoot;
        this.myApk = VfsUtilCore.virtualToIoFile((VirtualFile)baseFile);
    }

    @NotNull
    public synchronized ListenableFuture<DefaultMutableTreeNode> constructTreeStructure() {
        if (this.myTreeStructure == null) {
            this.myTreeStructure = ourExecutorService.submit(() -> ApkParser.createTreeNode(this.myApkRoot));
        }
        ListenableFuture<DefaultMutableTreeNode> listenableFuture = this.myTreeStructure;
        if (listenableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkParser", "constructTreeStructure"));
        }
        return listenableFuture;
    }

    @NotNull
    public synchronized ListenableFuture<DefaultMutableTreeNode> constructTreeStructureWithCompressedSizes() {
        if (this.myTreeStructureWithCompressedSizes == null) {
            this.myTreeStructureWithCompressedSizes = ourExecutorService.submit(() -> {
                File compressedApk = ApkParser.getZipCompressedApk(this.myApk);
                try (ZipFile zip = new ZipFile(compressedApk);){
                    DefaultMutableTreeNode defaultMutableTreeNode = ApkParser.updateTreeStructure((DefaultMutableTreeNode)this.constructTreeStructure().get(), zip);
                    return defaultMutableTreeNode;
                }
            });
        }
        ListenableFuture<DefaultMutableTreeNode> listenableFuture = this.myTreeStructureWithCompressedSizes;
        if (listenableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkParser", "constructTreeStructureWithCompressedSizes"));
        }
        return listenableFuture;
    }

    @NotNull
    public synchronized ListenableFuture<AndroidApplicationInfo> getApplicationInfo() {
        if (this.myApplicationInfo == null) {
            this.myApplicationInfo = ourExecutorService.submit(this::getAppInfo);
        }
        ListenableFuture<AndroidApplicationInfo> listenableFuture = this.myApplicationInfo;
        if (listenableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkParser", "getApplicationInfo"));
        }
        return listenableFuture;
    }

    @NotNull
    public synchronized ListenableFuture<Long> getUncompressedApkSize() {
        ListenableFuture listenableFuture = Futures.transform(this.constructTreeStructure(), input -> {
            ApkEntry entry = ApkEntry.fromNode(input);
            assert (entry != null);
            return entry.getSize();
        });
        if (listenableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkParser", "getUncompressedApkSize"));
        }
        return listenableFuture;
    }

    @NotNull
    public synchronized ListenableFuture<Long> getCompressedFullApkSize() {
        if (this.myCompressedFullApkSize == null) {
            this.myCompressedFullApkSize = ourExecutorService.submit(() -> ApkParser.getApkServedByPlay(this.myApk).length());
        }
        ListenableFuture<Long> listenableFuture = this.myCompressedFullApkSize;
        if (listenableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkParser", "getCompressedFullApkSize"));
        }
        return listenableFuture;
    }

    @NotNull
    static DefaultMutableTreeNode createTreeNode(@NotNull VirtualFile file) {
        VirtualFile zipRoot;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/apk/viewer/ApkParser", "createTreeNode"));
        }
        String originalName = null;
        DefaultMutableTreeNode node = new DefaultMutableTreeNode();
        long size = 0L;
        if (StringUtil.equals((CharSequence)file.getExtension(), (CharSequence)"zip") && (zipRoot = ApkFileSystem.getInstance().extractAndGetContentRoot(file)) != null) {
            originalName = file.getName();
            file = zipRoot;
        }
        if (file.isDirectory()) {
            for (VirtualFile child : file.getChildren()) {
                DefaultMutableTreeNode childNode = ApkParser.createTreeNode(child);
                node.add(childNode);
                size += ((ApkEntry)childNode.getUserObject()).getSize();
            }
            if (file.getLength() > 0L) {
                size = file.getLength();
            }
        } else {
            size = file.getLength();
        }
        node.setUserObject(new ApkEntryImpl(file, originalName, size));
        ApkParser.sort(node);
        DefaultMutableTreeNode defaultMutableTreeNode = node;
        if (defaultMutableTreeNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkParser", "createTreeNode"));
        }
        return defaultMutableTreeNode;
    }

    @NotNull
    private static DefaultMutableTreeNode updateTreeStructure(@NotNull DefaultMutableTreeNode treeNode, @NotNull ZipFile compressedApk) {
        if (treeNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeNode", "com/android/tools/idea/apk/viewer/ApkParser", "updateTreeStructure"));
        }
        if (compressedApk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compressedApk", "com/android/tools/idea/apk/viewer/ApkParser", "updateTreeStructure"));
        }
        long compressedSize = 0L;
        ApkEntry entry = ApkEntry.fromNode(treeNode);
        assert (entry != null);
        if (treeNode.getChildCount() > 0) {
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode childNode = ApkParser.updateTreeStructure((DefaultMutableTreeNode)treeNode.getChildAt(i), compressedApk);
                compressedSize += ((ApkEntry)childNode.getUserObject()).getCompressedSize();
            }
        } else {
            ZipEntry ze = compressedApk.getEntry(ApkFileSystem.getInstance().getRelativePath(entry.getFile()));
            compressedSize = ze == null ? -1L : ze.getCompressedSize();
        }
        entry.setCompressedSize(compressedSize);
        DefaultMutableTreeNode defaultMutableTreeNode = treeNode;
        if (defaultMutableTreeNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkParser", "updateTreeStructure"));
        }
        return defaultMutableTreeNode;
    }

    public static void sort(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/apk/viewer/ApkParser", "sort"));
        }
        if (node.getChildCount() == 0) {
            return;
        }
        ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            children.add((DefaultMutableTreeNode)node.getChildAt(i));
        }
        Collections.sort(children, (o1, o2) -> {
            ApkEntry entry1 = ApkEntry.fromNode(o1);
            ApkEntry entry2 = ApkEntry.fromNode(o2);
            if (entry1 == null || entry2 == null) {
                return 0;
            }
            return Long.compare(entry2.getSize(), entry1.getSize());
        });
        node.removeAllChildren();
        for (DefaultMutableTreeNode child : children) {
            node.add(child);
        }
    }

    @NotNull
    private AndroidApplicationInfo getAppInfo() {
        AaptInvoker invoker;
        block6: {
            AndroidApplicationInfo androidApplicationInfo;
            try {
                invoker = AaptInvoker.getInstance();
                if (invoker != null) break block6;
                androidApplicationInfo = AndroidApplicationInfo.UNKNOWN;
            }
            catch (ExecutionException e) {
                Logger.getInstance(ApkViewPanel.class).warn("Unable to run aapt", (Throwable)e);
                AndroidApplicationInfo androidApplicationInfo2 = AndroidApplicationInfo.UNKNOWN;
                if (androidApplicationInfo2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkParser", "getAppInfo"));
                }
                return androidApplicationInfo2;
            }
            if (androidApplicationInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkParser", "getAppInfo"));
            }
            return androidApplicationInfo;
        }
        ProcessOutput xmlTree = invoker.getXmlTree(this.myApk, "AndroidManifest.xml");
        AndroidApplicationInfo androidApplicationInfo = AndroidApplicationInfo.fromXmlTree(xmlTree);
        if (androidApplicationInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkParser", "getAppInfo"));
        }
        return androidApplicationInfo;
    }

    private static File getApkServedByPlay(@NotNull File apk) {
        File compressedFile;
        if (apk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apk", "com/android/tools/idea/apk/viewer/ApkParser", "getApkServedByPlay"));
        }
        try {
            compressedFile = FileUtil.createTempFile((String)"compressed", (String)".apk", (boolean)true);
        }
        catch (IOException e) {
            Logger.getInstance(ApkParser.class).warn((Throwable)e);
            return apk;
        }
        try (MaxGzipOutputStream zos = new MaxGzipOutputStream(new FileOutputStream(compressedFile));){
            Files.copy(apk.toPath(), zos);
            zos.flush();
        }
        catch (IOException e) {
            Logger.getInstance(ApkParser.class).warn((Throwable)e);
            return apk;
        }
        return compressedFile;
    }

    static File getZipCompressedApk(@NotNull File apk) {
        File compressedFile;
        if (apk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apk", "com/android/tools/idea/apk/viewer/ApkParser", "getZipCompressedApk"));
        }
        try {
            compressedFile = FileUtil.createTempFile((String)FileUtil.getNameWithoutExtension((File)apk), (String)".apk", (boolean)true);
        }
        catch (IOException e) {
            return apk;
        }
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(apk));
             ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(compressedFile));){
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                int n;
                ZipEntry compressedZe = new ZipEntry(ze.getName());
                compressedZe.setMethod(8);
                compressedZe.setTime(ze.getTime());
                zos.putNextEntry(compressedZe);
                byte[] buf = new byte[4096];
                while ((n = zis.read(buf)) > 0) {
                    zos.write(buf, 0, n);
                }
            }
        }
        catch (IOException e) {
            return apk;
        }
        return compressedFile;
    }

    private static final class MaxZipOutputStream
    extends ZipOutputStream {
        public MaxZipOutputStream(OutputStream out) throws IOException {
            super(out);
            this.def.setLevel(9);
        }
    }

    private static final class MaxGzipOutputStream
    extends GZIPOutputStream {
        public MaxGzipOutputStream(OutputStream out) throws IOException {
            super(out);
            this.def.setLevel(9);
        }
    }
}

