/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import org.jetbrains.annotations.NotNull;

public class AvdNameVerifier {
    private static final String ALLOWED_CHARS = "0-9a-zA-Z-_. ()";
    private static final String ALLOWED_CHARS_READABLE = "a-z A-Z 0-9 . _ - ( )";

    public static boolean isValid(@NotNull String candidateName) {
        if (candidateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateName", "com/android/tools/idea/avdmanager/AvdNameVerifier", "isValid"));
        }
        return candidateName.matches("^[0-9a-zA-Z-_. ()]+$");
    }

    @NotNull
    public static String stripBadCharacters(@NotNull String candidateName) {
        if (candidateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateName", "com/android/tools/idea/avdmanager/AvdNameVerifier", "stripBadCharacters"));
        }
        String string = candidateName.replaceAll("[^0-9a-zA-Z-_. ()]", " ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdNameVerifier", "stripBadCharacters"));
        }
        return string;
    }

    @NotNull
    public static String stripBadCharactersAndCollapse(@NotNull String candidateName) {
        if (candidateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateName", "com/android/tools/idea/avdmanager/AvdNameVerifier", "stripBadCharactersAndCollapse"));
        }
        String string = candidateName.replaceAll("[^0-9a-zA-Z-_. ()]", " ").trim().replaceAll("[ _]+", "_");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdNameVerifier", "stripBadCharactersAndCollapse"));
        }
        return string;
    }

    @NotNull
    public static String humanReadableAllowedCharacters() {
        if (ALLOWED_CHARS_READABLE == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdNameVerifier", "humanReadableAllowedCharacters"));
        }
        return ALLOWED_CHARS_READABLE;
    }
}

