/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.actions;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceUtil;
import com.android.tools.idea.editors.gfxtrace.UiCallback;
import com.android.tools.idea.editors.gfxtrace.controllers.AtomController;
import com.android.tools.idea.editors.gfxtrace.renderers.Render;
import com.android.tools.idea.editors.gfxtrace.renderers.RenderUtils;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.snippets.Labels;
import com.android.tools.idea.editors.gfxtrace.service.snippets.SnippetObject;
import com.android.tools.rpclib.rpccore.Rpc;
import com.android.tools.rpclib.rpccore.RpcException;
import com.android.tools.rpclib.schema.Constant;
import com.android.tools.rpclib.schema.ConstantSet;
import com.android.tools.rpclib.schema.Dynamic;
import com.android.tools.rpclib.schema.Method;
import com.android.tools.rpclib.schema.Primitive;
import com.android.tools.rpclib.schema.Type;
import com.android.tools.swing.util.FloatFilter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.AbstractDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditAtomParametersAction
extends AbstractAction {
    @NotNull
    private static final Logger LOG = Logger.getInstance(EditAtomParametersAction.class);
    @NotNull
    private Editor[] myEditors;
    @NotNull
    private GfxTraceEditor myGfxTraceEditor;
    @NotNull
    private AtomController.Node myNode;

    private EditAtomParametersAction(@NotNull GfxTraceEditor traceEditor, @NotNull AtomController.Node node, @NotNull Editor[] editors) {
        if (traceEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceEditor", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction", "<init>"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction", "<init>"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction", "<init>"));
        }
        super("Edit");
        this.myEditors = editors;
        this.myGfxTraceEditor = traceEditor;
        this.myNode = node;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent parent = this.myGfxTraceEditor.getComponent();
        final String title = "Edit " + this.myNode.atom.getName();
        int result = JOptionPane.showOptionDialog(parent, this.buildDialog(), title, 2, -1, null, null, null);
        if (result == 0) {
            Dynamic newAtom = ((Dynamic)this.myNode.atom.unwrap()).copy();
            for (Editor editor : this.myEditors) {
                if (!editor.hasEditComponent()) continue;
                newAtom.setFieldValue(editor.myFieldIndex, editor.getValue());
            }
            final AtomPath oldPath = this.myGfxTraceEditor.getAtomStream().getPath().index(this.myNode.index);
            GfxTraceUtil.trackEvent("gfxTraceParameterEdited", oldPath.toString(), null);
            Rpc.listen(this.myGfxTraceEditor.getClient().set(oldPath, newAtom), (Logger)LOG, (Rpc.Callback)new UiCallback<Path, Path>(){

                @Override
                protected Path onRpcThread(Rpc.Result<Path> result) throws RpcException, ExecutionException {
                    return (Path)result.get();
                }

                @Override
                protected void onUiThread(Path newPath) {
                    new ActivatePathCommand(title, oldPath, newPath).execute();
                }
            });
        }
    }

    @NotNull
    private JComponent buildDialog() {
        JPanel fields = new JPanel(new GridBagLayout());
        GridBag bag = new GridBag().setDefaultAnchor(13).setDefaultFill(2).setDefaultWeightX(1, 1.0).setDefaultPaddingX(5);
        for (Editor editor : this.myEditors) {
            String typeString = editor.myType instanceof Primitive ? " (" + ((Primitive)editor.myType).getMethod() + ")" : "";
            fields.add((Component)new JBLabel(this.myNode.atom.getFieldInfo(editor.myFieldIndex).getName() + typeString), bag.nextLine().next());
            fields.add((Component)editor.getComponent(), bag.next());
        }
        JPanel jPanel = fields;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction", "buildDialog"));
        }
        return jPanel;
    }

    @Nullable
    public static EditAtomParametersAction getEditActionFor(@NotNull AtomController.Node node, @NotNull GfxTraceEditor traceEditor) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction", "getEditActionFor"));
        }
        if (traceEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceEditor", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction", "getEditActionFor"));
        }
        ArrayList editors = Lists.newArrayList();
        int resultIndex = node.atom.getResultIndex();
        int extrasIndex = node.atom.getExtrasIndex();
        boolean found = false;
        for (int i = 0; i < node.atom.getFieldCount(); ++i) {
            if (i == resultIndex || i == extrasIndex) continue;
            SnippetObject snippetObject = SnippetObject.param(node.atom, i);
            Object value = node.atom.getFieldValue(i);
            Editor editor = Editor.getFor(node.atom.getFieldInfo(i).getType(), value, snippetObject, i);
            editors.add(editor);
            found |= editor.hasEditComponent();
        }
        return found ? new EditAtomParametersAction(traceEditor, node, editors.toArray(new Editor[editors.size()])) : null;
    }

    private static class FlagEditor
    extends Editor {
        private final CheckBoxList<Constant> myFlagList;

        FlagEditor(@NotNull SnippetObject currentValue, @NotNull Type type, int fieldIndex, @NotNull List<Constant> constants, @NotNull Collection<Constant> constant) {
            if (currentValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentValue", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$FlagEditor", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$FlagEditor", "<init>"));
            }
            if (constants == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constants", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$FlagEditor", "<init>"));
            }
            if (constant == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constant", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$FlagEditor", "<init>"));
            }
            super(currentValue, type, fieldIndex);
            this.myFlagList = new CheckBoxList();
            this.myFlagList.setItems(constants, null);
            for (Constant con : constant) {
                this.myFlagList.setItemSelected((Object)con, true);
            }
        }

        @NotNull
        CheckBoxList<Constant> getComponent() {
            CheckBoxList<Constant> checkBoxList = this.myFlagList;
            if (checkBoxList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$FlagEditor", "getComponent"));
            }
            return checkBoxList;
        }

        @Override
        @Nullable
        Number getValue() {
            long result = 0L;
            for (int c = 0; c < this.myFlagList.getItemsCount(); ++c) {
                if (!this.myFlagList.isItemSelected(c)) continue;
                Constant flag = (Constant)this.myFlagList.getItemAt(c);
                assert (flag != null);
                result |= ((Number)flag.getValue()).longValue();
            }
            return result;
        }
    }

    private static class EnumEditor
    extends Editor {
        private final JComboBox<Constant> myCombo;

        EnumEditor(@NotNull SnippetObject currentValue, @NotNull Type type, int fieldIndex, @NotNull List<Constant> constants, @NotNull Constant constant) {
            if (currentValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentValue", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$EnumEditor", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$EnumEditor", "<init>"));
            }
            if (constants == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constants", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$EnumEditor", "<init>"));
            }
            if (constant == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constant", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$EnumEditor", "<init>"));
            }
            super(currentValue, type, fieldIndex);
            this.myCombo = new ComboBox(new DefaultComboBoxModel<Constant>(new Vector<Constant>(constants)));
            this.myCombo.setSelectedItem(constant);
        }

        @Override
        @NotNull
        JComboBox<Constant> getComponent() {
            JComboBox<Constant> jComboBox = this.myCombo;
            if (jComboBox == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$EnumEditor", "getComponent"));
            }
            return jComboBox;
        }

        @Override
        @Nullable
        Object getValue() {
            Constant value = (Constant)this.myCombo.getSelectedItem();
            return value.getValue();
        }
    }

    private static class StringEditor
    extends Editor {
        private final JTextField textField;

        StringEditor(@NotNull SnippetObject currentValue, @NotNull Type type, int fieldIndex, @Nullable Object value) {
            if (currentValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentValue", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$StringEditor", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$StringEditor", "<init>"));
            }
            super(currentValue, type, fieldIndex);
            this.textField = new JTextField(String.valueOf(value));
        }

        @Override
        @NotNull
        JTextField getComponent() {
            JTextField jTextField = this.textField;
            if (jTextField == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$StringEditor", "getComponent"));
            }
            return jTextField;
        }

        @Override
        @Nullable
        String getValue() {
            return this.textField.getText();
        }
    }

    private static class FloatEditor
    extends Editor {
        private final JTextField myFloatBox;

        FloatEditor(@NotNull SnippetObject currentValue, @NotNull Type type, int fieldIndex, @NotNull Object value) {
            if (currentValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentValue", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$FloatEditor", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$FloatEditor", "<init>"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$FloatEditor", "<init>"));
            }
            super(currentValue, type, fieldIndex);
            this.myFloatBox = new JTextField(String.valueOf(value));
            ((AbstractDocument)this.myFloatBox.getDocument()).setDocumentFilter(new FloatFilter());
        }

        @Override
        @NotNull
        JTextField getComponent() {
            JTextField jTextField = this.myFloatBox;
            if (jTextField == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$FloatEditor", "getComponent"));
            }
            return jTextField;
        }

        @Override
        @Nullable
        Number getValue() {
            String text = this.myFloatBox.getText();
            return Double.parseDouble(text);
        }
    }

    private static class IntEditor
    extends Editor {
        private final JSpinner mySpinner;

        IntEditor(@NotNull SnippetObject currentValue, @NotNull Type type, int fieldIndex, @NotNull Object value) {
            if (currentValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentValue", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$IntEditor", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$IntEditor", "<init>"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$IntEditor", "<init>"));
            }
            super(currentValue, type, fieldIndex);
            Method method = ((Primitive)type).getMethod();
            if (method == Method.Uint8 || method == Method.Uint16 || method == Method.Uint32 || method == Method.Uint64) {
                Number javaValue = RenderUtils.toJavaIntType(method, (Number)value);
                Comparable<? extends Number> zero = IntEditor.getZero(javaValue.getClass());
                Comparable<? extends Number> max = IntEditor.getUnsignedMax(method);
                this.mySpinner = new JSpinner(new SpinnerNumberModel(javaValue, zero, max, (Number)1));
            } else {
                this.mySpinner = new JSpinner();
                this.mySpinner.setValue(value);
            }
        }

        @Override
        @NotNull
        JSpinner getComponent() {
            JSpinner jSpinner = this.mySpinner;
            if (jSpinner == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$IntEditor", "getComponent"));
            }
            return jSpinner;
        }

        @Override
        @Nullable
        Object getValue() {
            return this.mySpinner.getValue();
        }

        @NotNull
        private static Comparable<? extends Number> getZero(@NotNull Class<? extends Number> numberClass) {
            if (numberClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "numberClass", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$IntEditor", "getZero"));
            }
            if (numberClass == Byte.class) {
                Byte by = 0;
                if (by == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$IntEditor", "getZero"));
                }
                return by;
            }
            if (numberClass == Short.class) {
                Short s = 0;
                if (s == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$IntEditor", "getZero"));
                }
                return s;
            }
            if (numberClass == Integer.class) {
                Integer n = 0;
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$IntEditor", "getZero"));
                }
                return n;
            }
            if (numberClass == Long.class) {
                Long l = 0L;
                if (l == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$IntEditor", "getZero"));
                }
                return l;
            }
            if (numberClass == BigInteger.class) {
                BigInteger bigInteger = BigInteger.ZERO;
                if (bigInteger == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$IntEditor", "getZero"));
                }
                return bigInteger;
            }
            throw new IllegalArgumentException("unknown number class " + numberClass);
        }

        @NotNull
        private static Comparable<? extends Number> getUnsignedMax(@NotNull Method type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$IntEditor", "getUnsignedMax"));
            }
            if (type == Method.Uint8) {
                Short s = 255;
                if (s == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$IntEditor", "getUnsignedMax"));
                }
                return s;
            }
            if (type == Method.Uint16) {
                Integer n = 65535;
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$IntEditor", "getUnsignedMax"));
                }
                return n;
            }
            if (type == Method.Uint32) {
                Long l = 0xFFFFFFFFL;
                if (l == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$IntEditor", "getUnsignedMax"));
                }
                return l;
            }
            if (type == Method.Uint64) {
                BigInteger bigInteger = new BigInteger("18446744073709551615");
                if (bigInteger == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$IntEditor", "getUnsignedMax"));
                }
                return bigInteger;
            }
            throw new IllegalArgumentException("not unsigned type" + type);
        }
    }

    private static class BooleanEditor
    extends Editor {
        private final JCheckBox myCheckBox;

        BooleanEditor(@NotNull SnippetObject currentValue, @NotNull Type type, int fieldIndex, @Nullable Object value) {
            if (currentValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentValue", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$BooleanEditor", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$BooleanEditor", "<init>"));
            }
            super(currentValue, type, fieldIndex);
            this.myCheckBox = new JCheckBox();
            this.myCheckBox.setSelected(Boolean.parseBoolean(String.valueOf(value)));
        }

        @Override
        @NotNull
        JCheckBox getComponent() {
            JCheckBox jCheckBox = this.myCheckBox;
            if (jCheckBox == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$BooleanEditor", "getComponent"));
            }
            return jCheckBox;
        }

        @Override
        @Nullable
        Boolean getValue() {
            return this.myCheckBox.isSelected();
        }
    }

    private static class NoEditor
    extends Editor {
        NoEditor(@NotNull SnippetObject currentValue, @NotNull Type type, int fieldIndex) {
            if (currentValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentValue", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$NoEditor", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$NoEditor", "<init>"));
            }
            super(currentValue, type, fieldIndex);
        }

        @Override
        public boolean hasEditComponent() {
            return false;
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            SimpleColoredComponent result = new SimpleColoredComponent();
            Render.render(this.myCurrentValue, this.myType, result, SimpleTextAttributes.REGULAR_ATTRIBUTES, -1);
            SimpleColoredComponent simpleColoredComponent = result;
            if (simpleColoredComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$NoEditor", "getComponent"));
            }
            return simpleColoredComponent;
        }

        @Override
        Object getValue() {
            throw new IllegalStateException();
        }
    }

    private static abstract class Editor {
        public final SnippetObject myCurrentValue;
        public final Type myType;
        public final int myFieldIndex;

        Editor(@NotNull SnippetObject currentValue, @NotNull Type type, int fieldIndex) {
            if (currentValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentValue", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$Editor", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$Editor", "<init>"));
            }
            this.myCurrentValue = currentValue;
            this.myType = type;
            this.myFieldIndex = fieldIndex;
        }

        @NotNull
        public static Editor getFor(@NotNull Type type, @Nullable Object value, @NotNull SnippetObject snippetObject, int fieldIndex) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$Editor", "getFor"));
            }
            if (snippetObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "snippetObject", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$Editor", "getFor"));
            }
            if (type instanceof Primitive) {
                Primitive primitive = (Primitive)type;
                Collection<Constant> constant = Render.findConstant(snippetObject, primitive);
                if (constant.size() >= 1) {
                    List<Constant> preferred;
                    List<Constant> constants = Arrays.asList(ConstantSet.lookup((Type)type).getEntries());
                    Labels labels = Labels.fromSnippets(snippetObject.getSnippets());
                    if (labels != null && (preferred = labels.preferred(constants)).containsAll(constant)) {
                        constants = preferred;
                    }
                    if (constant.size() == 1) {
                        EnumEditor enumEditor = new EnumEditor(snippetObject, type, fieldIndex, constants, (Constant)Iterables.get(constant, (int)0));
                        if (enumEditor == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$Editor", "getFor"));
                        }
                        return enumEditor;
                    }
                    FlagEditor flagEditor = new FlagEditor(snippetObject, type, fieldIndex, constants, constant);
                    if (flagEditor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$Editor", "getFor"));
                    }
                    return flagEditor;
                }
                Method method = primitive.getMethod();
                if (method == Method.Bool) {
                    BooleanEditor booleanEditor = new BooleanEditor(snippetObject, type, fieldIndex, value);
                    if (booleanEditor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$Editor", "getFor"));
                    }
                    return booleanEditor;
                }
                if (method == Method.Float32 || method == Method.Float64) {
                    assert (value != null);
                    FloatEditor floatEditor = new FloatEditor(snippetObject, type, fieldIndex, value);
                    if (floatEditor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$Editor", "getFor"));
                    }
                    return floatEditor;
                }
                if (method == Method.String) {
                    StringEditor stringEditor = new StringEditor(snippetObject, type, fieldIndex, value);
                    if (stringEditor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$Editor", "getFor"));
                    }
                    return stringEditor;
                }
                assert (value != null);
                IntEditor intEditor = new IntEditor(snippetObject, type, fieldIndex, value);
                if (intEditor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$Editor", "getFor"));
                }
                return intEditor;
            }
            NoEditor noEditor = new NoEditor(snippetObject, type, fieldIndex);
            if (noEditor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$Editor", "getFor"));
            }
            return noEditor;
        }

        public boolean hasEditComponent() {
            return true;
        }

        @NotNull
        abstract JComponent getComponent();

        @Nullable
        abstract Object getValue();
    }

    class ActivatePathCommand
    implements Runnable,
    UndoableAction {
        @NotNull
        private final String myName;
        @NotNull
        private final Path myOldPath;
        @NotNull
        private final Path myNewPath;

        ActivatePathCommand(@NotNull String name, @NotNull Path oldPath, Path newPath) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$ActivatePathCommand", "<init>"));
            }
            if (oldPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldPath", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$ActivatePathCommand", "<init>"));
            }
            if (newPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newPath", "com/android/tools/idea/editors/gfxtrace/actions/EditAtomParametersAction$ActivatePathCommand", "<init>"));
            }
            this.myName = name;
            this.myOldPath = oldPath;
            this.myNewPath = newPath;
        }

        public void execute() {
            CommandProcessor.getInstance().executeCommand(EditAtomParametersAction.this.myGfxTraceEditor.getProject(), (Runnable)this, this.myName, null, UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION);
        }

        @Override
        public void run() {
            EditAtomParametersAction.this.myGfxTraceEditor.activatePath(this.myNewPath, EditAtomParametersAction.this);
            UndoManager.getInstance((Project)EditAtomParametersAction.this.myGfxTraceEditor.getProject()).undoableActionPerformed((UndoableAction)this);
        }

        public void undo() throws UnexpectedUndoException {
            EditAtomParametersAction.this.myGfxTraceEditor.activatePath(this.myOldPath, EditAtomParametersAction.this);
        }

        public void redo() throws UnexpectedUndoException {
            EditAtomParametersAction.this.myGfxTraceEditor.activatePath(this.myNewPath, EditAtomParametersAction.this);
        }

        @Nullable
        public DocumentReference[] getAffectedDocuments() {
            return null;
        }

        public boolean isGlobal() {
            return true;
        }
    }
}

