/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.models;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.UiErrorCallback;
import com.android.tools.idea.editors.gfxtrace.service.ErrDataUnavailable;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomRangePath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.android.tools.idea.editors.gfxtrace.service.path.PathStore;
import com.android.tools.idea.editors.gfxtrace.service.path.StatePath;
import com.android.tools.rpclib.futures.FutureController;
import com.android.tools.rpclib.futures.SingleInFlight;
import com.android.tools.rpclib.rpccore.Rpc;
import com.android.tools.rpclib.rpccore.RpcException;
import com.android.tools.rpclib.schema.Dynamic;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;

public class GpuState
implements PathListener {
    private static final Logger LOG = Logger.getInstance(GpuState.class);
    private static final Path NO_SELECTION = Path.EMPTY;
    private final GfxTraceEditor myEditor;
    private final PathStore<StatePath> myStatePath = new PathStore();
    private final SingleInFlight myReqController = new SingleInFlight(new SingleInFlight.Listener(){

        public void onIdleToWorking() {
            GpuState.this.myListeners.onStateLoadingStart(GpuState.this);
        }

        public void onWorkingToIdle() {
        }
    });
    private final Listeners myListeners = new Listeners();
    private Dynamic myState;
    private Path mySelection = NO_SELECTION;
    private Path myCachedSelection = NO_SELECTION;

    public GpuState(GfxTraceEditor editor) {
        this.myEditor = editor;
    }

    @Override
    public void notifyPath(PathListener.PathEvent event) {
        if (this.myStatePath.updateIfNotNull(AtomRangePath.stateAfterLast(event.findAtomPath()))) {
            Rpc.listen(this.myEditor.getClient().get(this.myStatePath.getPath()), (Logger)LOG, (FutureController)this.myReqController, (Rpc.Callback)new UiErrorCallback<Object, Dynamic, ErrDataUnavailable>(){

                @Override
                protected UiErrorCallback.ResultOrError<Dynamic, ErrDataUnavailable> onRpcThread(Rpc.Result<Object> result) throws RpcException, ExecutionException {
                    try {
                        return this.success((Dynamic)result.get());
                    }
                    catch (ErrDataUnavailable e) {
                        return this.error(e);
                    }
                }

                @Override
                protected void onUiThreadSuccess(Dynamic result) {
                    GpuState.this.update(result);
                }

                @Override
                protected void onUiThreadError(ErrDataUnavailable error) {
                    GpuState.this.update(error);
                }
            });
        }
        if (event.findStatePath() != null) {
            if (this.myState == null) {
                this.myCachedSelection = event.path;
            } else {
                this.mySelection = event.path;
                this.myCachedSelection = NO_SELECTION;
                this.myListeners.onStateSelection(this, this.mySelection);
            }
        }
    }

    protected void update(Dynamic state) {
        this.myState = state;
        this.myListeners.onStateLoadingSuccess(this);
        if (this.myCachedSelection.getParent() != null) {
            this.mySelection = this.myCachedSelection;
            this.myCachedSelection = NO_SELECTION;
            this.myListeners.onStateSelection(this, this.mySelection);
        }
    }

    protected void update(ErrDataUnavailable error) {
        this.myState = null;
        this.myListeners.onStateLoadingFailure(this, error);
    }

    public StatePath getPath() {
        return this.myStatePath.getPath();
    }

    public Dynamic getState() {
        return this.myState;
    }

    public Path getSelection() {
        return this.myCachedSelection.getParent() == null ? this.mySelection : this.myCachedSelection;
    }

    public void addListener(Listener listener) {
        this.myListeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.myListeners.remove(listener);
    }

    private static class Listeners
    extends ArrayList<Listener>
    implements Listener {
        private Listeners() {
        }

        @Override
        public void onStateLoadingStart(GpuState state) {
            for (Listener listener : this.toArray(new Listener[this.size()])) {
                listener.onStateLoadingStart(state);
            }
        }

        @Override
        public void onStateLoadingFailure(GpuState state, ErrDataUnavailable error) {
            for (Listener listener : this.toArray(new Listener[this.size()])) {
                listener.onStateLoadingFailure(state, error);
            }
        }

        @Override
        public void onStateLoadingSuccess(GpuState state) {
            for (Listener listener : this.toArray(new Listener[this.size()])) {
                listener.onStateLoadingSuccess(state);
            }
        }

        @Override
        public void onStateSelection(GpuState state, Path selection) {
            for (Listener listener : this.toArray(new Listener[this.size()])) {
                listener.onStateSelection(state, selection);
            }
        }

        @Override
        public synchronized <T> T[] toArray(T[] a) {
            return super.toArray(a);
        }

        @Override
        public synchronized boolean add(Listener listener) {
            return super.add(listener);
        }

        @Override
        public synchronized boolean remove(Object o) {
            return super.remove(o);
        }
    }

    public static interface Listener {
        public void onStateLoadingStart(GpuState var1);

        public void onStateLoadingFailure(GpuState var1, ErrDataUnavailable var2);

        public void onStateLoadingSuccess(GpuState var1);

        public void onStateSelection(GpuState var1, Path var2);
    }
}

