/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service.atom;

import com.android.tools.idea.editors.gfxtrace.service.ApiID;
import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.binary.Namespace;
import com.android.tools.rpclib.schema.Array;
import com.android.tools.rpclib.schema.Entity;
import com.android.tools.rpclib.schema.Field;
import com.android.tools.rpclib.schema.Interface;
import com.android.tools.rpclib.schema.Method;
import com.android.tools.rpclib.schema.Primitive;
import com.android.tools.rpclib.schema.Slice;
import com.android.tools.rpclib.schema.Type;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class AtomMetadata
implements BinaryObject {
    public static final AtomMetadata NO_METADATA = new AtomMetadata().setDisplayName("<unknown>");
    boolean myIsPrepared = false;
    int myResultIndex = -1;
    int myExtrasIndex = -1;
    @NotNull
    private static final Logger LOG = Logger.getInstance(AtomMetadata.class);
    private ApiID myAPI;
    private String myDisplayName;
    private boolean myEndOfFrame;
    private boolean myDrawCall;
    private String myDocumentationUrl;
    private static final Entity ENTITY = new Entity("atom", "Metadata", "", "");

    public static AtomMetadata find(Entity c) {
        for (BinaryObject o : c.getMetadata()) {
            if (!(o instanceof AtomMetadata)) continue;
            AtomMetadata meta = (AtomMetadata)o;
            meta.prepare(c);
            return meta;
        }
        return NO_METADATA;
    }

    private void prepare(Entity c) {
        if (this.myIsPrepared) {
            return;
        }
        this.myIsPrepared = true;
        for (int index = 0; index < c.getFields().length; ++index) {
            Type vt;
            Field field = c.getFields()[index];
            if (field.getDeclared().equals("Result")) {
                this.myResultIndex = index;
            }
            if (!(field.getType() instanceof Slice) || !((vt = ((Slice)field.getType()).getValueType()) instanceof Interface) || !"atom.Extra".equals(((Interface)vt).name)) continue;
            this.myExtrasIndex = index;
        }
        if (this.myDisplayName == null) {
            this.myDisplayName = "<unknown>";
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtomMetadata that = (AtomMetadata)o;
        if (this.myIsPrepared != that.myIsPrepared) {
            return false;
        }
        if (this.myResultIndex != that.myResultIndex) {
            return false;
        }
        if (this.myExtrasIndex != that.myExtrasIndex) {
            return false;
        }
        if (this.myEndOfFrame != that.myEndOfFrame) {
            return false;
        }
        if (this.myDrawCall != that.myDrawCall) {
            return false;
        }
        if (this.myAPI != null ? !this.myAPI.equals((Object)that.myAPI) : that.myAPI != null) {
            return false;
        }
        if (this.myDisplayName != null ? !this.myDisplayName.equals(that.myDisplayName) : that.myDisplayName != null) {
            return false;
        }
        return !(this.myDocumentationUrl != null ? !this.myDocumentationUrl.equals(that.myDocumentationUrl) : that.myDocumentationUrl != null);
    }

    public int hashCode() {
        int result = this.myIsPrepared ? 1 : 0;
        result = 31 * result + this.myResultIndex;
        result = 31 * result + this.myExtrasIndex;
        result = 31 * result + (this.myAPI != null ? this.myAPI.hashCode() : 0);
        result = 31 * result + (this.myDisplayName != null ? this.myDisplayName.hashCode() : 0);
        result = 31 * result + (this.myEndOfFrame ? 1 : 0);
        result = 31 * result + (this.myDrawCall ? 1 : 0);
        result = 31 * result + (this.myDocumentationUrl != null ? this.myDocumentationUrl.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AtomMetadata{prepared=" + this.myIsPrepared + ", resultIndex=" + this.myResultIndex + ", extrasIndex=" + this.myExtrasIndex + ", API=" + (Object)((Object)this.myAPI) + ", displayName='" + this.myDisplayName + '\'' + ", endOfFrame=" + this.myEndOfFrame + ", drawCall=" + this.myDrawCall + ", documentationUrl='" + this.myDocumentationUrl + '\'' + '}';
    }

    public ApiID getAPI() {
        return this.myAPI;
    }

    public AtomMetadata setAPI(ApiID v) {
        this.myAPI = v;
        return this;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public AtomMetadata setDisplayName(String v) {
        this.myDisplayName = v;
        return this;
    }

    public boolean getEndOfFrame() {
        return this.myEndOfFrame;
    }

    public AtomMetadata setEndOfFrame(boolean v) {
        this.myEndOfFrame = v;
        return this;
    }

    public boolean getDrawCall() {
        return this.myDrawCall;
    }

    public AtomMetadata setDrawCall(boolean v) {
        this.myDrawCall = v;
        return this;
    }

    public String getDocumentationUrl() {
        return this.myDocumentationUrl;
    }

    public AtomMetadata setDocumentationUrl(String v) {
        this.myDocumentationUrl = v;
        return this;
    }

    @NotNull
    public BinaryClass klass() {
        Klass klass = Klass.INSTANCE;
        if (klass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/service/atom/AtomMetadata", "klass"));
        }
        return klass;
    }

    public static void register() {
    }

    static {
        ENTITY.setFields(new Field[]{new Field("API", (Type)new Array("gfxapi.ID", (Type)new Primitive("byte", Method.Uint8), 20)), new Field("DisplayName", (Type)new Primitive("string", Method.String)), new Field("EndOfFrame", (Type)new Primitive("bool", Method.Bool)), new Field("DrawCall", (Type)new Primitive("bool", Method.Bool)), new Field("DocumentationUrl", (Type)new Primitive("string", Method.String))});
        Namespace.register((BinaryClass)Klass.INSTANCE);
    }

    public static enum Klass implements BinaryClass
    {
        INSTANCE;


        @NotNull
        public Entity entity() {
            Entity entity = ENTITY;
            if (entity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/service/atom/AtomMetadata$Klass", "entity"));
            }
            return entity;
        }

        @NotNull
        public BinaryObject create() {
            AtomMetadata atomMetadata = new AtomMetadata();
            if (atomMetadata == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/service/atom/AtomMetadata$Klass", "create"));
            }
            return atomMetadata;
        }

        public void encode(@NotNull Encoder e, BinaryObject obj) throws IOException {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/editors/gfxtrace/service/atom/AtomMetadata$Klass", "encode"));
            }
            AtomMetadata o = (AtomMetadata)obj;
            o.myAPI.write(e);
            e.string(o.myDisplayName);
            e.bool(o.myEndOfFrame);
            e.bool(o.myDrawCall);
            e.string(o.myDocumentationUrl);
        }

        public void decode(@NotNull Decoder d, BinaryObject obj) throws IOException {
            if (d == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/idea/editors/gfxtrace/service/atom/AtomMetadata$Klass", "decode"));
            }
            AtomMetadata o = (AtomMetadata)obj;
            o.myAPI = new ApiID(d);
            o.myDisplayName = d.string();
            o.myEndOfFrame = d.bool();
            o.myDrawCall = d.bool();
            o.myDocumentationUrl = d.string();
        }
    }
}

