/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service.path;

import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomRangePath;
import com.android.tools.idea.editors.gfxtrace.service.path.CapturePath;
import com.android.tools.idea.editors.gfxtrace.service.path.ContextPath;
import com.android.tools.idea.editors.gfxtrace.service.path.DevicePath;
import com.android.tools.idea.editors.gfxtrace.service.path.MemoryRangePath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.path.StatePath;
import com.android.tools.idea.editors.gfxtrace.service.path.TypedMemoryPath;

public interface PathListener {
    public void notifyPath(PathEvent var1);

    public static class PathEvent {
        public final Path path;
        public final Object source;

        public PathEvent(Path path, Object source) {
            this.path = path;
            this.source = source;
        }

        public <T extends Path> T findPathOfType(Class<T> cls) {
            for (Path p = this.path; p != null; p = p.getParent()) {
                if (!cls.isInstance(p)) continue;
                return (T)((Path)cls.cast(p));
            }
            return null;
        }

        public DevicePath findDevicePath() {
            return this.findPathOfType(DevicePath.class);
        }

        public CapturePath findCapturePath() {
            return this.findPathOfType(CapturePath.class);
        }

        public AtomRangePath findAtomPath() {
            AtomPath singleAtomPath;
            AtomRangePath result = this.findPathOfType(AtomRangePath.class);
            if (result == null && (singleAtomPath = this.findPathOfType(AtomPath.class)) != null) {
                result = new AtomRangePath().setAtoms(singleAtomPath.getAtoms()).setFirst(singleAtomPath.getIndex()).setCount(1L);
            }
            return result;
        }

        public MemoryRangePath findMemoryPath() {
            return this.findPathOfType(MemoryRangePath.class);
        }

        public TypedMemoryPath findTypedMemoryPath() {
            return this.findPathOfType(TypedMemoryPath.class);
        }

        public StatePath findStatePath() {
            return this.findPathOfType(StatePath.class);
        }

        public ContextPath findContextPath() {
            return this.findPathOfType(ContextPath.class);
        }
    }
}

