/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.viewer.camera;

import com.android.tools.idea.editors.gfxtrace.viewer.geo.BoundingBox;
import com.android.tools.idea.editors.gfxtrace.viewer.vec.VecD;

public interface Emitter {
    public double getOffset();

    public double getPotentialAt(VecD var1);

    public static class BoxEmitter
    implements Emitter {
        private static final double RADIUS = 0.2;
        private static final double MIN_SIZE = 0.41600000000000004;
        private final VecD mySize;
        private final VecD myCenter;
        private final double myRadiusSquared;
        private final double myOffset;

        public BoxEmitter(VecD min, VecD max, double radiusSquared, double offset) {
            this.mySize = max.subtract(min).scale(0.5);
            this.myCenter = min.add(this.mySize);
            this.myRadiusSquared = radiusSquared;
            this.myOffset = offset;
        }

        public static BoxEmitter fromBoundingBox(BoundingBox bbox) {
            VecD min = VecD.fromArray(bbox.min);
            VecD max = VecD.fromArray(bbox.max);
            VecD size = max.subtract(min);
            VecD delta = size.subtract(size.subtract(0.4).max(0.41600000000000004)).scale(0.5);
            min = min.add(delta);
            max = max.subtract(delta);
            return new BoxEmitter(min, max, 0.04000000000000001, Math.max(size.x, Math.max(size.y, size.z)));
        }

        @Override
        public double getOffset() {
            return this.myOffset;
        }

        @Override
        public double getPotentialAt(VecD pos) {
            VecD d = pos.subtract(this.myCenter).abs().subtract(this.mySize);
            double r = Math.max(d.x, Math.max(d.y, d.z));
            if (r < 0.0) {
                return -(r * r + this.myRadiusSquared);
            }
            d = d.max(0.0);
            return d.magnitudeSquared() - this.myRadiusSquared;
        }
    }
}

