/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.viewer.camera;

import com.android.tools.idea.editors.gfxtrace.viewer.CameraModel;
import com.android.tools.idea.editors.gfxtrace.viewer.camera.Emitter;
import com.android.tools.idea.editors.gfxtrace.viewer.camera.RayCaster;
import com.android.tools.idea.editors.gfxtrace.viewer.vec.MatD;
import com.android.tools.idea.editors.gfxtrace.viewer.vec.VecD;

public class IsoSurfaceCameraModel
implements CameraModel {
    private static final double SMOOTHNESS_ROTATION = 0.8;
    private static final int SMOOTHNESS_GRID_SIZE = 5;
    private static final int INDEX_OF_Y1_X0 = 17;
    private final CameraModel myBase;
    private RayCaster myRayCaster;
    private double myInflation;
    private MatD myViewTransform = MatD.IDENTITY;
    private double myLastDistance = 1.0;

    public IsoSurfaceCameraModel(CameraModel base) {
        this.myBase = base;
        this.update();
    }

    public void setEmitter(Emitter emitter) {
        this.myRayCaster = new RayCaster(emitter);
        this.myInflation = Math.max(0.0, 3.0 - emitter.getOffset());
    }

    @Override
    public void updateViewport(double screenWidth, double screenHeight) {
        this.myBase.updateViewport(screenWidth, screenHeight);
    }

    @Override
    public void onDrag(double dx, double dy) {
        this.myBase.onDrag(dx, dy);
        this.update();
    }

    @Override
    public void onZoom(double dz) {
        this.myBase.onZoom(dz);
        this.update();
    }

    private void update() {
        if (this.myRayCaster == null || this.myBase.getZoom() == 0.0 || !this.updateUsingIsoSurface()) {
            this.myViewTransform = this.myBase.getViewTransform();
        }
    }

    private boolean updateUsingIsoSurface() {
        double[] m = this.myBase.getViewTransform().inverseOfTop3x3();
        VecD up = new VecD(m[3], m[4], m[5]).normalize();
        VecD direction = new VecD(-m[6], -m[7], -m[8]).normalize();
        return this.evaluateIsoSurface(up, direction);
    }

    private boolean evaluateIsoSurface(VecD up, VecD direction) {
        int x;
        VecD pos = this.getFirstIntersectionWithHint(direction);
        if (pos == null) {
            return false;
        }
        VecD right = direction.cross(up).normalize().scale(0.16);
        up = up.scale(0.16);
        VecD[] grid = new VecD[25];
        int size = 2;
        int index = 0;
        for (int y = -size; y <= size; ++y) {
            x = -size;
            while (x <= size) {
                grid[index] = pos.addScaled(up, y).addScaled(right, x);
                VecD dir = grid[index].scale(-1.0).normalize();
                grid[index] = this.myRayCaster.getIntersection(grid[index], dir);
                if (grid[index] == null) {
                    return false;
                }
                ++x;
                ++index;
            }
        }
        VecD normal = new VecD();
        for (int y = 0; y < 4; ++y) {
            for (x = 0; x < 4; ++x) {
                int p0 = y * 5 + x;
                int p1 = (y + 1) * 5 + x;
                int p2 = y * 5 + x + 1;
                VecD upOffset = grid[p1].subtract(grid[p0]);
                VecD rightOffset = grid[p2].subtract(grid[p0]);
                normal = normal.add(rightOffset.cross(upOffset).normalize());
            }
        }
        normal = normal.normalize();
        up = grid[17].subtract(pos).normalize();
        pos = pos.addScaled(normal, this.myInflation);
        double zoom = this.getZoom();
        normal = normal.scale(-1.0).lerp(direction, zoom);
        pos = pos.lerp(direction.scale(-4.5), zoom);
        this.myViewTransform = MatD.lookAt(pos, pos.add(normal), up);
        return true;
    }

    private VecD getFirstIntersectionWithHint(VecD direction) {
        VecD pos = direction.scale(-this.myLastDistance);
        VecD result = this.myRayCaster.getIntersection(pos, direction);
        if (result != null) {
            this.myLastDistance = result.magnitude();
            return result;
        }
        return null;
    }

    @Override
    public MatD getViewTransform() {
        return this.myViewTransform;
    }

    @Override
    public MatD getProjection() {
        return this.myBase.getProjection();
    }

    @Override
    public double getZoom() {
        return this.myBase.getZoom();
    }
}

