/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.repositories.search;

import com.android.tools.idea.gradle.structure.model.repositories.search.FoundArtifact;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchResult {
    @NotNull
    private final String myRepositoryName;
    @NotNull
    private final List<FoundArtifact> myArtifacts;
    @Nullable
    private final Exception myError;
    private final int myTotalFound;

    SearchResult(@NotNull String repositoryName, @NotNull Exception error) {
        if (repositoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryName", "com/android/tools/idea/gradle/structure/model/repositories/search/SearchResult", "<init>"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/structure/model/repositories/search/SearchResult", "<init>"));
        }
        this(repositoryName, Collections.emptyList(), error, 0);
    }

    SearchResult(@NotNull String repositoryName, @NotNull List<FoundArtifact> artifacts, int totalFound) {
        if (repositoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryName", "com/android/tools/idea/gradle/structure/model/repositories/search/SearchResult", "<init>"));
        }
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/android/tools/idea/gradle/structure/model/repositories/search/SearchResult", "<init>"));
        }
        this(repositoryName, artifacts, null, totalFound);
    }

    private SearchResult(@NotNull String repositoryName, @NotNull List<FoundArtifact> artifacts, @Nullable Exception error, int totalFound) {
        if (repositoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryName", "com/android/tools/idea/gradle/structure/model/repositories/search/SearchResult", "<init>"));
        }
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/android/tools/idea/gradle/structure/model/repositories/search/SearchResult", "<init>"));
        }
        this.myRepositoryName = repositoryName;
        this.myArtifacts = artifacts;
        this.myError = error;
        this.myTotalFound = totalFound;
    }

    @NotNull
    public String getRepositoryName() {
        String string = this.myRepositoryName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/repositories/search/SearchResult", "getRepositoryName"));
        }
        return string;
    }

    @NotNull
    public List<FoundArtifact> getArtifacts() {
        List<FoundArtifact> list = this.myArtifacts;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/repositories/search/SearchResult", "getArtifacts"));
        }
        return list;
    }

    @Nullable
    public Exception getError() {
        return this.myError;
    }

    public int getTotalFound() {
        return this.myTotalFound;
    }

    @NotNull
    public List<String> getArtifactCoordinates() {
        ArrayList coordinates = Lists.newArrayList();
        this.myArtifacts.forEach(artifact -> coordinates.addAll(artifact.getCoordinates()));
        ArrayList arrayList = coordinates;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/repositories/search/SearchResult", "getArtifactCoordinates"));
        }
        return arrayList;
    }

    public String toString() {
        return "{repository='" + this.myRepositoryName + '\'' + ", artifacts=" + this.myArtifacts + ", error=" + this.myError + ", totalFound=" + this.myTotalFound + '}';
    }
}

