/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.manifmerger.Actions;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlNode;
import com.android.resources.ScreenSize;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MergedManifest {
    private final Module myModule;
    private String myPackage;
    private String myApplicationId;
    private Integer myVersionCode;
    private String myManifestTheme;
    private Map<String, ActivityAttributes> myActivityAttributesMap;
    private ManifestInfo.ManifestFile myManifestFile;
    private long myLastChecked;
    private AndroidVersion myMinSdk;
    private AndroidVersion myTargetSdk;
    private String myApplicationIcon;
    private String myApplicationLabel;
    private boolean myApplicationSupportsRtl;
    private Boolean myApplicationDebuggable;
    @Nullable(value="is lazy initialised")
    private Map<String, XmlNode.NodeKey> myNodeKeys;
    private Document myDocument;
    private List<VirtualFile> myManifestFiles;
    private List<Element> myActivities;
    private List<Element> myActivityAliases;
    private List<Element> myServices;

    MergedManifest(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/model/MergedManifest", "<init>"));
        }
        this.myActivities = Collections.emptyList();
        this.myActivityAliases = Collections.emptyList();
        this.myServices = Collections.emptyList();
        this.myModule = module;
    }

    @NotNull
    public static MergedManifest get(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/model/MergedManifest", "get"));
        }
        MergedManifest manifest = (MergedManifest)module.getComponent(MergedManifest.class);
        assert (manifest != null);
        MergedManifest mergedManifest = manifest;
        if (mergedManifest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/MergedManifest", "get"));
        }
        return mergedManifest;
    }

    @NotNull
    public static MergedManifest get(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/model/MergedManifest", "get"));
        }
        MergedManifest mergedManifest = MergedManifest.get(facet.getModule());
        if (mergedManifest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/MergedManifest", "get"));
        }
        return mergedManifest;
    }

    @Nullable
    public Document getDocument() {
        this.sync();
        return this.myDocument;
    }

    @Nullable
    public List<VirtualFile> getManifestFiles() {
        return this.myManifestFiles;
    }

    public void clear() {
        this.myLastChecked = 0L;
    }

    @Nullable
    public String getPackage() {
        this.sync();
        return this.myPackage;
    }

    @Nullable
    public String getApplicationId() {
        this.sync();
        return this.myApplicationId;
    }

    @Nullable
    public Integer getVersionCode() {
        this.sync();
        return this.myVersionCode;
    }

    @NotNull
    public Map<String, ActivityAttributes> getActivityAttributesMap() {
        this.sync();
        if (this.myActivityAttributesMap == null) {
            Map<String, ActivityAttributes> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/MergedManifest", "getActivityAttributesMap"));
            }
            return map;
        }
        Map<String, ActivityAttributes> map = this.myActivityAttributesMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/MergedManifest", "getActivityAttributesMap"));
        }
        return map;
    }

    @Nullable
    public ActivityAttributes getActivityAttributes(@NotNull String activity) {
        if (activity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activity", "com/android/tools/idea/model/MergedManifest", "getActivityAttributes"));
        }
        int index = activity.indexOf(46);
        if (index <= 0 && this.myApplicationId != null && !this.myApplicationId.isEmpty()) {
            activity = this.myApplicationId + (index == -1 ? "." : "") + activity;
        }
        return this.getActivityAttributesMap().get(activity);
    }

    @Nullable
    public String getManifestTheme() {
        this.sync();
        return this.myManifestTheme;
    }

    @NotNull
    public String getDefaultTheme(@Nullable IAndroidTarget renderingTarget, @Nullable ScreenSize screenSize, @Nullable Device device) {
        int targetSdk;
        this.sync();
        if (this.myManifestTheme != null) {
            String string = this.myManifestTheme;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/MergedManifest", "getDefaultTheme"));
            }
            return string;
        }
        if (device != null) {
            if (HardwareConfigHelper.isWear((Device)device)) {
                if ("@android:style/Theme.DeviceDefault.Light" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/MergedManifest", "getDefaultTheme"));
                }
                return "@android:style/Theme.DeviceDefault.Light";
            }
            if (HardwareConfigHelper.isTv((Device)device)) {
                if ("@style/Theme.Leanback" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/MergedManifest", "getDefaultTheme"));
                }
                return "@style/Theme.Leanback";
            }
        }
        AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
        assert (facet != null);
        AndroidModuleInfo info = facet.getAndroidModuleInfo();
        int renderingTargetSdk = targetSdk = info.getTargetSdkVersion().getApiLevel();
        if (renderingTarget instanceof CompatibilityRenderTarget) {
            renderingTargetSdk = renderingTarget.getVersion().getApiLevel();
        } else if (renderingTarget != null) {
            renderingTargetSdk = renderingTarget.getVersion().getApiLevel();
        }
        int apiLevel = Math.min(targetSdk, renderingTargetSdk);
        if (apiLevel >= 21) {
            if ("@android:style/Theme.Material.Light" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/MergedManifest", "getDefaultTheme"));
            }
            return "@android:style/Theme.Material.Light";
        }
        if (apiLevel >= 14 || apiLevel >= 11 && screenSize == ScreenSize.XLARGE) {
            if ("@android:style/Theme.Holo" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/MergedManifest", "getDefaultTheme"));
            }
            return "@android:style/Theme.Holo";
        }
        if ("@android:style/Theme" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/MergedManifest", "getDefaultTheme"));
        }
        return "@android:style/Theme";
    }

    @Nullable
    public String getApplicationIcon() {
        this.sync();
        return this.myApplicationIcon;
    }

    @Nullable
    public String getApplicationLabel() {
        this.sync();
        return this.myApplicationLabel;
    }

    public boolean isRtlSupported() {
        this.sync();
        return this.myApplicationSupportsRtl;
    }

    @Nullable
    public Boolean getApplicationDebuggable() {
        this.sync();
        return this.myApplicationDebuggable;
    }

    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        this.sync();
        AndroidVersion androidVersion = this.myTargetSdk != null ? this.myTargetSdk : this.getMinSdkVersion();
        if (androidVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/MergedManifest", "getTargetSdkVersion"));
        }
        return androidVersion;
    }

    @NotNull
    public AndroidVersion getMinSdkVersion() {
        this.sync();
        AndroidVersion androidVersion = this.myMinSdk != null ? this.myMinSdk : AndroidVersion.DEFAULT;
        if (androidVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/MergedManifest", "getMinSdkVersion"));
        }
        return androidVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync() {
        long now = System.currentTimeMillis();
        if (now - this.myLastChecked < 50L && this.myManifestFile != null) {
            return;
        }
        this.myLastChecked = now;
        MergedManifest mergedManifest = this;
        synchronized (mergedManifest) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    MergedManifest.this.syncWithReadPermission();
                }
            });
        }
    }

    static String getAttributeValue(@NotNull Element element, @Nullable String namespace, @NotNull String localName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/model/MergedManifest", "getAttributeValue"));
        }
        if (localName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localName", "com/android/tools/idea/model/MergedManifest", "getAttributeValue"));
        }
        return Strings.emptyToNull((String)element.getAttributeNS(namespace, localName));
    }

    private void syncWithReadPermission() {
        boolean refresh;
        AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
        assert (facet != null) : "Attempt to obtain manifest info from a non Android module: " + this.myModule.getName();
        if (this.myManifestFile == null) {
            this.myManifestFile = ManifestInfo.ManifestFile.create(facet);
        }
        if (!(refresh = this.myManifestFile.refresh())) {
            return;
        }
        this.myActivityAttributesMap = new HashMap<String, ActivityAttributes>();
        this.myManifestTheme = null;
        this.myTargetSdk = AndroidVersion.DEFAULT;
        this.myMinSdk = AndroidVersion.DEFAULT;
        this.myPackage = "";
        this.myApplicationId = "";
        this.myVersionCode = null;
        this.myApplicationIcon = null;
        this.myApplicationLabel = null;
        this.myApplicationSupportsRtl = false;
        this.myNodeKeys = null;
        this.myActivities = Lists.newArrayList();
        this.myActivityAliases = Lists.newArrayListWithExpectedSize((int)4);
        this.myServices = Lists.newArrayListWithExpectedSize((int)4);
        try {
            Document document = this.myManifestFile.getXmlDocument();
            if (document == null) {
                return;
            }
            this.myDocument = document;
            this.myManifestFiles = this.myManifestFile.getManifestFiles();
            Element root = document.getDocumentElement();
            if (root == null) {
                return;
            }
            this.myApplicationId = MergedManifest.getAttributeValue(root, null, "package");
            Manifest manifest = facet.getManifest();
            this.myPackage = manifest == null ? this.myApplicationId : (String)manifest.getPackage().getValue();
            String versionCode = MergedManifest.getAttributeValue(root, "http://schemas.android.com/apk/res/android", "versionCode");
            try {
                this.myVersionCode = Integer.valueOf(versionCode);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                String nodeName = node.getNodeName();
                if ("application".equals(nodeName)) {
                    Element application = (Element)node;
                    this.myApplicationIcon = MergedManifest.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "icon");
                    this.myApplicationLabel = MergedManifest.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "label");
                    this.myManifestTheme = MergedManifest.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "theme");
                    this.myApplicationSupportsRtl = "true".equals(MergedManifest.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "supportsRtl"));
                    String debuggable = MergedManifest.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "debuggable");
                    this.myApplicationDebuggable = debuggable == null ? null : Boolean.valueOf("true".equals(debuggable));
                    for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                        if (child.getNodeType() != 1) continue;
                        String childNodeName = child.getNodeName();
                        if ("activity".equals(childNodeName)) {
                            Element element = (Element)child;
                            ActivityAttributes attributes = new ActivityAttributes(element, this.myApplicationId);
                            this.myActivityAttributesMap.put(attributes.getName(), attributes);
                            this.myActivities.add(element);
                            continue;
                        }
                        if ("activity-alias".equals(childNodeName)) {
                            this.myActivityAliases.add((Element)child);
                            continue;
                        }
                        if (!"service".equals(childNodeName)) continue;
                        this.myServices.add((Element)child);
                    }
                    continue;
                }
                if (!"uses-sdk".equals(nodeName)) continue;
                Element usesSdk = (Element)node;
                this.myMinSdk = MergedManifest.getApiVersion(usesSdk, "minSdkVersion", AndroidVersion.DEFAULT);
                this.myTargetSdk = MergedManifest.getApiVersion(usesSdk, "targetSdkVersion", this.myMinSdk);
            }
        }
        catch (ProcessCanceledException e) {
            this.myManifestFile = null;
            this.myDocument = null;
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance(MergedManifest.class).warn("Could not read Manifest data", (Throwable)e);
        }
    }

    private static AndroidVersion getApiVersion(Element usesSdk, String attribute, AndroidVersion defaultApiLevel) {
        AndroidVersion version;
        String valueString = MergedManifest.getAttributeValue(usesSdk, "http://schemas.android.com/apk/res/android", attribute);
        if (valueString != null && (version = SdkVersionInfo.getVersion((String)valueString, null)) != null) {
            return version;
        }
        return defaultApiLevel;
    }

    @NotNull
    public List<Element> getActivities() {
        this.sync();
        List<Element> list = this.myActivities;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/MergedManifest", "getActivities"));
        }
        return list;
    }

    @NotNull
    public List<Element> getActivityAliases() {
        this.sync();
        List<Element> list = this.myActivityAliases;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/MergedManifest", "getActivityAliases"));
        }
        return list;
    }

    @NotNull
    public List<Element> getServices() {
        List<Element> list = this.myServices;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/MergedManifest", "getServices"));
        }
        return list;
    }

    @Nullable
    public Element findUsedFeature(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/model/MergedManifest", "findUsedFeature"));
        }
        this.sync();
        for (Node node = this.myDocument.getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element;
            if (node.getNodeType() != 1 || !"uses-feature".equals(node.getNodeName()) || !name.equals((element = (Element)node).getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
            return element;
        }
        return null;
    }

    @NotNull
    public ImmutableList<MergingReport.Record> getLoggingRecords() {
        this.sync();
        ImmutableList<MergingReport.Record> immutableList = this.myManifestFile == null ? ImmutableList.of() : this.myManifestFile.getLoggingRecords();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/MergedManifest", "getLoggingRecords"));
        }
        return immutableList;
    }

    @Nullable
    public Actions getActions() {
        this.sync();
        return this.myManifestFile == null ? null : this.myManifestFile.getActions();
    }

    @Nullable(value="can not find a node key with that name")
    public XmlNode.NodeKey getNodeKey(String name) {
        this.sync();
        if (this.myNodeKeys == null) {
            HashMap<String, XmlNode.NodeKey> nodeKeys = new HashMap<String, XmlNode.NodeKey>();
            Actions actions = this.getActions();
            if (actions != null) {
                Set keys = actions.getNodeKeys();
                for (XmlNode.NodeKey key : keys) {
                    nodeKeys.put(key.toString(), key);
                }
            }
            this.myNodeKeys = nodeKeys;
        }
        return this.myNodeKeys.get(name);
    }

    @Nullable
    public Element findActivity(@Nullable String qualifiedName) {
        this.sync();
        if (qualifiedName == null || this.myActivities == null) {
            return null;
        }
        return MergedManifest.getActivityOrAliasByName(qualifiedName, this.myActivities);
    }

    @Nullable
    public Element findActivityAlias(@Nullable String qualifiedName) {
        this.sync();
        if (qualifiedName == null || this.myActivityAliases == null) {
            return null;
        }
        return MergedManifest.getActivityOrAliasByName(qualifiedName, this.myActivityAliases);
    }

    @Nullable
    private static Element getActivityOrAliasByName(@NotNull String qualifiedName, @NotNull List<Element> activityOrAliasElements) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/android/tools/idea/model/MergedManifest", "getActivityOrAliasByName"));
        }
        if (activityOrAliasElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activityOrAliasElements", "com/android/tools/idea/model/MergedManifest", "getActivityOrAliasByName"));
        }
        for (Element activity : activityOrAliasElements) {
            if (!qualifiedName.equals(ActivityLocatorUtils.getQualifiedName(activity))) continue;
            return activity;
        }
        return null;
    }

    public static class ActivityAttributes {
        @NotNull
        private final Element myElement;
        @Nullable
        private final String myIcon;
        @Nullable
        private final String myLabel;
        @NotNull
        private final String myName;
        @Nullable
        private final String myParentActivity;
        @Nullable
        private final String myTheme;
        @Nullable
        private final String myUiOptions;

        public ActivityAttributes(@NotNull Element activity, @Nullable String packageName) {
            if (activity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activity", "com/android/tools/idea/model/MergedManifest$ActivityAttributes", "<init>"));
            }
            this.myElement = activity;
            String name = MergedManifest.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "name");
            if (name == null || name.length() == 0) {
                throw new RuntimeException("Activity name cannot be empty.");
            }
            int index = name.indexOf(46);
            if (index <= 0 && packageName != null && !packageName.isEmpty()) {
                name = packageName + (index == -1 ? "." : "") + name;
            }
            this.myName = name;
            String value = MergedManifest.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "icon");
            this.myIcon = value != null && value.length() > 0 ? value : null;
            value = MergedManifest.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "label");
            this.myLabel = value != null && value.length() > 0 ? value : null;
            value = MergedManifest.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "parentActivityName");
            if (value == null || value.length() == 0) {
                for (Node child = activity.getFirstChild(); child != null; child = child.getNextSibling()) {
                    String metaDataName;
                    if (child.getNodeType() != 1 || !child.getNodeName().equals("meta-data") || !"android.support.PARENT_ACTIVITY".equals(metaDataName = MergedManifest.getAttributeValue((Element)child, "http://schemas.android.com/apk/res/android", "name")) || (value = MergedManifest.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "value")) == null || (index = value.indexOf(46)) > 0 || packageName == null || packageName.isEmpty()) continue;
                    value = packageName + (index == -1 ? "." : "") + value;
                    break;
                }
            }
            this.myParentActivity = value != null && value.length() > 0 ? value : null;
            value = MergedManifest.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "theme");
            this.myTheme = value != null && value.length() > 0 ? value : null;
            value = MergedManifest.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "uiOptions");
            this.myUiOptions = value != null && value.length() > 0 ? value : null;
        }

        @NotNull
        public Element getElement() {
            Element element = this.myElement;
            if (element == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/MergedManifest$ActivityAttributes", "getElement"));
            }
            return element;
        }

        @Nullable
        public String getIcon() {
            return this.myIcon;
        }

        @Nullable
        public String getLabel() {
            return this.myLabel;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/MergedManifest$ActivityAttributes", "getName"));
            }
            return string;
        }

        @Nullable
        public String getParentActivity() {
            return this.myParentActivity;
        }

        @Nullable
        public String getTheme() {
            return this.myTheme;
        }

        @Nullable
        public String getUiOptions() {
            return this.myUiOptions;
        }
    }
}

