/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.icon;

import com.android.assetstudiolib.GraphicGenerator;
import com.android.assetstudiolib.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.AssetStudioGraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.icon.CategoryIconMap;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.android.tools.idea.ui.properties.core.OptionalProperty;
import com.android.tools.idea.ui.properties.core.OptionalValueProperty;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;

public abstract class AndroidIconGenerator {
    private final OptionalProperty<BaseAsset> mySourceAsset = new OptionalValueProperty<BaseAsset>();
    private final StringProperty myName = new StringValueProperty();

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(AndroidIconGenerator.class);
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/icon/AndroidIconGenerator", "getLog"));
        }
        return logger;
    }

    @NotNull
    private static Map<String, Map<String, BufferedImage>> newAssetMap() {
        HashMap hashMap = Maps.newHashMap();
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/icon/AndroidIconGenerator", "newAssetMap"));
        }
        return hashMap;
    }

    @NotNull
    public final OptionalProperty<BaseAsset> sourceAsset() {
        OptionalProperty<BaseAsset> optionalProperty = this.mySourceAsset;
        if (optionalProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/icon/AndroidIconGenerator", "sourceAsset"));
        }
        return optionalProperty;
    }

    @NotNull
    public final StringProperty name() {
        StringProperty stringProperty = this.myName;
        if (stringProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/icon/AndroidIconGenerator", "name"));
        }
        return stringProperty;
    }

    @NotNull
    public final CategoryIconMap generateIntoMemory() {
        if (!((Optional)this.mySourceAsset.get()).isPresent()) {
            throw new IllegalStateException("Can't generate icons without a source asset set first");
        }
        Map<String, Map<String, BufferedImage>> categoryMap = AndroidIconGenerator.newAssetMap();
        AssetStudioGraphicGeneratorContext context = new AssetStudioGraphicGeneratorContext();
        GraphicGenerator graphicGenerator = this.createGenerator();
        GraphicGenerator.Options options = this.createOptions(this.mySourceAsset.getValue());
        graphicGenerator.generate(null, categoryMap, (GraphicGeneratorContext)context, options, (String)this.myName.get());
        CategoryIconMap categoryIconMap = new CategoryIconMap(categoryMap);
        if (categoryIconMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/icon/AndroidIconGenerator", "generateIntoMemory"));
        }
        return categoryIconMap;
    }

    @NotNull
    public final Map<File, BufferedImage> generateIntoFileMap(@NotNull AndroidProjectPaths paths) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/android/tools/idea/npw/assetstudio/icon/AndroidIconGenerator", "generateIntoFileMap"));
        }
        if (((String)this.myName.get()).isEmpty()) {
            throw new IllegalStateException("Can't save icons to disk if a filename isn't set first");
        }
        File resDirectory = paths.getResDirectory();
        if (resDirectory == null || resDirectory.getParentFile() == null) {
            throw new IllegalArgumentException("Invalid paths used when trying to generate an icon");
        }
        CategoryIconMap categoryIconMap = this.generateIntoMemory();
        Map<File, BufferedImage> map = categoryIconMap.toFileMap(resDirectory.getParentFile());
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/icon/AndroidIconGenerator", "generateIntoFileMap"));
        }
        return map;
    }

    public final void generateImageIconsIntoPath(@NotNull AndroidProjectPaths paths) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/android/tools/idea/npw/assetstudio/icon/AndroidIconGenerator", "generateImageIconsIntoPath"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Map<File, BufferedImage> pathIconMap = this.generateIntoFileMap(paths);
        for (Map.Entry<File, BufferedImage> fileImageEntry : pathIconMap.entrySet()) {
            File file = fileImageEntry.getKey();
            BufferedImage image = fileImageEntry.getValue();
            if (FileUtilRt.extensionEquals((String)file.getName(), (String)"png")) {
                this.writePngToDisk(file, image);
                continue;
            }
            AndroidIconGenerator.getLog().error("Please report this error. Unable to create icon for invalid file: " + file.getAbsolutePath());
        }
    }

    @NotNull
    protected abstract GraphicGenerator createGenerator();

    @NotNull
    protected abstract GraphicGenerator.Options createOptions(@NotNull Class<? extends BaseAsset> var1);

    @NotNull
    private GraphicGenerator.Options createOptions(@NotNull BaseAsset baseAsset) {
        if (baseAsset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseAsset", "com/android/tools/idea/npw/assetstudio/icon/AndroidIconGenerator", "createOptions"));
        }
        GraphicGenerator.Options options = this.createOptions(baseAsset.getClass());
        options.sourceImage = baseAsset.toImage();
        GraphicGenerator.Options options2 = options;
        if (options2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/icon/AndroidIconGenerator", "createOptions"));
        }
        return options2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePngToDisk(@NotNull File file, @NotNull BufferedImage image) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/npw/assetstudio/icon/AndroidIconGenerator", "writePngToDisk"));
        }
        if (image == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/android/tools/idea/npw/assetstudio/icon/AndroidIconGenerator", "writePngToDisk"));
        }
        try {
            VirtualFile directory = VfsUtil.createDirectories((String)file.getParentFile().getAbsolutePath());
            VirtualFile imageFile = directory.findChild(file.getName());
            if (imageFile == null || !imageFile.exists()) {
                imageFile = directory.createChildData((Object)this, file.getName());
            }
            try (OutputStream outputStream = imageFile.getOutputStream((Object)this);){
                ImageIO.write((RenderedImage)image, "PNG", outputStream);
            }
        }
        catch (IOException e) {
            AndroidIconGenerator.getLog().error((Throwable)e);
        }
    }
}

