/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.deprecated;

import com.android.repository.Revision;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.npw.ConfigureFormFactorStep;
import com.android.tools.idea.npw.deprecated.ConfigureAndroidProjectStep;
import com.android.tools.idea.sdk.VersionCheck;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.wizard.legacy.LicenseAgreementStep;
import com.android.tools.idea.sdk.wizard.legacy.SmwOldApiDirectInstall;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardPath;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithHeaderAndDescription;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

public class ConfigureAndroidProjectPath
extends DynamicWizardPath {
    private static final Logger LOG = Logger.getInstance(ConfigureAndroidProjectPath.class);
    @NotNull
    private final Disposable myParentDisposable;

    public ConfigureAndroidProjectPath(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/android/tools/idea/npw/deprecated/ConfigureAndroidProjectPath", "<init>"));
        }
        this.myParentDisposable = parentDisposable;
    }

    @Override
    protected void init() {
        ConfigureAndroidProjectPath.putSdkDependentParams(this.myState);
        this.addStep(new ConfigureAndroidProjectStep(this.myParentDisposable));
        this.addStep(new ConfigureFormFactorStep(this.myParentDisposable));
        this.addStep(new LicenseAgreementStep(this.myParentDisposable));
        this.addStep(new SmwOldApiDirectInstall(this.myParentDisposable));
    }

    @Override
    public boolean validate() {
        if (!AndroidSdkUtils.isAndroidSdkAvailable() || !TemplateManager.templatesAreValid()) {
            this.setErrorHtml("<html>Your Android SDK is missing, out of date, or is missing templates. Please ensure you are using SDK version " + VersionCheck.MIN_TOOLS_REV + " or later.<br>You can configure your SDK via <b>Configure | Project Defaults | Project Structure | SDKs</b></html>");
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public String getPathName() {
        if ("Configure Android Project" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/deprecated/ConfigureAndroidProjectPath", "getPathName"));
        }
        return "Configure Android Project";
    }

    public static void putSdkDependentParams(@NotNull ScopedStateStore state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/npw/deprecated/ConfigureAndroidProjectPath", "putSdkDependentParams"));
        }
        AndroidSdkHandler sdkHandler = AndroidSdkUtils.tryToChooseSdkHandler();
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(ConfigureAndroidProjectPath.class);
        BuildToolInfo buildTool = sdkHandler.getLatestBuildTool((ProgressIndicator)progress, false);
        Revision minimumRequiredBuildToolVersion = Revision.parseRevision((String)"19.1.0");
        if (buildTool != null && buildTool.getRevision().compareTo(minimumRequiredBuildToolVersion) >= 0) {
            state.put(WizardConstants.BUILD_TOOLS_VERSION_KEY, buildTool.getRevision().toString());
        } else {
            state.listPush(WizardConstants.INSTALL_REQUESTS_KEY, DetailsTypes.getBuildToolsPath((Revision)minimumRequiredBuildToolVersion));
            state.put(WizardConstants.BUILD_TOOLS_VERSION_KEY, minimumRequiredBuildToolVersion.toString());
        }
        File location = sdkHandler.getLocation();
        if (location != null) {
            state.put(WizardConstants.SDK_DIR_KEY, FileUtil.toSystemIndependentName((String)location.getPath()));
        }
    }

    @Override
    public boolean canPerformFinishingActions() {
        return this.performFinishingOperation(true);
    }

    @Override
    public boolean performFinishingActions() {
        try {
            if (!this.performFinishingOperation(false)) {
                return false;
            }
            Project project = this.getProject();
            assert (project != null);
            File projectRoot = VfsUtilCore.virtualToIoFile((VirtualFile)project.getBaseDir());
            ConfigureAndroidProjectPath.setGradleWrapperExecutable(projectRoot);
            return true;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    private boolean performFinishingOperation(boolean dryRun) {
        Project project = this.getProject();
        assert (project != null);
        Template projectTemplate = Template.createFromName("gradle-projects", "NewAndroidProject");
        RenderingContext context = RenderingContext.Builder.newContext(projectTemplate, project).withCommandName("New Project").withDryRun(dryRun).withShowErrors(true).withParams(this.myState.flatten()).intoTargetFiles(this.myState.get(WizardConstants.TARGET_FILES_KEY)).build();
        return projectTemplate.render(context);
    }

    protected static DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings buildConfigurationHeader() {
        return DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings.createProductHeader("New Project");
    }

    public static void setGradleWrapperExecutable(File projectRoot) throws IOException {
        if (SystemInfo.isUnix) {
            File gradlewFile = new File(projectRoot, "gradlew");
            if (!gradlewFile.isFile()) {
                LOG.error("Could not find gradle wrapper. Command line builds may not work properly.");
            } else {
                FileUtil.setExecutableAttribute((String)gradlewFile.getPath(), (boolean)true);
            }
        }
    }
}

