/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.capture;

import com.android.tools.idea.profiling.capture.CaptureType;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptureHandle {
    @NotNull
    private File myFile;
    @NotNull
    private CaptureType myType;
    private boolean myWriteToTempFile;
    @Nullable
    private volatile FileOutputStream myFileOutputStream;

    CaptureHandle(@NotNull File file, @NotNull CaptureType type, boolean writeToTempFile) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/profiling/capture/CaptureHandle", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/profiling/capture/CaptureHandle", "<init>"));
        }
        this.myFile = file;
        this.myType = type;
        this.myWriteToTempFile = writeToTempFile;
        this.myFileOutputStream = new FileOutputStream(this.myFile, true);
    }

    @NotNull
    File getFile() {
        File file = this.myFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/CaptureHandle", "getFile"));
        }
        return file;
    }

    @NotNull
    CaptureType getCaptureType() {
        CaptureType captureType = this.myType;
        if (captureType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/CaptureHandle", "getCaptureType"));
        }
        return captureType;
    }

    @Nullable
    FileOutputStream getFileOutputStream() {
        return this.myFileOutputStream;
    }

    boolean getWriteToTempFile() {
        return this.myWriteToTempFile;
    }

    void closeFileOutputStream() {
        FileOutputStream fileOutputStream = this.myFileOutputStream;
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.myFileOutputStream = null;
        }
    }

    boolean isWritable() {
        return this.myFileOutputStream != null;
    }

    public void move(File file) throws IOException {
        Files.move((File)this.myFile, (File)file);
        this.myFile = file;
    }
}

