/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard.legacy;

import com.android.repository.api.Downloader;
import com.android.repository.api.License;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.wizard.AndroidSdkLicenseTemporaryData;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithDescription;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.treeStructure.Tree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LicenseAgreementStep
extends DynamicWizardStepWithDescription {
    private final AndroidSdkHandler mySdkHandler;
    private JTextPane myLicenseTextField;
    private Tree myChangeTree;
    private JRadioButton myDeclineRadioButton;
    private JRadioButton myAcceptRadioButton;
    private DefaultTreeModel myTreeModel;
    private Map<String, Boolean> myAcceptances;
    private Set<String> myVisibleLicenses;
    private String myCurrentLicense;
    private Set<License> myLicenses;
    private final File mySdkRoot;

    public LicenseAgreementStep(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/android/tools/idea/sdk/wizard/legacy/LicenseAgreementStep", "<init>"));
        }
        super(disposable);
        this.myTreeModel = new DefaultTreeModel(null);
        this.myAcceptances = Maps.newHashMap();
        this.myVisibleLicenses = Sets.newHashSet();
        this.myLicenses = Sets.newHashSet();
        Splitter splitter = new Splitter(false, 0.3f);
        splitter.setHonorComponentsMinimumSize(true);
        this.myChangeTree = new Tree();
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myChangeTree));
        this.myLicenseTextField = new JTextPane();
        splitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myLicenseTextField));
        this.myDeclineRadioButton = new JBRadioButton("Decline");
        this.myAcceptRadioButton = new JBRadioButton("Accept");
        ButtonGroup optionsGroup = new ButtonGroup();
        optionsGroup.add(this.myDeclineRadioButton);
        optionsGroup.add(this.myAcceptRadioButton);
        JPanel optionsPanel = new JPanel(new FlowLayout(4));
        optionsPanel.add(this.myDeclineRadioButton);
        optionsPanel.add(this.myAcceptRadioButton);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)splitter, "Center");
        mainPanel.add((Component)optionsPanel, "South");
        this.setBodyComponent(mainPanel);
        this.mySdkHandler = AndroidSdkUtils.tryToChooseSdkHandler();
        this.mySdkRoot = this.mySdkHandler.getLocation();
    }

    @Override
    public void init() {
        super.init();
        this.myChangeTree.setModel((TreeModel)this.myTreeModel);
        this.myChangeTree.setShowsRootHandles(false);
        this.myLicenseTextField.setEditable(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.myDeclineRadioButton);
        group.add(this.myAcceptRadioButton);
        this.myDeclineRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LicenseAgreementStep.this.myAcceptances.put(LicenseAgreementStep.this.myCurrentLicense, Boolean.FALSE);
                LicenseAgreementStep.this.invokeUpdate(null);
                LicenseAgreementStep.this.myChangeTree.repaint();
            }
        });
        this.myAcceptRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LicenseAgreementStep.this.myAcceptances.put(LicenseAgreementStep.this.myCurrentLicense, Boolean.TRUE);
                LicenseAgreementStep.this.invokeUpdate(null);
                LicenseAgreementStep.this.myChangeTree.repaint();
            }
        });
        this.myChangeTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode selected = (DefaultMutableTreeNode)LicenseAgreementStep.this.myChangeTree.getLastSelectedPathComponent();
                if (selected != null && selected.isRoot()) {
                    return;
                }
                if (selected != null && !selected.isLeaf()) {
                    License license = (License)selected.getUserObject();
                    LicenseAgreementStep.this.myLicenseTextField.setText(license.getValue());
                    LicenseAgreementStep.this.myCurrentLicense = license.getId();
                } else if (selected != null && !selected.isRoot()) {
                    Change change = (Change)selected.getUserObject();
                    LicenseAgreementStep.this.myLicenseTextField.setText(change.license.getValue());
                    LicenseAgreementStep.this.myCurrentLicense = change.license.getId();
                }
                if (((Boolean)LicenseAgreementStep.this.myAcceptances.get(LicenseAgreementStep.this.myCurrentLicense)).booleanValue()) {
                    LicenseAgreementStep.this.myAcceptRadioButton.setSelected(true);
                } else {
                    LicenseAgreementStep.this.myDeclineRadioButton.setSelected(true);
                }
                LicenseAgreementStep.this.myLicenseTextField.setCaretPosition(0);
            }
        });
        this.myChangeTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/sdk/wizard/legacy/LicenseAgreementStep$4", "customizeCellRenderer"));
                }
                if (row == 0) {
                    this.append("Licenses", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                if (!leaf) {
                    License license = (License)node.getUserObject();
                    this.appendLicenseText(license, license.getId());
                } else {
                    Change change = (Change)node.getUserObject();
                    if (change == null) {
                        return;
                    }
                    this.appendLicenseText(change.license, change.toString());
                    this.setIcon(change.getIcon());
                }
            }

            private void appendLicenseText(@Nullable License license, String text) {
                boolean notAccepted;
                boolean bl = notAccepted = license != null && (Boolean)LicenseAgreementStep.this.myAcceptances.get(license.getId()) == false;
                if (notAccepted) {
                    this.append("*", SimpleTextAttributes.ERROR_ATTRIBUTES);
                    this.append(text, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                } else {
                    this.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
        });
        this.setChanges(this.createChangesList());
    }

    @Override
    public boolean isStepVisible() {
        return this.myState.listSize(WizardConstants.INSTALL_REQUESTS_KEY) > 0 && !this.myLicenses.isEmpty();
    }

    @Override
    public boolean validate() {
        for (String licenseRef : this.myVisibleLicenses) {
            if (this.myAcceptances.get(licenseRef).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("License Agreement" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/legacy/LicenseAgreementStep", "getStepName"));
        }
        return "License Agreement";
    }

    @Override
    @NotNull
    protected String getStepTitle() {
        if ("License Agreement" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/legacy/LicenseAgreementStep", "getStepTitle"));
        }
        return "License Agreement";
    }

    @Override
    @Nullable
    protected String getStepDescription() {
        return "Read and agree to the licenses for the components which will be installed";
    }

    private void expandTree() {
        for (int i = 0; i < this.myChangeTree.getRowCount(); ++i) {
            this.myChangeTree.expandRow(i);
        }
    }

    private List<Change> createChangesList() {
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        RepoManager sdkManager = this.mySdkHandler.getSdkManager((ProgressIndicator)progress);
        sdkManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (ProgressIndicator)progress, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance());
        Map remotePackages = sdkManager.getPackages().getRemotePackages();
        ArrayList toReturn = Lists.newArrayList();
        List<String> requestedPackages = this.myState.get(WizardConstants.INSTALL_REQUESTS_KEY);
        if (requestedPackages != null) {
            for (String path : requestedPackages) {
                RemotePackage p = (RemotePackage)remotePackages.get(path);
                License license = p.getLicense();
                if (license == null) {
                    license = AndroidSdkLicenseTemporaryData.getLicense(p.getTypeDetails() instanceof DetailsTypes.ApiDetailsType && ((DetailsTypes.ApiDetailsType)p.getTypeDetails()).getAndroidVersion().isPreview());
                }
                this.myLicenses.add(license);
                if (license.checkAccepted(this.mySdkRoot, this.mySdkHandler.getFileOp())) continue;
                toReturn.add(new Change(ChangeType.INSTALL, (RepoPackage)p, license));
            }
        }
        return toReturn;
    }

    private void setChanges(List<Change> changes) {
        HashMap licenseNodeMap = Maps.newHashMap();
        this.myVisibleLicenses.clear();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultMutableTreeNode firstChild = null;
        for (Change change : changes) {
            String licenseRef = change.license.getId();
            this.myVisibleLicenses.add(licenseRef);
            if (!licenseNodeMap.containsKey(licenseRef)) {
                DefaultMutableTreeNode n = new DefaultMutableTreeNode(change.license);
                if (firstChild == null) {
                    firstChild = n;
                }
                licenseNodeMap.put(licenseRef, n);
                this.myAcceptances.put(licenseRef, Boolean.FALSE);
                root.add(n);
            }
            ((DefaultMutableTreeNode)licenseNodeMap.get(licenseRef)).add(new DefaultMutableTreeNode(change));
        }
        this.myTreeModel = new DefaultTreeModel(root);
        this.myChangeTree.setModel((TreeModel)this.myTreeModel);
        this.expandTree();
        if (firstChild != null) {
            this.myChangeTree.setSelectionPath(new TreePath(firstChild.getPath()));
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myChangeTree;
    }

    public void performFinishingActions() {
        for (License license : this.myLicenses) {
            license.setAccepted(this.mySdkRoot, this.mySdkHandler.getFileOp());
        }
    }

    protected static class Change {
        public ChangeType myType;
        public RepoPackage myPackage;
        public License license;

        public Change(@NotNull ChangeType type, @NotNull RepoPackage packageDescription, @NotNull License license) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/sdk/wizard/legacy/LicenseAgreementStep$Change", "<init>"));
            }
            if (packageDescription == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageDescription", "com/android/tools/idea/sdk/wizard/legacy/LicenseAgreementStep$Change", "<init>"));
            }
            if (license == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "license", "com/android/tools/idea/sdk/wizard/legacy/LicenseAgreementStep$Change", "<init>"));
            }
            this.myType = type;
            this.myPackage = packageDescription;
            this.license = license;
        }

        public String toString() {
            return this.myPackage.getDisplayName();
        }

        public Icon getIcon() {
            switch (this.myType) {
                case INSTALL: {
                    return AllIcons.Actions.Download;
                }
                case UPDATE: {
                    return AllIcons.Actions.Refresh;
                }
                case REMOVE: {
                    return AllIcons.Actions.Cancel;
                }
            }
            return null;
        }
    }

    protected static enum ChangeType {
        INSTALL,
        UPDATE,
        REMOVE;

    }
}

