/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.google.common.base.CaseFormat;
import org.jetbrains.annotations.NotNull;

public enum ServiceCategory {
    ADS,
    ANALYTICS,
    AUTHENTICATION,
    CLOUD,
    FITNESS,
    GAMES,
    GEO_LOCATION("Geo/Location"),
    LOCALIZATION,
    MARKETING,
    MEDIA,
    NOTIFICATIONS,
    PAYMENTS,
    SOCIAL;

    @NotNull
    private final String myDisplayName;

    private ServiceCategory() {
        this.myDisplayName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
    }

    private ServiceCategory(String displayName) {
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/android/tools/idea/structure/services/ServiceCategory", "<init>"));
        }
        this.myDisplayName = displayName;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/ServiceCategory", "getDisplayName"));
        }
        return string;
    }
}

