/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.api;

import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.model.NlComponent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DragHandler {
    @NotNull
    protected final ViewEditor editor;
    @NotNull
    protected final ViewGroupHandler handler;
    @NotNull
    protected final List<NlComponent> components;
    @NotNull
    protected final NlComponent layout;
    @NotNull
    protected DragType type;
    protected int startX;
    protected int startY;
    protected int lastX;
    protected int lastY;
    protected int lastModifiers;

    protected DragHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull NlComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/api/DragHandler", "<init>"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/android/tools/idea/uibuilder/api/DragHandler", "<init>"));
        }
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/android/tools/idea/uibuilder/api/DragHandler", "<init>"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/api/DragHandler", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/uibuilder/api/DragHandler", "<init>"));
        }
        this.type = DragType.COPY;
        this.editor = editor;
        this.handler = handler;
        this.layout = layout;
        this.components = components;
        this.type = type;
    }

    public void setDragType(@NotNull DragType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/uibuilder/api/DragHandler", "setDragType"));
        }
        this.type = type;
    }

    public void cancel() {
    }

    public abstract void commit(int var1, int var2, int var3);

    public void start(int x, int y, int modifiers) {
        this.startX = x;
        this.startY = y;
        this.lastModifiers = modifiers;
    }

    @Nullable
    public String update(int x, int y, int modifiers) {
        this.lastX = x;
        this.lastY = y;
        this.lastModifiers = modifiers;
        return null;
    }

    public abstract void paint(@NotNull NlGraphics var1);

    public int getInsertIndex() {
        return -1;
    }
}

