/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative;

import com.android.tools.idea.rendering.AttributeSnapshot;
import com.android.tools.idea.uibuilder.handlers.relative.ConstraintType;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.lint.detector.api.LintUtils;
import com.intellij.util.containers.WeakHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyGraph {
    private static final String DEPENDENCY_FORMAT = "%1$s %2$s %3$s";
    private static final WeakHashMap<NlComponent, DependencyGraph> ourCache = new WeakHashMap();
    private final Map<NlComponent, ViewData> myNodeToView = new HashMap<NlComponent, ViewData>();
    private final long myModelVersion;

    @NotNull
    public static DependencyGraph get(@NotNull NlComponent layout) {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/android/tools/idea/uibuilder/handlers/relative/DependencyGraph", "get"));
        }
        DependencyGraph dependencyGraph = (DependencyGraph)ourCache.get((Object)layout);
        if (dependencyGraph != null && dependencyGraph.myModelVersion == layout.getModel().getModificationCount()) {
            DependencyGraph dependencyGraph2 = dependencyGraph;
            if (dependencyGraph2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/relative/DependencyGraph", "get"));
            }
            return dependencyGraph2;
        }
        dependencyGraph = new DependencyGraph(layout);
        ourCache.put((Object)layout, (Object)dependencyGraph);
        DependencyGraph dependencyGraph3 = dependencyGraph;
        if (dependencyGraph3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/relative/DependencyGraph", "get"));
        }
        return dependencyGraph3;
    }

    private DependencyGraph(NlComponent layout) {
        this.myModelVersion = layout.getModel().getModificationCount();
        String parentId = layout.getId();
        parentId = parentId != null ? LintUtils.stripIdPrefix((String)parentId) : "RelativeLayout";
        ViewData parentView = new ViewData(layout, parentId);
        this.myNodeToView.put(layout, parentView);
        HashMap<String, ViewData> idToView = new HashMap<String, ViewData>();
        idToView.put(parentId, parentView);
        for (NlComponent child : layout.getChildren()) {
            String id = child.getId();
            if (id != null) {
                id = LintUtils.stripIdPrefix((String)id);
            }
            ViewData view = new ViewData(child, id);
            this.myNodeToView.put(child, view);
            if (id == null) continue;
            idToView.put(id, view);
        }
        for (ViewData view : this.myNodeToView.values()) {
            for (AttributeSnapshot attribute : view.node.getAttributes()) {
                String name;
                ConstraintType type;
                if (!"http://schemas.android.com/apk/res/android".equals(attribute.namespace) || (type = ConstraintType.fromAttribute(name = attribute.name)) == null) continue;
                String value = attribute.value;
                if (type.targetParent) {
                    if (!"true".equals(value)) continue;
                    Constraint constraint = new Constraint(type, view, parentView);
                    view.dependsOn.add(constraint);
                    parentView.dependedOnBy.add(constraint);
                    continue;
                }
                String targetId = LintUtils.stripIdPrefix((String)value);
                ViewData target = (ViewData)idToView.get(targetId);
                if (target == view || target == null) continue;
                Constraint constraint = new Constraint(type, view, target);
                view.dependsOn.add(constraint);
                target.dependedOnBy.add(constraint);
            }
        }
    }

    public ViewData getView(NlComponent node) {
        return this.myNodeToView.get(node);
    }

    public Set<NlComponent> dependsOn(Collection<? extends NlComponent> nodes, boolean vertical) {
        ArrayList<ViewData> reachable = new ArrayList<ViewData>();
        HashSet<ViewData> visiting = new HashSet<ViewData>();
        for (NlComponent nlComponent : nodes) {
            ViewData view = this.myNodeToView.get(nlComponent);
            if (view == null) continue;
            this.findBackwards(view, visiting, reachable, vertical, view);
        }
        HashSet<NlComponent> dependents = new HashSet<NlComponent>(reachable.size());
        for (ViewData v : reachable) {
            dependents.add(v.node);
        }
        return dependents;
    }

    private void findBackwards(ViewData view, Set<ViewData> visiting, List<ViewData> reachable, boolean vertical, ViewData start) {
        visiting.add(view);
        reachable.add(view);
        for (Constraint constraint : view.dependedOnBy) {
            if (vertical && !constraint.type.verticalEdge || !vertical && !constraint.type.horizontalEdge) continue;
            assert (constraint.to == view);
            ViewData from = constraint.from;
            if (visiting.contains(from)) {
                List<Constraint> path = this.getPathTo(start.node, view.node, vertical);
                if (path == null) continue;
            }
            this.findBackwards(from, visiting, reachable, vertical, start);
        }
        visiting.remove(view);
    }

    @Nullable
    public List<Constraint> getPathTo(NlComponent from, NlComponent to, boolean vertical) {
        HashSet<ViewData> visiting = new HashSet<ViewData>();
        ArrayList<Constraint> path = new ArrayList<Constraint>();
        ViewData view = this.myNodeToView.get(from);
        if (view != null) {
            return DependencyGraph.findForwards(view, visiting, path, vertical, to);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static List<Constraint> findForwards(ViewData view, Set<ViewData> visiting, List<Constraint> path, boolean vertical, NlComponent target) {
        visiting.add(view);
        for (Constraint constraint : view.dependsOn) {
            if (vertical && !constraint.type.verticalEdge || !vertical && !constraint.type.horizontalEdge) continue;
            try {
                List<Constraint> chain;
                path.add(constraint);
                if (constraint.to.node == target) {
                    ArrayList<Constraint> arrayList = new ArrayList<Constraint>(path);
                    return arrayList;
                }
                assert (constraint.from == view);
                ViewData to = constraint.to;
                if (visiting.contains(to) || (chain = DependencyGraph.findForwards(to, visiting, path, vertical, target)) == null) continue;
                List<Constraint> list = chain;
                return list;
            }
            finally {
                path.remove(constraint);
            }
        }
        visiting.remove(view);
        return null;
    }

    static class Constraint {
        @NotNull
        public final ConstraintType type;
        public final ViewData from;
        public final ViewData to;

        Constraint(@NotNull ConstraintType type, @NotNull ViewData from, @NotNull ViewData to) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/uibuilder/handlers/relative/DependencyGraph$Constraint", "<init>"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/android/tools/idea/uibuilder/handlers/relative/DependencyGraph$Constraint", "<init>"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/uibuilder/handlers/relative/DependencyGraph$Constraint", "<init>"));
            }
            this.type = type;
            this.from = from;
            this.to = to;
        }

        static String describePath(@NotNull List<Constraint> path, @Nullable String newName, @Nullable String newId) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/uibuilder/handlers/relative/DependencyGraph$Constraint", "describePath"));
            }
            String s = "";
            for (int i = path.size() - 1; i >= 0; --i) {
                Constraint constraint = path.get(i);
                String suffix = i == path.size() - 1 ? constraint.to.id : s;
                s = String.format(DependencyGraph.DEPENDENCY_FORMAT, constraint.from.id, Constraint.stripLayoutAttributePrefix(constraint.type.name), suffix);
            }
            if (newName != null) {
                s = String.format(DependencyGraph.DEPENDENCY_FORMAT, s, Constraint.stripLayoutAttributePrefix(newName), newId != null ? LintUtils.stripIdPrefix((String)newId) : "?");
            }
            return s;
        }

        private static String stripLayoutAttributePrefix(String name) {
            if (name.startsWith("layout_")) {
                return name.substring("layout_".length());
            }
            return name;
        }
    }

    static class ViewData {
        @NotNull
        public final NlComponent node;
        @Nullable
        public final String id;
        @NotNull
        public final List<Constraint> dependsOn;
        @NotNull
        public final List<Constraint> dependedOnBy;

        ViewData(@NotNull NlComponent node, @Nullable String id) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/uibuilder/handlers/relative/DependencyGraph$ViewData", "<init>"));
            }
            this.dependsOn = new ArrayList<Constraint>(4);
            this.dependedOnBy = new ArrayList<Constraint>(8);
            this.node = node;
            this.id = id;
        }
    }
}

