/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.installer.BasicInstallerFactory;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.WizardException;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ComponentInstaller {
    private final AndroidSdkHandler mySdkHandler;

    public ComponentInstaller(@NotNull AndroidSdkHandler sdkHandler) {
        if (sdkHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHandler", "com/android/tools/idea/welcome/install/ComponentInstaller", "<init>"));
        }
        this.mySdkHandler = sdkHandler;
    }

    public List<RemotePackage> getPackagesToInstall(@NotNull Iterable<? extends InstallableComponent> components) throws SdkQuickfixUtils.PackageResolutionException {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/welcome/install/ComponentInstaller", "getPackagesToInstall"));
        }
        HashSet requests = Sets.newHashSet();
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        RepoManager sdkManager = this.mySdkHandler.getSdkManager((ProgressIndicator)progress);
        for (InstallableComponent installableComponent : components) {
            requests.addAll(installableComponent.getPackagesToInstall());
        }
        ArrayList resolved = Lists.newArrayList();
        resolved.addAll(SdkQuickfixUtils.resolve(requests, sdkManager.getPackages()));
        ArrayList arrayList = Lists.newArrayList();
        for (UpdatablePackage p : resolved) {
            arrayList.add(p.getRemote());
        }
        return arrayList;
    }

    public void installPackages(@NotNull List<RemotePackage> packages, ProgressIndicator progress) throws WizardException {
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/android/tools/idea/welcome/install/ComponentInstaller", "installPackages"));
        }
        RepoManager sdkManager = this.mySdkHandler.getSdkManager(progress);
        Iterator<RemotePackage> iterator = packages.iterator();
        while (iterator.hasNext()) {
            BasicInstallerFactory factory = new BasicInstallerFactory();
            RemotePackage request = iterator.next();
            Installer installer = factory.createInstaller(request, sdkManager, (Downloader)new StudioDownloader(), this.mySdkHandler.getFileOp());
            if (!installer.prepare(progress)) continue;
            installer.complete(progress);
        }
        sdkManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, progress, null, null);
    }
}

