/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.propertyInspector;

import com.intellij.designer.inspector.AbstractProperty;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.lang.reflect.Type;
import org.jetbrains.annotations.Nullable;

public class DomProperty
extends AbstractProperty<String, String>
implements Comparable<DomProperty> {
    private final GenericDomValue myDomValue;
    private Object myValueObject;
    private final Class myClass;

    public Class getObjectClass() {
        return this.myClass;
    }

    public DomProperty(GenericDomValue value) {
        super((Object)value.getXmlElementName(), (Object)value.getStringValue());
        Type type = value.getDomElementType();
        this.myClass = DomUtil.getGenericValueParameter((Type)type);
        this.myValueObject = this.myClass == Boolean.class || this.myClass == Boolean.TYPE ? value.getValue() : value.getStringValue();
        this.myDomValue = value;
    }

    public void setValue(String value) {
        this.myDomValue.setStringValue(value);
        this.refresh();
    }

    public GenericDomValue getDomValue() {
        return this.myDomValue;
    }

    void refresh() {
        String stringValue = this.myDomValue.getStringValue();
        super.setValue((Object)stringValue);
        this.myValueObject = this.myClass == Boolean.class || this.myClass == Boolean.TYPE ? this.myDomValue.getValue() : stringValue;
    }

    @Override
    public int compareTo(DomProperty o) {
        return ((String)this.getName()).compareTo((String)o.getName());
    }

    public boolean isValid() {
        return this.myDomValue.isValid();
    }

    @Nullable
    public Object getValueObject() {
        return this.myValueObject;
    }
}

