/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.propertyInspector;

import com.intellij.designer.inspector.PropertyInspector;
import com.intellij.designer.inspector.PropertyRenderer;
import com.intellij.designer.inspector.RenderingContext;
import com.intellij.openapi.project.Project;
import com.intellij.struts.propertyInspector.DomProperty;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import com.intellij.util.xml.ui.BaseControl;
import java.awt.Color;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.jetbrains.annotations.NotNull;

public class DomPropertyRenderer
implements PropertyRenderer<DomProperty> {
    private final BooleanTableCellRenderer myBooleanRenderer = new BooleanTableCellRenderer();
    private final DefaultTableCellRenderer myTextRenderer = new DefaultTableCellRenderer();

    public DomPropertyRenderer() {
        this.myBooleanRenderer.setHorizontalAlignment(2);
        this.myBooleanRenderer.setBorder((Border)new EmptyBorder(0, 1, 0, 0));
        this.myTextRenderer.setBorder((Border)JBUI.Borders.empty());
    }

    public JComponent getRendererComponent(@NotNull DomProperty property, @NotNull RenderingContext context) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/struts/propertyInspector/DomPropertyRenderer", "getRendererComponent"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/struts/propertyInspector/DomPropertyRenderer", "getRendererComponent"));
        }
        Class clazz = property.getObjectClass();
        Object val = property.getValueObject();
        Object renderer = clazz == Boolean.class || clazz == Boolean.TYPE ? this.myBooleanRenderer : this.myTextRenderer;
        boolean isSelected = context.isSelected();
        boolean hasErrors = false;
        GenericDomValue value = property.getDomValue();
        if (value.isValid()) {
            DomElementAnnotationsManager annotationsManager = DomElementAnnotationsManager.getInstance((Project)value.getManager().getProject());
            DomElementsProblemsHolder holder = annotationsManager.getCachedProblemHolder((DomElement)value);
            List errorProblems = holder.getProblems((DomElement)value);
            hasErrors = errorProblems.size() > 0;
        }
        PropertyInspector table = context.getInspector();
        JComponent component = (JComponent)renderer.getTableCellRendererComponent((JTable)table, val, isSelected, context.hasFocus(), 0, 0);
        if (hasErrors) {
            component.setForeground((Color)JBColor.RED);
        } else {
            component.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
        }
        if (hasErrors && (val == null || val.toString().trim().length() == 0)) {
            component.setBackground(BaseControl.ERROR_BACKGROUND);
        } else {
            component.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        }
        return component;
    }

    public boolean accepts(DomProperty property) {
        return true;
    }
}

