/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.psi;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts.StrutsManager;
import com.intellij.struts.StrutsModel;
import com.intellij.struts.StrutsProjectComponent;
import com.intellij.struts.TilesModel;
import com.intellij.struts.ValidationModel;
import com.intellij.struts.dom.StrutsConfig;
import com.intellij.struts.dom.StrutsRootElement;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.ExtendClass;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrutsManagerImpl
extends StrutsManager {
    @Nullable
    public StrutsModel getStrutsModel(@Nullable PsiElement psiElement) {
        StrutsModel model;
        Module module;
        String modulePrefix;
        if (psiElement == null) {
            return null;
        }
        PsiElement p = psiElement.getParent();
        if (p == null) {
            return null;
        }
        PsiElement parent = p.getParent();
        if (parent instanceof XmlTag && (modulePrefix = ((XmlTag)parent).getAttributeValue("module")) != null && (module = ModuleUtil.findModuleForPsiElement((PsiElement)psiElement)) != null && (model = this.getModelByPrefix(module, modulePrefix)) != null) {
            return model;
        }
        PsiFile file = psiElement.getContainingFile();
        if (file == null) {
            return null;
        }
        return this.getModelByFile(file);
    }

    @NotNull
    public StrutsConfig getContext(@NotNull StrutsRootElement element) {
        StrutsConfig strutsConfig;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts/psi/StrutsManagerImpl", "getContext"));
        }
        XmlElement xmlElement = element.getXmlElement();
        StrutsModel model = this.getStrutsModel((PsiElement)xmlElement);
        assert (xmlElement != null);
        StrutsConfig strutsConfig2 = strutsConfig = model == null ? this.getStrutsConfig(xmlElement.getContainingFile()) : (StrutsConfig)model.getMergedModel();
        assert (strutsConfig != null);
        StrutsConfig strutsConfig3 = strutsConfig;
        if (strutsConfig3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/psi/StrutsManagerImpl", "getContext"));
        }
        return strutsConfig3;
    }

    @Nullable
    private StrutsModel getModelByFile(PsiFile file) {
        FileType fileType = (file = file.getOriginalFile()).getFileType();
        if (fileType == StdFileTypes.XML) {
            return (StrutsModel)StrutsProjectComponent.getInstance(file.getProject()).getStrutsFactory().getModel((PsiElement)file);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module != null) {
            VirtualFile virtualFile = file.getVirtualFile();
            assert (virtualFile != null);
            WebDirectoryElement dir = WebDirectoryUtil.findParentWebDirectory((Project)module.getProject(), (VirtualFile)virtualFile);
            if (dir != null) {
                List<StrutsModel> strutsModels = this.getAllStrutsModels(module);
                String path = dir.getPath();
                while (true) {
                    for (StrutsModel model : strutsModels) {
                        WebDirectoryElement moduleRoot = model.getModuleRoot();
                        if (moduleRoot == null || !path.equals(moduleRoot.getPath())) continue;
                        return model;
                    }
                    int lastSlash = path.lastIndexOf(47);
                    if (lastSlash == -1) break;
                    path = path.substring(0, lastSlash);
                }
            }
            return this.getCombinedStrutsModel(module);
        }
        return null;
    }

    @NotNull
    public List<StrutsModel> getAllStrutsModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/struts/psi/StrutsManagerImpl", "getAllStrutsModels"));
        }
        List list = StrutsProjectComponent.getInstance(module.getProject()).getStrutsFactory().getAllModels((UserDataHolder)module);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/psi/StrutsManagerImpl", "getAllStrutsModels"));
        }
        return list;
    }

    @Nullable
    public StrutsConfig getStrutsConfig(@NotNull PsiFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/struts/psi/StrutsManagerImpl", "getStrutsConfig"));
        }
        return configFile instanceof XmlFile ? (StrutsConfig)StrutsProjectComponent.getInstance(configFile.getProject()).getStrutsFactory().getDom((XmlFile)configFile) : null;
    }

    @Nullable
    public StrutsModel getCombinedStrutsModel(@Nullable Module module) {
        return module == null ? null : (StrutsModel)StrutsProjectComponent.getInstance(module.getProject()).getStrutsFactory().getCombinedModel((UserDataHolder)module);
    }

    @Nullable
    public StrutsModel getModelByPrefix(@NotNull Module module, @NotNull @NonNls String modulePrefix) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/struts/psi/StrutsManagerImpl", "getModelByPrefix"));
        }
        if (modulePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePrefix", "com/intellij/struts/psi/StrutsManagerImpl", "getModelByPrefix"));
        }
        List<StrutsModel> models = this.getAllStrutsModels(module);
        for (StrutsModel model : models) {
            if (!model.getModulePrefix().equals(modulePrefix)) continue;
            return model;
        }
        return null;
    }

    @Nullable
    public ValidationModel getValidation(@Nullable PsiElement psiElement) {
        return psiElement == null ? null : (ValidationModel)StrutsProjectComponent.getInstance(psiElement.getProject()).getValidatorFactory().getModel(psiElement);
    }

    @NotNull
    public List<ValidationModel> getAllValidationModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/struts/psi/StrutsManagerImpl", "getAllValidationModels"));
        }
        List list = StrutsProjectComponent.getInstance(module.getProject()).getValidatorFactory().getAllModels((UserDataHolder)module);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/psi/StrutsManagerImpl", "getAllValidationModels"));
        }
        return list;
    }

    @Nullable
    public String getDefaultClassname(String attrName, XmlTag tag) {
        ExtendClass annotation;
        DomAttributeChildDescription childDescription;
        DomElement domElement = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
        if (domElement != null && (childDescription = domElement.getGenericInfo().getAttributeChildDescription(attrName)) != null && (annotation = (ExtendClass)childDescription.getAnnotation(ExtendClass.class)) != null) {
            return annotation.value();
        }
        return null;
    }

    @Nullable
    public TilesModel getTiles(@Nullable PsiElement psiElement) {
        return psiElement == null ? null : (TilesModel)StrutsProjectComponent.getInstance(psiElement.getProject()).getTilesFactory().getModel(psiElement);
    }

    @NotNull
    public List<TilesModel> getAllTilesModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/struts/psi/StrutsManagerImpl", "getAllTilesModels"));
        }
        List list = StrutsProjectComponent.getInstance(module.getProject()).getTilesFactory().getAllModels((UserDataHolder)module);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/psi/StrutsManagerImpl", "getAllTilesModels"));
        }
        return list;
    }

    public boolean isStrutsConfig(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/struts/psi/StrutsManagerImpl", "isStrutsConfig"));
        }
        return DomManager.getDomManager((Project)file.getProject()).getFileElement(file, StrutsConfig.class) != null;
    }

    @NotNull
    public Set<XmlFile> getStrutsConfigFiles(@Nullable PsiElement psiElement) {
        StrutsModel model = this.getStrutsModel(psiElement);
        if (model == null) {
            Set<XmlFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/psi/StrutsManagerImpl", "getStrutsConfigFiles"));
            }
            return set;
        }
        Set set = model.getConfigFiles();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/psi/StrutsManagerImpl", "getStrutsConfigFiles"));
        }
        return set;
    }
}

