/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.ProjectScope;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiClassUtil {
    private PsiClassUtil() {
    }

    @Nullable
    public static PsiClass findClassInProjectScope(@NonNls @NotNull String className, @NotNull Project project) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/struts/util/PsiClassUtil", "findClassInProjectScope"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/struts/util/PsiClassUtil", "findClassInProjectScope"));
        }
        return JavaPsiFacade.getInstance((Project)project).findClass(className, ProjectScope.getAllScope((Project)project));
    }

    public static boolean isSuper(@NonNls @NotNull PsiClass clazz, @NonNls @NotNull String superClass) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/struts/util/PsiClassUtil", "isSuper"));
        }
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "com/intellij/struts/util/PsiClassUtil", "isSuper"));
        }
        PsiClass superClazz = PsiClassUtil.findClassInProjectScope(superClass, clazz.getProject());
        return superClazz != null && (clazz.equals(superClazz) || clazz.isInheritor(superClazz, true));
    }
}

