/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FtlLanguage
extends Language
implements TemplateLanguage {
    public static final FtlLanguage INSTANCE = new FtlLanguage();
    public static final Language ANGLE_INSTANCE = new FtlDialect("FTL>", "<FreeMarker>"){};
    public static final Language SQUARE_INSTANCE = new FtlDialect("FTL]", "[FreeMarker]"){};

    private FtlLanguage() {
        super("FTL");
    }

    @NotNull
    @NonNls
    public String getDisplayName() {
        if ("FreeMarker" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlLanguage", "getDisplayName"));
        }
        return "FreeMarker";
    }

    public boolean isCaseSensitive() {
        return true;
    }

    static {
        new InjectableFtlDialect();
    }

    private static class InjectableFtlDialect
    extends FtlDialect
    implements InjectableLanguage {
        public InjectableFtlDialect() {
            super("InjectedFreeMarker", "Injectable FreeMarker");
        }
    }

    private static class FtlDialect
    extends Language
    implements TemplateLanguage {
        private final String myName;

        public FtlDialect(@NonNls String id, @NonNls @NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/freemarker/psi/FtlLanguage$FtlDialect", "<init>"));
            }
            super((Language)INSTANCE, id, new String[0]);
            this.myName = name;
        }

        @NotNull
        @NonNls
        public String getDisplayName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlLanguage$FtlDialect", "getDisplayName"));
            }
            return string;
        }
    }
}

