/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.diagram.beans.wrappers;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.webflow.diagram.beans.wrappers.WebflowElementWrapper;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xml.DomAnchor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomService;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class WebflowDomElementWrapper
extends WebflowElementWrapper<DomElement> {
    public static final Key<Boolean> IS_START_STATE = Key.create((String)"startAction");
    @NotNull
    private final DomAnchor myAnchor;

    public WebflowDomElementWrapper(@NotNull DomElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/webflow/diagram/beans/wrappers/WebflowDomElementWrapper", "<init>"));
        }
        this.myAnchor = DomService.getInstance().createAnchor(element);
    }

    @Override
    @NotNull
    public DomElement getElement() {
        DomElement domElement = this.myAnchor.retrieveDomElement();
        DomElement domElement2 = (DomElement)ObjectUtils.assertNotNull((Object)domElement);
        if (domElement2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/diagram/beans/wrappers/WebflowDomElementWrapper", "getElement"));
        }
        return domElement2;
    }

    @Override
    @NotNull
    public String getName() {
        if (!this.isValid()) {
            if ("<invalid>" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/diagram/beans/wrappers/WebflowDomElementWrapper", "getName"));
            }
            return "<invalid>";
        }
        String string = StringUtil.notNullize((String)this.getElement().getPresentation().getElementName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/diagram/beans/wrappers/WebflowDomElementWrapper", "getName"));
        }
        return string;
    }

    @Override
    public Icon getIcon() {
        if (!this.isValid()) {
            return AllIcons.Nodes.ErrorIntroduction;
        }
        return this.getElement().getPresentation().getIcon();
    }

    @Override
    public String getFqn() {
        return this.isValid() ? this.getElement().toString() : "<invalid>";
    }

    @Override
    public boolean isValid() {
        DomElement domElement = this.myAnchor.retrieveDomElement();
        return domElement != null && domElement.isValid();
    }

    @Override
    @NotNull
    public List<WebflowModel> getFlowModels() {
        throw new UnsupportedOperationException(this.getElement().toString());
    }
}

