/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public enum WebflowVersion {
    Webflow_1_0("1.0"),
    Webflow_2_0("2.0"),
    Webflow_2_0_3("2.0.3"),
    Webflow_2_1("2.1"),
    Webflow_2_3("2.3"),
    Webflow_2_3_1("2.3.1"),
    Webflow_2_4("2.4");

    private final String myName;

    private WebflowVersion(String name) {
        this.myName = name;
    }

    @NotNull
    public String getVersion() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/WebflowVersion", "getVersion"));
        }
        return string;
    }

    public boolean isAtLeast(WebflowVersion reference) {
        return StringUtil.compareVersionNumbers((String)this.getVersion(), (String)reference.getVersion()) >= 0;
    }
}

