/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.psi.VtlExpression;
import com.intellij.velocity.psi.VtlImplicitVariable;
import com.intellij.velocity.psi.VtlPresentableNamedElement;
import com.intellij.velocity.psi.VtlVariable;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlLoopVariable
extends VtlPresentableNamedElement
implements VtlVariable {
    private static final Object[][] VELOCITY_ITERABLES = new Object[][]{{"java.util.Iterator", 0}, {"java.util.Collection", 0}, {"java.util.Map", 1}, {"java.lang.Iterable", 0}};

    public VtlLoopVariable(ASTNode node) {
        super(node);
    }

    public String getTypeName() {
        return VelocityBundle.message("type.name.loop.variable", new Object[0]);
    }

    public Icon getIcon() {
        return PlatformIcons.VARIABLE_ICON;
    }

    @Override
    @Nullable
    public PsiType getPsiType() {
        VtlImplicitVariable variable = VtlImplicitVariable.findImplicitCounterpart(this);
        return variable != null ? variable.getPsiType() : VtlLoopVariable.extractTypeFromIterable(this.getIterableExpression());
    }

    @Override
    @Nullable
    public PsiComment getDocComment() {
        return null;
    }

    @Nullable
    public VtlExpression getIterableExpression() {
        for (PsiElement wouldBeIterable = this.getNextSibling(); wouldBeIterable != null; wouldBeIterable = wouldBeIterable.getNextSibling()) {
            if (!(wouldBeIterable instanceof VtlExpression)) continue;
            return (VtlExpression)wouldBeIterable;
        }
        return null;
    }

    @Nullable
    private static PsiType extractTypeFromIterable(@Nullable VtlExpression expr) {
        if (expr == null) {
            return null;
        }
        PsiType type = expr.getPsiType();
        if (type instanceof PsiArrayType) {
            return ((PsiArrayType)type).getComponentType();
        }
        for (Object[] iterable : VELOCITY_ITERABLES) {
            String superClass = (String)iterable[0];
            if (!InheritanceUtil.isInheritor((PsiType)type, (String)superClass)) continue;
            PsiType result = PsiUtil.substituteTypeParameter((PsiType)type, (String)superClass, (int)((Integer)iterable[1]), (boolean)false);
            if (result != null) {
                return result;
            }
            return PsiType.getJavaLangObject((PsiManager)expr.getManager(), (GlobalSearchScope)expr.getResolveScope());
        }
        return null;
    }

    public static String[] getVelocityIterables(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/velocity/psi/VtlLoopVariable", "getVelocityIterables"));
        }
        return new String[]{"java.lang.Iterable<" + className + ">", "java.util.Iterator<" + className + ">", "java.util.Collection<" + className + ">", "java.util.Map<?, " + className + ">", className + "[]"};
    }
}

