/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;

public class GroupingMessageCollector
implements MessageCollector {
    private final MessageCollector delegate;
    private final Multimap<String, Message> groupedMessages;

    public GroupingMessageCollector(@NotNull MessageCollector delegate2) {
        if (delegate2 == null) {
            GroupingMessageCollector.$$$reportNull$$$0(0);
        }
        this.groupedMessages = LinkedHashMultimap.create();
        this.delegate = delegate2;
    }

    @Override
    public void clear() {
        this.groupedMessages.clear();
    }

    @Override
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location2) {
        if (severity == null) {
            GroupingMessageCollector.$$$reportNull$$$0(1);
        }
        if (message == null) {
            GroupingMessageCollector.$$$reportNull$$$0(2);
        }
        if (location2 == null) {
            GroupingMessageCollector.$$$reportNull$$$0(3);
        }
        if (CompilerMessageSeverity.VERBOSE.contains((Object)severity)) {
            this.delegate.report(severity, message, location2);
        } else {
            this.groupedMessages.put(location2.getPath(), new Message(severity, message, location2));
        }
    }

    @Override
    public boolean hasErrors() {
        for (Map.Entry<String, Message> entry : this.groupedMessages.entries()) {
            if (!entry.getValue().severity.isError()) continue;
            return true;
        }
        return false;
    }

    public void flush() {
        boolean hasErrors = this.hasErrors();
        for (String path : this.sortedKeys()) {
            for (Message message : this.groupedMessages.get(path)) {
                if (hasErrors && !message.severity.isError() && message.severity != CompilerMessageSeverity.STRONG_WARNING) continue;
                this.delegate.report(message.severity, message.message, message.location);
            }
        }
        this.groupedMessages.clear();
    }

    @NotNull
    private Collection<String> sortedKeys() {
        ArrayList<String> sortedKeys = new ArrayList<String>(this.groupedMessages.keySet());
        Collections.sort(sortedKeys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        });
        ArrayList<String> arrayList = sortedKeys;
        if (arrayList == null) {
            GroupingMessageCollector.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "sortedKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Message {
        private final CompilerMessageSeverity severity;
        private final String message;
        private final CompilerMessageLocation location;

        private Message(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location2) {
            if (severity == null) {
                Message.$$$reportNull$$$0(0);
            }
            if (message == null) {
                Message.$$$reportNull$$$0(1);
            }
            if (location2 == null) {
                Message.$$$reportNull$$$0(2);
            }
            this.severity = severity;
            this.message = message;
            this.location = location2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Message message1 = (Message)o;
            if (!this.location.equals(message1.location)) {
                return false;
            }
            if (!this.message.equals(message1.message)) {
                return false;
            }
            return this.severity == message1.severity;
        }

        public int hashCode() {
            int result2 = this.severity.hashCode();
            result2 = 31 * result2 + this.message.hashCode();
            result2 = 31 * result2 + this.location.hashCode();
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "severity";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "location";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector$Message";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

