/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.guice.GuiceBundle;
import com.intellij.guice.inspections.BaseInspectionVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BaseInspection
extends LocalInspectionTool {
    private String m_shortName = null;
    @NonNls
    private static final String INSPECTION = "Inspection";

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Guice Inspections" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/inspections/BaseInspection", "getGroupDisplayName"));
        }
        return "Guice Inspections";
    }

    @NotNull
    public String getShortName() {
        if (this.m_shortName != null) {
            String string = this.m_shortName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/inspections/BaseInspection", "getShortName"));
            }
            return string;
        }
        Class<?> aClass = ((Object)((Object)this)).getClass();
        String name = aClass.getName();
        String string = this.m_shortName = name.substring(name.lastIndexOf(46) + 1, name.length() - INSPECTION.length());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/inspections/BaseInspection", "getShortName"));
        }
        return string;
    }

    @NotNull
    protected abstract String buildErrorString(Object ... var1);

    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return false;
    }

    private String getPropertyPrefixForInspection() {
        String shortName = this.getShortName();
        return BaseInspection.getPrefix(shortName);
    }

    public static String getPrefix(String shortName) {
        int length = shortName.length();
        StringBuffer buffer = new StringBuffer(length + 10);
        buffer.append(Character.toLowerCase(shortName.charAt(0)));
        for (int i = 1; i < length; ++i) {
            char c = shortName.charAt(i);
            if (Character.isUpperCase(c)) {
                buffer.append('.');
                buffer.append(Character.toLowerCase(c));
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    @NotNull
    public String getDisplayName() {
        String displayNameSuffix = ".display.name";
        String string = GuiceBundle.message(this.getPropertyPrefixForInspection() + ".display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/inspections/BaseInspection", "getDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public abstract BaseInspectionVisitor buildVisitor();

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/guice/inspections/BaseInspection", "buildVisitor"));
        }
        BaseInspectionVisitor visitor = this.buildVisitor();
        visitor.setProblemsHolder(holder);
        visitor.setOnTheFly(isOnTheFly);
        visitor.setInspection(this);
        BaseInspectionVisitor baseInspectionVisitor = visitor;
        if (baseInspectionVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/inspections/BaseInspection", "buildVisitor"));
        }
        return baseInspectionVisitor;
    }

    public LocalQuickFix buildFix(PsiElement location, Object[] infos) {
        return null;
    }
}

