/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.model;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.guice.model.GuiceInjectionUtil;
import com.intellij.guice.model.InjectionPointDescriptor;
import com.intellij.guice.model.beans.BindDescriptor;
import com.intellij.guice.model.beans.BindToDescriptor;
import com.intellij.guice.model.jam.GuiceProvides;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiceInjectorManager {
    @NotNull
    public static Set<BindDescriptor> getInjectBindingDescriptors(@NotNull InjectionPointDescriptor ip, @NotNull Set<BindDescriptor> allDescriptors) {
        PsiClass psiClass;
        if (ip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ip", "com/intellij/guice/model/GuiceInjectorManager", "getInjectBindingDescriptors"));
        }
        if (allDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allDescriptors", "com/intellij/guice/model/GuiceInjectorManager", "getInjectBindingDescriptors"));
        }
        HashSet descriptors = ContainerUtil.newHashSet();
        PsiType type = ip.getType();
        if (type instanceof PsiClassType && (psiClass = ((PsiClassType)type).resolve()) != null) {
            for (BindDescriptor descriptor : allDescriptors) {
                if (!psiClass.equals(descriptor.getBoundClass()) || !GuiceInjectionUtil.checkBindingAnnotations(ip, descriptor)) continue;
                descriptors.add(descriptor);
            }
        }
        HashSet hashSet = descriptors;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/GuiceInjectorManager", "getInjectBindingDescriptors"));
        }
        return hashSet;
    }

    @NotNull
    public static Set<GuiceProvides> getInjectProvidesDescriptors(@NotNull InjectionPointDescriptor ip, @NotNull List<GuiceProvides> allDescriptors) {
        if (ip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ip", "com/intellij/guice/model/GuiceInjectorManager", "getInjectProvidesDescriptors"));
        }
        if (allDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allDescriptors", "com/intellij/guice/model/GuiceInjectorManager", "getInjectProvidesDescriptors"));
        }
        HashSet set = ContainerUtil.newHashSet();
        PsiType type = ip.getType();
        if (type != null) {
            for (GuiceProvides descriptor : allDescriptors) {
                PsiType productType = descriptor.getProductType();
                if (productType == null) continue;
                Set<PsiAnnotation> bindingAnnotations = descriptor.getBindingAnnotations();
                if (!type.isAssignableFrom(productType) || !GuiceInjectionUtil.checkBindingAnnotations(ip.getBindingAnnotations(), bindingAnnotations)) continue;
                set.add(descriptor);
            }
        }
        HashSet hashSet = set;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/GuiceInjectorManager", "getInjectProvidesDescriptors"));
        }
        return hashSet;
    }

    @NotNull
    public static Set<BindDescriptor> getBindingDescriptors(@Nullable Module module) {
        if (module == null) {
            Set<BindDescriptor> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/GuiceInjectorManager", "getBindingDescriptors"));
            }
            return set;
        }
        HashSet files = ContainerUtil.newHashSet();
        for (PsiClass aClass : GuiceInjectorManager.getGuiceModuleClasses(module)) {
            VirtualFile virtualFile;
            PsiFile file = aClass.getContainingFile();
            if (file == null || (virtualFile = file.getVirtualFile()) == null) continue;
            files.add(virtualFile);
        }
        if (files.size() == 0) {
            Set<BindDescriptor> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/GuiceInjectorManager", "getBindingDescriptors"));
            }
            return set;
        }
        GlobalSearchScope fileScope = GlobalSearchScope.filesScope((Project)module.getProject(), (Collection)files);
        Set set = (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create(GuiceInjectorManager.getBindingDescriptors(module.getProject(), (SearchScope)fileScope), (Collection)GuiceInjectorManager.getModificationsTrackers(module)));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/GuiceInjectorManager", "getBindingDescriptors"));
        }
        return set;
    }

    @NotNull
    public static Set<BindDescriptor> getBindingDescriptors(@NotNull PsiElement scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/guice/model/GuiceInjectorManager", "getBindingDescriptors"));
        }
        Set set = (Set)CachedValuesManager.getCachedValue((PsiElement)scope, () -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/guice/model/GuiceInjectorManager", "lambda$getBindingDescriptors$1"));
            }
            return CachedValueProvider.Result.create(GuiceInjectorManager.getBindingDescriptors(scope.getProject(), (SearchScope)new LocalSearchScope(scope)), (Object[])new Object[]{scope});
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/GuiceInjectorManager", "getBindingDescriptors"));
        }
        return set;
    }

    @NotNull
    public static Set<BindDescriptor> getBindingDescriptors(@NotNull Project project, @NotNull SearchScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/guice/model/GuiceInjectorManager", "getBindingDescriptors"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/guice/model/GuiceInjectorManager", "getBindingDescriptors"));
        }
        Set descriptors = ContainerUtil.newConcurrentSet();
        descriptors.addAll(GuiceInjectorManager.getToBindingDescriptors(project, scope));
        descriptors.addAll(GuiceInjectorManager.getToInstanceBindingDescriptors(project, scope));
        descriptors.addAll(GuiceInjectorManager.getToProviderBindingDescriptors(project, scope));
        descriptors.addAll(GuiceInjectorManager.getToConstructorBindingDescriptors(project, scope));
        Set set = descriptors;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/GuiceInjectorManager", "getBindingDescriptors"));
        }
        return set;
    }

    @NotNull
    public static Set<BindDescriptor> getToBindingDescriptors(@NotNull Project project, @NotNull SearchScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/guice/model/GuiceInjectorManager", "getToBindingDescriptors"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/guice/model/GuiceInjectorManager", "getToBindingDescriptors"));
        }
        Set<BindDescriptor> set = GuiceInjectorManager.getDescriptors(project, scope, "to");
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/GuiceInjectorManager", "getToBindingDescriptors"));
        }
        return set;
    }

    private static Set<BindDescriptor> getDescriptors(@NotNull Project project, @NotNull SearchScope scope, @NotNull String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/guice/model/GuiceInjectorManager", "getDescriptors"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/guice/model/GuiceInjectorManager", "getDescriptors"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/guice/model/GuiceInjectorManager", "getDescriptors"));
        }
        Set<PsiMethodCallExpression> expressions = GuiceInjectorManager.getLinkedBindingBuilderExpressions(project, scope, name);
        return ContainerUtil.map2Set(expressions, expression -> new BindToDescriptor((PsiMethodCallExpression)expression));
    }

    @NotNull
    public static Set<BindDescriptor> getToInstanceBindingDescriptors(@NotNull Project project, @NotNull SearchScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/guice/model/GuiceInjectorManager", "getToInstanceBindingDescriptors"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/guice/model/GuiceInjectorManager", "getToInstanceBindingDescriptors"));
        }
        Set<BindDescriptor> set = GuiceInjectorManager.getDescriptors(project, scope, "toInstance");
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/GuiceInjectorManager", "getToInstanceBindingDescriptors"));
        }
        return set;
    }

    @NotNull
    public static Set<BindDescriptor> getToProviderBindingDescriptors(@NotNull Project project, @NotNull SearchScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/guice/model/GuiceInjectorManager", "getToProviderBindingDescriptors"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/guice/model/GuiceInjectorManager", "getToProviderBindingDescriptors"));
        }
        Set<BindDescriptor> set = GuiceInjectorManager.getDescriptors(project, scope, "toProvider");
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/GuiceInjectorManager", "getToProviderBindingDescriptors"));
        }
        return set;
    }

    @NotNull
    public static Set<BindDescriptor> getToConstructorBindingDescriptors(@NotNull Project project, @NotNull SearchScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/guice/model/GuiceInjectorManager", "getToConstructorBindingDescriptors"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/guice/model/GuiceInjectorManager", "getToConstructorBindingDescriptors"));
        }
        Set<BindDescriptor> set = GuiceInjectorManager.getDescriptors(project, scope, "toConstructor");
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/GuiceInjectorManager", "getToConstructorBindingDescriptors"));
        }
        return set;
    }

    @NotNull
    public static PsiClass[] getGuiceModuleClasses(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/guice/model/GuiceInjectorManager", "getGuiceModuleClasses"));
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesScope((Module)module);
        PsiClass[] psiClassArray = (PsiClass[])CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/guice/model/GuiceInjectorManager", "lambda$getGuiceModuleClasses$3"));
            }
            com.intellij.util.containers.hash.HashSet<PsiClass> psiClasses = new com.intellij.util.containers.hash.HashSet<PsiClass>(){};
            PsiClass abstractModuleClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("com.google.inject.AbstractModule", scope);
            if (abstractModuleClass != null) {
                psiClasses.addAll(ClassInheritorsSearch.search((PsiClass)abstractModuleClass, (SearchScope)scope, (boolean)true).findAll());
            }
            PsiClass[] classes = (PsiClass[])ArrayUtil.toObjectArray((Collection)psiClasses, PsiClass.class);
            return CachedValueProvider.Result.createSingleDependency((Object)classes, (Object)PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        });
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/GuiceInjectorManager", "getGuiceModuleClasses"));
        }
        return psiClassArray;
    }

    private static Collection getModificationsTrackers(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/guice/model/GuiceInjectorManager", "getModificationsTrackers"));
        }
        com.intellij.util.containers.hash.HashSet deps = new com.intellij.util.containers.hash.HashSet();
        deps.addAll(Arrays.asList(GuiceInjectorManager.getGuiceModuleClasses(module)));
        deps.add(PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        return deps;
    }

    @NotNull
    private static Set<PsiMethodCallExpression> getLinkedBindingBuilderExpressions(@NotNull Project project, @NotNull SearchScope scope, @NotNull String methodName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/guice/model/GuiceInjectorManager", "getLinkedBindingBuilderExpressions"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/guice/model/GuiceInjectorManager", "getLinkedBindingBuilderExpressions"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/guice/model/GuiceInjectorManager", "getLinkedBindingBuilderExpressions"));
        }
        Set expressions = ContainerUtil.newConcurrentSet();
        PsiClass moduleClass = JavaPsiFacade.getInstance((Project)project).findClass("com.google.inject.binder.LinkedBindingBuilder", GlobalSearchScope.allScope((Project)project));
        if (moduleClass != null) {
            PsiMethod[] binds;
            for (PsiMethod bind : binds = moduleClass.findMethodsByName(methodName, false)) {
                expressions.addAll(StringExpressionHelper.searchMethodCalls((PsiMethod)bind, (SearchScope)scope));
            }
        }
        Set set = expressions;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/GuiceInjectorManager", "getLinkedBindingBuilderExpressions"));
        }
        return set;
    }

    @NotNull
    public static Collection<PsiClass> getBindingAnnotations(@Nullable Module module) {
        Collection<Object> collection = module == null ? Collections.emptySet() : MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)module, (String)"com.google.inject.BindingAnnotation", (boolean)false);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/GuiceInjectorManager", "getBindingAnnotations"));
        }
        return collection;
    }

    @NotNull
    public static Set<PsiAnnotation> getBindingAnnotations(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/guice/model/GuiceInjectorManager", "getBindingAnnotations"));
        }
        Set annotations = ContainerUtil.newConcurrentSet();
        for (PsiClass psiClass : GuiceInjectorManager.getBindingAnnotations(ModuleUtilCore.findModuleForPsiElement((PsiElement)owner))) {
            PsiAnnotation annotation;
            String fqn = psiClass.getQualifiedName();
            if (fqn == null || (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{fqn})) == null) continue;
            annotations.add(annotation);
        }
        Set set = annotations;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/GuiceInjectorManager", "getBindingAnnotations"));
        }
        return set;
    }
}

