/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.util.nodes;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.data.commons.util.nodes.ContainerNode;
import com.intellij.spring.data.commons.util.nodes.OrSetNode;
import com.intellij.spring.data.commons.util.nodes.OrderByNode;
import com.intellij.spring.data.commons.util.nodes.QueryNode;
import com.intellij.spring.data.commons.util.nodes.SimpleLeaf;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class RootNode
extends ContainerNode {
    private static final Pattern ALL_IGNORE_CASE = Pattern.compile("AllIgnor(ing|e)Case");
    private final Set<QueryNode> nodes;
    private boolean alwaysIgnoreCase;

    public RootNode(@NotNull String expression, String methodType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/spring/data/commons/util/nodes/RootNode", "<init>"));
        }
        super(expression);
        this.nodes = new LinkedHashSet<QueryNode>();
        this.alwaysIgnoreCase = false;
        if (!StringUtil.isEmptyOrSpaces((String)methodType)) {
            this.nodes.add(new SimpleLeaf(methodType));
        }
        List orderByParts = StringUtil.split((String)this.detectAndSetAllIgnoreCase(expression), (String)"OrderBy", (boolean)true, (boolean)false);
        for (int i = 0; i < orderByParts.size(); ++i) {
            String orderBy = (String)orderByParts.get(i);
            if (i == 0) {
                this.nodes.add(new OrSetNode(orderBy));
            } else {
                this.nodes.add(new OrderByNode(orderBy));
            }
            if (i == orderByParts.size() - 1) continue;
            this.nodes.add(new SimpleLeaf("OrderBy"));
        }
    }

    @Override
    @NotNull
    public Set<? extends QueryNode> getChildren() {
        Set<QueryNode> set = this.nodes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/util/nodes/RootNode", "getChildren"));
        }
        return set;
    }

    private String detectAndSetAllIgnoreCase(String expression) {
        Matcher matcher = ALL_IGNORE_CASE.matcher(expression);
        if (matcher.find()) {
            this.alwaysIgnoreCase = true;
            expression = expression.substring(0, matcher.start()) + expression.substring(matcher.end(), expression.length());
        }
        return expression;
    }
}

