/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.jam;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiType;
import com.intellij.psi.targets.AliasingPsiTarget;
import com.intellij.psi.targets.AliasingPsiTargetUtil;
import com.intellij.psi.util.PropertyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CdiNamedBean<T extends PsiMember & PsiNamedElement>
implements JamElement {
    private static final JamStringAttributeMeta.Single<String> NAME_VALUE_META = JamAttributeMeta.singleString((String)"value");
    private final JamAnnotationMeta myMeta;
    protected final T myMember;
    private final boolean isStereotype;

    public CdiNamedBean(T psiMember, String annoName) {
        this.myMember = psiMember;
        this.myMeta = new JamAnnotationMeta(annoName);
        this.isStereotype = !"javax.inject.Named".equals(annoName);
    }

    public boolean isStereotypeAnnotated() {
        return this.isStereotype;
    }

    @NotNull
    public String getName() {
        if (this.isStereotypeAnnotated()) {
            String string = this.getDefaultName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/jam/CdiNamedBean", "getName"));
            }
            return string;
        }
        String nameValue = this.getNamedStringAttributeElement().getStringValue();
        String string = StringUtil.isEmptyOrSpaces((String)nameValue) ? this.getDefaultName() : nameValue;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/jam/CdiNamedBean", "getName"));
        }
        return string;
    }

    @NotNull
    private JamStringAttributeElement<String> getNamedStringAttributeElement() {
        JamStringAttributeElement jamStringAttributeElement = (JamStringAttributeElement)this.myMeta.getAttribute(this.myMember, NAME_VALUE_META);
        if (jamStringAttributeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/jam/CdiNamedBean", "getNamedStringAttributeElement"));
        }
        return jamStringAttributeElement;
    }

    public abstract String getDefaultName();

    @Nullable
    public abstract PsiType getType();

    public PsiNamedElement getIdentifyingPsiElement() {
        return (PsiNamedElement)PomService.convertToPsi((Project)this.myMember.getProject(), (PomTarget)this.getPsiTarget());
    }

    public PsiTarget getPsiTarget() {
        JamStringAttributeElement<String> namedAttributeValue = this.getNamedStringAttributeElement();
        if (StringUtil.isEmptyOrSpaces((String)namedAttributeValue.getStringValue())) {
            return this.getAliasingPsiTarget();
        }
        return new JamPomTarget((JamElement)this, namedAttributeValue);
    }

    protected abstract PsiTarget getAliasingPsiTarget();

    @NotNull
    public T getPsiElement() {
        T t = this.myMember;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/jam/CdiNamedBean", "getPsiElement"));
        }
        return t;
    }

    public static class FieldMapping
    extends CdiNamedBean<PsiField> {
        public FieldMapping(PsiField psiField, String annoName) {
            super(psiField, annoName);
        }

        @Override
        public String getDefaultName() {
            return ((PsiField)this.getPsiElement()).getName();
        }

        @Override
        @Nullable
        public PsiType getType() {
            return ((PsiField)this.getPsiElement()).getType();
        }

        @Override
        protected PsiTarget getAliasingPsiTarget() {
            return new AliasingPsiTarget((PsiNamedElement)this.getPsiElement()){

                public String getNameAlias(@Nullable String delegatePsiTargetName) {
                    return StringUtil.decapitalize((String)delegatePsiTargetName);
                }

                @NotNull
                public AliasingPsiTarget setAliasName(@NotNull String newAliasName) {
                    if (newAliasName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newAliasName", "com/intellij/cdi/jam/CdiNamedBean$FieldMapping$1", "setAliasName"));
                    }
                    AliasingPsiTargetUtil.renameTargets((AliasingPsiTarget)this, (String)newAliasName);
                    AliasingPsiTarget aliasingPsiTarget = super.setAliasName(newAliasName);
                    if (aliasingPsiTarget == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/jam/CdiNamedBean$FieldMapping$1", "setAliasName"));
                    }
                    return aliasingPsiTarget;
                }
            };
        }
    }

    public static class MethodMapping
    extends CdiNamedBean<PsiMethod> {
        public MethodMapping(PsiMethod method, String annoName) {
            super(method, annoName);
        }

        @Override
        public String getDefaultName() {
            String propertyName = PropertyUtil.getPropertyName((PsiMethod)((PsiMethod)this.getPsiElement()));
            return propertyName == null ? ((PsiMethod)this.getPsiElement()).getName() : propertyName;
        }

        @Override
        @Nullable
        public PsiType getType() {
            return ((PsiMethod)this.getPsiElement()).getReturnType();
        }

        @Override
        protected PsiTarget getAliasingPsiTarget() {
            return new AliasingPsiTarget((PsiNamedElement)this.getPsiElement()){

                public String getNameAlias(@Nullable String delegatePsiTargetName) {
                    String propertyName = PropertyUtil.getPropertyName((String)delegatePsiTargetName);
                    return StringUtil.isEmptyOrSpaces((String)propertyName) ? super.getNameAlias(delegatePsiTargetName) : propertyName;
                }

                @NotNull
                public AliasingPsiTarget setAliasName(@NotNull String newAliasName) {
                    if (newAliasName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newAliasName", "com/intellij/cdi/jam/CdiNamedBean$MethodMapping$1", "setAliasName"));
                    }
                    AliasingPsiTargetUtil.renameTargets((AliasingPsiTarget)this, (String)newAliasName);
                    AliasingPsiTarget aliasingPsiTarget = super.setAliasName(newAliasName);
                    if (aliasingPsiTarget == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/jam/CdiNamedBean$MethodMapping$1", "setAliasName"));
                    }
                    return aliasingPsiTarget;
                }
            };
        }
    }

    public static class ClassMapping
    extends CdiNamedBean<PsiClass> {
        public ClassMapping(PsiClass psiClass, String annoName) {
            super(psiClass, annoName);
        }

        @Override
        public String getDefaultName() {
            return StringUtil.decapitalize((String)((PsiClass)this.getPsiElement()).getName());
        }

        @Override
        @NotNull
        public PsiType getType() {
            PsiClass psiClass = (PsiClass)this.getPsiElement();
            PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)psiClass.getProject()).createType(psiClass);
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/jam/CdiNamedBean$ClassMapping", "getType"));
            }
            return psiClassType;
        }

        @Override
        protected PsiTarget getAliasingPsiTarget() {
            return new AliasingPsiTarget((PsiNamedElement)this.getPsiElement()){

                public String getNameAlias(@Nullable String delegatePsiTargetName) {
                    return StringUtil.decapitalize((String)delegatePsiTargetName);
                }

                @NotNull
                public AliasingPsiTarget setAliasName(@NotNull String newAliasName) {
                    if (newAliasName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newAliasName", "com/intellij/cdi/jam/CdiNamedBean$ClassMapping$1", "setAliasName"));
                    }
                    AliasingPsiTargetUtil.renameTargets((AliasingPsiTarget)this, (String)StringUtil.capitalize((String)newAliasName));
                    AliasingPsiTarget aliasingPsiTarget = super.setAliasName(newAliasName);
                    if (aliasingPsiTarget == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/jam/CdiNamedBean$ClassMapping$1", "setAliasName"));
                    }
                    return aliasingPsiTarget;
                }
            };
        }
    }
}

