/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.navigation;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00032\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e*\u0004\u0018\u00010\u000fH\u0002\u00a8\u0006\u0010"}, d2={"getInfo", "Lorg/jetbrains/android/util/AndroidResourceUtil$MyReferredResourceFieldInfo;", "referenceExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "getReceiverAsSimpleNameExpression", "exp", "getReferenceExpression", "element", "Lcom/intellij/psi/PsiElement;", "getReferredInfo", "lastPart", "getParentQualified", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "idea-android"})
public final class GotoResourceHelperKt {
    @Nullable
    public static final KtSimpleNameExpression getReferenceExpression(@Nullable PsiElement element2) {
        return (KtSimpleNameExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, KtSimpleNameExpression.class);
    }

    @Nullable
    public static final AndroidResourceUtil.MyReferredResourceFieldInfo getInfo(@NotNull KtSimpleNameExpression referenceExpression, @NotNull AndroidFacet facet) {
        Intrinsics.checkParameterIsNotNull((Object)referenceExpression, (String)"referenceExpression");
        Intrinsics.checkParameterIsNotNull((Object)facet, (String)"facet");
        AndroidResourceUtil.MyReferredResourceFieldInfo info = GotoResourceHelperKt.getReferredInfo(referenceExpression, facet);
        if (info != null) {
            return info;
        }
        KtDotQualifiedExpression ktDotQualifiedExpression = GotoResourceHelperKt.getParentQualified(GotoResourceHelperKt.getParentQualified(referenceExpression));
        if (ktDotQualifiedExpression == null) {
            return null;
        }
        KtDotQualifiedExpression topMostQualified = ktDotQualifiedExpression;
        KtExpression ktExpression = topMostQualified.getSelectorExpression();
        if (!(ktExpression instanceof KtSimpleNameExpression)) {
            ktExpression = null;
        }
        KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression;
        if (ktSimpleNameExpression == null) {
            return null;
        }
        KtSimpleNameExpression selectorCandidate = ktSimpleNameExpression;
        return GotoResourceHelperKt.getReferredInfo(selectorCandidate, facet);
    }

    private static final KtDotQualifiedExpression getParentQualified(@Nullable KtExpression $receiver) {
        KtExpression ktExpression = $receiver;
        Object object = ktExpression != null ? ktExpression.getParent() : null;
        if (!(object instanceof KtDotQualifiedExpression)) {
            object = null;
        }
        return (KtDotQualifiedExpression)object;
    }

    private static final AndroidResourceUtil.MyReferredResourceFieldInfo getReferredInfo(KtSimpleNameExpression lastPart, AndroidFacet facet) {
        boolean isFromCorrectFile;
        String resFieldName = lastPart.getReferencedName();
        CharSequence charSequence = resFieldName;
        if (charSequence.length() == 0) {
            return null;
        }
        KtSimpleNameExpression ktSimpleNameExpression = GotoResourceHelperKt.getReceiverAsSimpleNameExpression(lastPart);
        if (ktSimpleNameExpression == null) {
            return null;
        }
        KtSimpleNameExpression middlePart = ktSimpleNameExpression;
        String resClassName = middlePart.getReferencedName();
        CharSequence charSequence2 = resClassName;
        if (charSequence2.length() == 0) {
            return null;
        }
        KtSimpleNameExpression ktSimpleNameExpression2 = GotoResourceHelperKt.getReceiverAsSimpleNameExpression(middlePart);
        if (ktSimpleNameExpression2 == null) {
            return null;
        }
        KtSimpleNameExpression firstPart = ktSimpleNameExpression2;
        PsiElement psiElement2 = ReferenceUtilKt.getMainReference(firstPart).resolve();
        if (!(psiElement2 instanceof PsiClass)) {
            psiElement2 = null;
        }
        PsiClass psiClass2 = (PsiClass)psiElement2;
        if (psiClass2 == null) {
            return null;
        }
        PsiClass resolvedClass = psiClass2;
        String classShortName = resolvedClass.getName();
        boolean fromManifest = Intrinsics.areEqual((Object)"Manifest", (Object)classShortName);
        if (!fromManifest && Intrinsics.areEqual((Object)"R", (Object)classShortName) ^ true) {
            return null;
        }
        String qName = resolvedClass.getQualifiedName();
        if (Intrinsics.areEqual((Object)"android.R", (Object)qName) || Intrinsics.areEqual((Object)"com.android.internal.R", (Object)qName)) {
            return new AndroidResourceUtil.MyReferredResourceFieldInfo(resClassName, resFieldName, true, false);
        }
        PsiFile psiFile = resolvedClass.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        PsiFile containingFile = psiFile;
        boolean bl = isFromCorrectFile = fromManifest ? AndroidResourceUtil.isManifestJavaFile((AndroidFacet)facet, (PsiFile)containingFile) : AndroidResourceUtil.isRJavaFile((AndroidFacet)facet, (PsiFile)containingFile);
        if (!isFromCorrectFile) {
            return null;
        }
        return new AndroidResourceUtil.MyReferredResourceFieldInfo(resClassName, resFieldName, false, fromManifest);
    }

    private static final KtSimpleNameExpression getReceiverAsSimpleNameExpression(KtSimpleNameExpression exp) {
        KtSimpleNameExpression ktSimpleNameExpression;
        KtExpression receiver = KtPsiUtilKt.getReceiverExpression(exp);
        KtExpression ktExpression = receiver;
        if (ktExpression instanceof KtSimpleNameExpression) {
            ktSimpleNameExpression = (KtSimpleNameExpression)receiver;
        } else if (ktExpression instanceof KtDotQualifiedExpression) {
            KtExpression ktExpression2 = ((KtDotQualifiedExpression)receiver).getSelectorExpression();
            if (!(ktExpression2 instanceof KtSimpleNameExpression)) {
                ktExpression2 = null;
            }
            ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression2;
        } else {
            ktSimpleNameExpression = null;
        }
        return ktSimpleNameExpression;
    }
}

