/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.GradleProjectImportHandler;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleSourceSetDataServiceKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0005\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00020\u00020\u0006\u00a2\u0006\u0002\b\bH\u0016J6\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleSourceSetDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lorg/jetbrains/plugins/gradle/model/data/GradleSourceSetData;", "Ljava/lang/Void;", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "postProcess", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "idea"})
public final class KotlinGradleSourceSetDataService
extends AbstractProjectDataService<GradleSourceSetData, Void> {
    @NotNull
    public Key<GradleSourceSetData> getTargetDataKey() {
        return GradleSourceSetData.KEY;
    }

    public void postProcess(@NotNull Collection<? extends DataNode<GradleSourceSetData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkParameterIsNotNull(toImport, (String)"toImport");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        for (DataNode<GradleSourceSetData> dataNode : toImport) {
            Module ideModule;
            DataNode moduleNode;
            GradleSourceSetData sourceSetData = (GradleSourceSetData)dataNode.getData();
            if (modelsProvider.findIdeModule((ModuleData)sourceSetData) == null) {
                continue;
            }
            if (ExternalSystemApiUtil.findParent(dataNode, (Key)ProjectKeys.MODULE) == null) {
                continue;
            }
            DataNode dataNode2 = moduleNode;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataNode2, (String)"moduleNode");
            Module module = ideModule;
            Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"ideModule");
            if (KotlinGradleSourceSetDataServiceKt.access$configureFacetByGradleModule(dataNode2, dataNode, module, modelsProvider) == null) {
                continue;
            }
            Iterable $receiver$iv = GradleProjectImportHandler.Companion.getInstances(project);
            for (Object element$iv : $receiver$iv) {
                KotlinFacet kotlinFacet;
                GradleProjectImportHandler it = (GradleProjectImportHandler)element$iv;
                it.importBySourceSet(kotlinFacet, dataNode);
            }
        }
    }
}

