/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a;\u0010\u0006\u001a\u0002H\u0007\"\b\b\u0000\u0010\u0007*\u00020\b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u0002H\u00072\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\r\u001aB\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000f\"\b\b\u0000\u0010\u0007*\u00020\b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00070\u00112\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0001\u001a\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u001c\u0010\u001c\u001a\u00020\u0013*\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u001a\n\u0010\u001f\u001a\u00020\u0013*\u00020\u0003\u00a8\u0006 "}, d2={"findInsertAfterAnchor", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "body", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "insertMember", "T", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "declaration", "anchor", "(Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/psi/KtDeclaration;Lcom/intellij/psi/PsiElement;)Lorg/jetbrains/kotlin/psi/KtDeclaration;", "insertMembersAfter", "", "members", "", "moveCaretIntoGeneratedElement", "", "element", "moveCaretIntoGeneratedElementDocumentUnblocked", "", "removeAfterOffset", "offset", "", "whiteSpace", "Lcom/intellij/psi/PsiWhiteSpace;", "moveCaret", "scrollType", "Lcom/intellij/openapi/editor/ScrollType;", "unblockDocument", "idea-core"})
public final class GenerateUtilKt {
    public static final void moveCaretIntoGeneratedElement(@NotNull Editor editor, @NotNull PsiElement element2) {
        block0: {
            PsiElement psiElement2;
            PsiElement it;
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            Project project = element2.getProject();
            SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(element2);
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            PsiElement psiElement3 = pointer.getElement();
            if (psiElement3 == null) break block0;
            PsiElement psiElement4 = it = (psiElement2 = psiElement3);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"it");
            GenerateUtilKt.moveCaretIntoGeneratedElementDocumentUnblocked(editor, psiElement4);
        }
    }

    private static final boolean moveCaretIntoGeneratedElementDocumentUnblocked(Editor editor, PsiElement element2) {
        KtExpression expression2;
        if (element2 instanceof KtDeclarationWithBody && ((KtDeclarationWithBody)element2).hasBody() && (expression2 = ((KtDeclarationWithBody)element2).getBodyExpression()) instanceof KtBlockExpression) {
            PsiElement lBrace = ((KtBlockExpression)expression2).getLBrace();
            PsiElement rBrace = ((KtBlockExpression)expression2).getRBrace();
            if (lBrace != null && rBrace != null) {
                Object element$iv3;
                PsiElement firstInBlock;
                block13: {
                    Object element$iv22;
                    block12: {
                        Sequence<PsiElement> $receiver$iv = PsiUtilsKt.siblings(lBrace, true, false);
                        for (Object element$iv22 : $receiver$iv) {
                            PsiElement it = (PsiElement)element$iv22;
                            if (!(!(it instanceof PsiWhiteSpace))) continue;
                            break block12;
                        }
                        throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                    }
                    firstInBlock = (PsiElement)element$iv22;
                    Sequence<PsiElement> $receiver$iv = PsiUtilsKt.siblings(rBrace, false, false);
                    for (Object element$iv3 : $receiver$iv) {
                        PsiElement it = (PsiElement)element$iv3;
                        if (!(!(it instanceof PsiWhiteSpace))) continue;
                        break block13;
                    }
                    throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                PsiElement lastInBlock = (PsiElement)element$iv3;
                TextRange textRange = firstInBlock.getTextRange();
                if (textRange == null) {
                    Intrinsics.throwNpe();
                }
                int start = textRange.getStartOffset();
                TextRange textRange2 = lastInBlock.getTextRange();
                if (textRange2 == null) {
                    Intrinsics.throwNpe();
                }
                int end = textRange2.getEndOffset();
                GenerateUtilKt.moveCaret$default(editor, Math.min(start, end), null, 2, null);
                if (start < end) {
                    editor.getSelectionModel().setSelection(start, end);
                }
                return true;
            }
        }
        if (element2 instanceof KtDeclarationWithInitializer && ((KtDeclarationWithInitializer)element2).hasInitializer()) {
            TextRange initializerRange;
            expression2 = ((KtDeclarationWithInitializer)element2).getInitializer();
            if (expression2 == null) {
                throw (Throwable)((Object)new AssertionError());
            }
            TextRange textRange = initializerRange = expression2.getTextRange();
            int offset2 = textRange != null ? textRange.getStartOffset() : element2.getTextOffset();
            GenerateUtilKt.moveCaret$default(editor, offset2, null, 2, null);
            if (initializerRange != null) {
                editor.getSelectionModel().setSelection(initializerRange.getStartOffset(), initializerRange.getEndOffset());
            }
            return true;
        }
        if (element2 instanceof KtProperty) {
            Iterator<KtPropertyAccessor> iterator2 = ((KtProperty)element2).getAccessors().iterator();
            while (iterator2.hasNext()) {
                KtPropertyAccessor accessor;
                KtPropertyAccessor ktPropertyAccessor = accessor = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktPropertyAccessor, (String)"accessor");
                if (!GenerateUtilKt.moveCaretIntoGeneratedElementDocumentUnblocked(editor, ktPropertyAccessor)) continue;
                return true;
            }
        }
        return false;
    }

    public static final void unblockDocument(@NotNull Editor $receiver) {
        block0: {
            Project project;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Project project2 = $receiver.getProject();
            if (project2 == null) break block0;
            Project it = project = project2;
            PsiDocumentManager.getInstance((Project)it).doPostponedOperationsAndUnblockDocument($receiver.getDocument());
        }
    }

    public static final void moveCaret(@NotNull Editor $receiver, int offset2, @NotNull ScrollType scrollType) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)scrollType, (String)"scrollType");
        $receiver.getCaretModel().moveToOffset(offset2);
        $receiver.getScrollingModel().scrollToCaret(scrollType);
    }

    public static /* bridge */ /* synthetic */ void moveCaret$default(Editor editor, int n, ScrollType scrollType, int n2, Object object) {
        if ((n2 & 2) != 0) {
            scrollType = ScrollType.RELATIVE;
        }
        GenerateUtilKt.moveCaret(editor, n, scrollType);
    }

    private static final PsiElement findInsertAfterAnchor(Editor editor, KtClassBody body2) {
        PsiElement psiElement2 = body2.getLBrace();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement afterAnchor = psiElement2;
        Editor editor2 = editor;
        int offset2 = editor2 != null && (editor2 = editor2.getCaretModel()) != null ? editor2.getOffset() : PsiUtilsKt.getStartOffset((PsiElement)body2);
        PsiElement offsetCursorElement2 = PsiTreeUtil.findFirstParent((PsiElement)body2.getContainingFile().findElementAt(offset2), (Condition)((Condition)new Condition<PsiElement>(body2){
            final /* synthetic */ KtClassBody $body;

            public final boolean value(PsiElement it) {
                return Intrinsics.areEqual((Object)it.getParent(), (Object)this.$body);
            }
            {
                this.$body = ktClassBody;
            }
        }));
        if (offsetCursorElement2 instanceof PsiWhiteSpace) {
            return GenerateUtilKt.removeAfterOffset(offset2, (PsiWhiteSpace)offsetCursorElement2);
        }
        if (offsetCursorElement2 != null && Intrinsics.areEqual((Object)offsetCursorElement2, (Object)body2.getRBrace()) ^ true) {
            return offsetCursorElement2;
        }
        return afterAnchor;
    }

    private static final PsiElement removeAfterOffset(int offset2, PsiWhiteSpace whiteSpace) {
        ASTNode spaceNode = whiteSpace.getNode();
        if (spaceNode.getTextRange().contains(offset2)) {
            String string = spaceNode.getText();
            int n = 0;
            int n2 = offset2 - spaceNode.getStartOffset();
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String beforeWhiteSpaceText = string3;
            if (!StringUtil.containsLineBreak((CharSequence)beforeWhiteSpaceText)) {
                beforeWhiteSpaceText = beforeWhiteSpaceText + "\n";
            }
            Project project = whiteSpace.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"whiteSpace.project");
            KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
            PsiElement insertAfter = whiteSpace.getPrevSibling();
            whiteSpace.delete();
            PsiElement beforeSpace = factory2.createWhiteSpace(beforeWhiteSpaceText);
            insertAfter.getParent().addAfter(beforeSpace, insertAfter);
            PsiElement psiElement2 = insertAfter.getNextSibling();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"insertAfter.nextSibling");
            return psiElement2;
        }
        return (PsiElement)whiteSpace;
    }

    @NotNull
    public static final <T extends KtDeclaration> List<T> insertMembersAfter(@Nullable Editor editor, @NotNull KtClassOrObject classOrObject, @NotNull Collection<? extends T> members, @Nullable PsiElement anchor2) {
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        Intrinsics.checkParameterIsNotNull(members, (String)"members");
        Collection<T> $receiver$iv = members;
        if ($receiver$iv.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Object t = ApplicationUtilsKt.runWriteAction((Function0)new Function0<List<? extends T>>(members, classOrObject, anchor2, editor){
            final /* synthetic */ Collection $members;
            final /* synthetic */ KtClassOrObject $classOrObject;
            final /* synthetic */ PsiElement $anchor;
            final /* synthetic */ Editor $editor;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<T> invoke() {
                void otherMembers;
                void parameters2;
                Iterable $receiver$iv;
                SmartList insertedMembers = new SmartList();
                Iterable $receiver$iv2 = this.$members;
                Object first$iv = new ArrayList<T>();
                ArrayList<T> second$iv = new ArrayList<T>();
                for (T element$iv : $receiver$iv2) {
                    KtDeclaration it = (KtDeclaration)element$iv;
                    if (it instanceof KtParameter) {
                        ((ArrayList)first$iv).add(element$iv);
                        continue;
                    }
                    second$iv.add(element$iv);
                }
                Pair pair2 = new Pair(first$iv, second$iv);
                List list2 = (List)pair2.component1();
                List list3 = (List)pair2.component2();
                pair2 = null;
                Iterable $receiver$iv$iv = $receiver$iv = (Iterable)parameters2;
                first$iv = $receiver$iv$iv.iterator();
                while (first$iv.hasNext()) {
                    KtDeclaration $i$a$1$partition;
                    KtDeclaration ktDeclaration;
                    E element$iv$iv;
                    E element$iv = element$iv$iv = first$iv.next();
                    KtDeclaration it = (KtDeclaration)element$iv;
                    if (!(this.$classOrObject instanceof KtClass)) {
                        ktDeclaration = null;
                    } else {
                        KtDeclaration ktDeclaration2 = it;
                        if (ktDeclaration2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParameter");
                        }
                        KtParameter ktParameter = KtClassKt.createPrimaryConstructorParameterListIfAbsent((KtClass)this.$classOrObject).addParameter((KtParameter)ktDeclaration2);
                        if (ktParameter == null) {
                            throw new TypeCastException("null cannot be cast to non-null type T");
                        }
                        ktDeclaration = ktParameter;
                    }
                    if (ktDeclaration == null) continue;
                    KtDeclaration it$iv = $i$a$1$partition = ktDeclaration;
                    ((Collection)insertedMembers).add(it$iv);
                }
                Collection cfr_ignored_0 = (Collection)insertedMembers;
                $receiver$iv = (Collection)otherMembers;
                if (!$receiver$iv.isEmpty()) {
                    Iterable $receiver$iv3;
                    KtClassBody body2 = KtClassOrObjectKt.getOrCreateBody(this.$classOrObject);
                    $receiver$iv$iv = new Ref.ObjectRef();
                    PsiElement psiElement2 = this.$anchor;
                    if (psiElement2 == null) {
                        psiElement2 = GenerateUtilKt.access$findInsertAfterAnchor(this.$editor, body2);
                    }
                    if (psiElement2 == null) {
                        return CollectionsKt.emptyList();
                    }
                    ((Ref.ObjectRef)$receiver$iv$iv).element = psiElement2;
                    Iterable $receiver$iv$iv2 = $receiver$iv3 = (Iterable)otherMembers;
                    Iterator<T> iterator2 = $receiver$iv$iv2.iterator();
                    while (iterator2.hasNext()) {
                        KtDeclaration ktDeclaration;
                        KtDeclaration ktDeclaration3;
                        void afterAnchor;
                        T element$iv$iv;
                        T element$iv = element$iv$iv = iterator2.next();
                        KtDeclaration it = (KtDeclaration)element$iv;
                        if (this.$classOrObject instanceof KtClass && ((KtClass)this.$classOrObject).isEnum()) {
                            PsiElement bound;
                            Object $receiver$iv4;
                            PsiElement psiElement3;
                            void $receiver$iv$iv3;
                            Iterable $receiver$iv5;
                            Iterable $i$a$1$let = $receiver$iv5 = (Iterable)((KtClass)this.$classOrObject).getDeclarations();
                            Collection destination$iv$iv = new ArrayList<E>();
                            for (T element$iv$iv2 : $receiver$iv$iv3) {
                                if (!(element$iv$iv2 instanceof KtEnumEntry)) continue;
                                destination$iv$iv.add(element$iv$iv2);
                            }
                            List enumEntries = (List)destination$iv$iv;
                            KtEnumEntry ktEnumEntry = (KtEnumEntry)CollectionsKt.lastOrNull((List)enumEntries);
                            if (ktEnumEntry != null) {
                                psiElement3 = ktEnumEntry;
                            } else {
                                Object v6;
                                block26: {
                                    $receiver$iv4 = PsiUtilsKt.getAllChildren(this.$classOrObject);
                                    Iterator iterator3 = $receiver$iv4.iterator();
                                    while (iterator3.hasNext()) {
                                        E element$iv2 = iterator3.next();
                                        PsiElement it2 = (PsiElement)element$iv2;
                                        if (!Intrinsics.areEqual((Object)it2.getNode().getElementType(), (Object)((Object)KtTokens.SEMICOLON))) continue;
                                        v6 = element$iv2;
                                        break block26;
                                    }
                                    v6 = null;
                                }
                                psiElement3 = bound = (PsiElement)v6;
                            }
                            if (!(it instanceof KtEnumEntry)) {
                                if (bound != null && PsiUtilsKt.getStartOffset((PsiElement)afterAnchor.element) <= PsiUtilsKt.getStartOffset(bound)) {
                                    afterAnchor.element = bound;
                                }
                            } else if (bound == null && !($receiver$iv4 = (Collection)body2.getDeclarations()).isEmpty()) {
                                if (body2.getLBrace() == null) {
                                    Intrinsics.throwNpe();
                                }
                                afterAnchor.element = afterAnchor.element;
                            } else if (bound != null && PsiUtilsKt.getStartOffset((PsiElement)afterAnchor.element) > PsiUtilsKt.getStartOffset(bound)) {
                                if (bound.getPrevSibling() == null) {
                                    Intrinsics.throwNpe();
                                }
                                afterAnchor.element = afterAnchor.element;
                            }
                        }
                        PsiElement psiElement4 = body2.addAfter(it, (PsiElement)afterAnchor.element);
                        if (psiElement4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type T");
                        }
                        KtDeclaration $receiver = ktDeclaration3 = (KtDeclaration)psiElement4;
                        afterAnchor.element = $receiver;
                        if (ktDeclaration3 == null) continue;
                        KtDeclaration it$iv = ktDeclaration;
                        ((Collection)insertedMembers).add(it$iv);
                    }
                    Collection cfr_ignored_1 = (Collection)insertedMembers;
                    Object var5_2 = null;
                }
                ShortenReferences.process$default(ShortenReferences.DEFAULT, (Iterable)insertedMembers, null, 2, null);
                if (this.$editor != null) {
                    Object object = CollectionsKt.first((List)((List)insertedMembers));
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"insertedMembers.first()");
                    GenerateUtilKt.moveCaretIntoGeneratedElement(this.$editor, (PsiElement)object);
                }
                return (List)insertedMembers;
            }
            {
                this.$members = collection;
                this.$classOrObject = ktClassOrObject;
                this.$anchor = psiElement2;
                this.$editor = editor;
                super(0);
            }
        });
        List $receiver = (List)t;
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)classOrObject.getProject());
        Iterable $receiver$iv2 = $receiver;
        for (Object element$iv : $receiver$iv2) {
            KtDeclaration it = (KtDeclaration)element$iv;
            codeStyleManager.reformat((PsiElement)it);
        }
        return (List)t;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List insertMembersAfter$default(Editor editor, KtClassOrObject ktClassOrObject, Collection collection, PsiElement psiElement2, int n, Object object) {
        if ((n & 8) != 0) {
            psiElement2 = null;
        }
        return GenerateUtilKt.insertMembersAfter(editor, ktClassOrObject, collection, psiElement2);
    }

    @NotNull
    public static final <T extends KtDeclaration> T insertMember(@Nullable Editor editor, @NotNull KtClassOrObject classOrObject, @NotNull T declaration2, @Nullable PsiElement anchor2) {
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        Intrinsics.checkParameterIsNotNull(declaration2, (String)"declaration");
        return (T)((KtDeclaration)CollectionsKt.single(GenerateUtilKt.insertMembersAfter(editor, classOrObject, CollectionsKt.listOf(declaration2), anchor2)));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KtDeclaration insertMember$default(Editor editor, KtClassOrObject ktClassOrObject, KtDeclaration ktDeclaration, PsiElement psiElement2, int n, Object object) {
        if ((n & 8) != 0) {
            psiElement2 = null;
        }
        return GenerateUtilKt.insertMember(editor, ktClassOrObject, ktDeclaration, psiElement2);
    }

    @Nullable
    public static final /* synthetic */ PsiElement access$findInsertAfterAnchor(@Nullable Editor editor, @NotNull KtClassBody body2) {
        return GenerateUtilKt.findInsertAfterAnchor(editor, body2);
    }
}

