/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.imports;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\r"}, d2={"importableFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getImportableFqName", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/name/FqName;", "canBeReferencedViaImport", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "getImportableTargets", "", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "ide-common"})
@JvmName(name="ImportsUtils")
public final class ImportsUtils {
    @Nullable
    public static final FqName getImportableFqName(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (!ImportsUtils.canBeReferencedViaImport($receiver)) {
            return null;
        }
        return DescriptorUtilsKt.getFqNameSafe(DescriptorUtilsKt.getImportableDescriptor($receiver));
    }

    public static final boolean canBeReferencedViaImport(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof PackageViewDescriptor || DescriptorUtils.isTopLevelDeclaration($receiver) || $receiver instanceof CallableDescriptor && DescriptorUtils.isStaticDeclaration((CallableDescriptor)$receiver)) {
            return !$receiver.getName().isSpecial();
        }
        DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassifierDescriptorWithTypeParameters)) {
            declarationDescriptor = null;
        }
        ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = (ClassifierDescriptorWithTypeParameters)declarationDescriptor;
        if (classifierDescriptorWithTypeParameters == null) {
            return false;
        }
        ClassifierDescriptorWithTypeParameters parentClassifier = classifierDescriptorWithTypeParameters;
        if (!ImportsUtils.canBeReferencedViaImport(parentClassifier)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor2 = $receiver;
        return declarationDescriptor2 instanceof ConstructorDescriptor ? !parentClassifier.isInner() : (declarationDescriptor2 instanceof ClassDescriptor || declarationDescriptor2 instanceof TypeAliasDescriptor ? true : parentClassifier instanceof ClassDescriptor && Intrinsics.areEqual((Object)((Object)((ClassDescriptor)parentClassifier).getKind()), (Object)((Object)ClassKind.OBJECT)));
    }

    public static final boolean canBeReferencedViaImport(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassifierDescriptor descriptor2 = $receiver.getConstructor().getDeclarationDescriptor();
        return descriptor2 != null && ImportsUtils.canBeReferencedViaImport(descriptor2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<DeclarationDescriptor> getImportableTargets(@NotNull KtReferenceExpression $receiver, @NotNull BindingContext bindingContext2) {
        void $receiver$iv$iv;
        ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters;
        Object it;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Object object = (ClassifierDescriptorWithTypeParameters)bindingContext2.get(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, $receiver);
        Collection targets = object != null && (object = CollectionsKt.listOf((Object)(it = (classifierDescriptorWithTypeParameters = object)))) != null ? (Collection)object : BindingContextUtilsKt.getReferenceTargets($receiver, bindingContext2);
        Iterable $receiver$iv = targets;
        it = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it2;
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            DeclarationDescriptor declarationDescriptor2 = DescriptorUtilsKt.getImportableDescriptor((DeclarationDescriptor)it2);
            collection.add(declarationDescriptor2);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }
}

