/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.pushDown;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.idea.ProgressUtilKt;
import org.jetbrains.kotlin.idea.codeInsight.shorten.DelayedRequestsWaitingSetKt;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KtPsiClassWrapper;
import org.jetbrains.kotlin.idea.refactoring.pullUp.MarkingUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.pullUp.PullUpConflictsUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.pullUp.PullUpUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.pushDown.KotlinPushDownContext;
import org.jetbrains.kotlin.idea.refactoring.pushDown.KotlinPushDownHandlerKt;
import org.jetbrains.kotlin.idea.refactoring.pushDown.KotlinPushDownProcessor;
import org.jetbrains.kotlin.idea.refactoring.pushDown.PushDownConflictsUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.pushDown.PushDownImplKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.search.declarationsSearch.ClassInheritorsSearchKt;
import org.jetbrains.kotlin.idea.search.declarationsSearch.HierarchySearchRequest;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.substitutions.SubstitutionUtilsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002%&B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ!\u0010\f\u001a\u00060\rR\u00020\u00002\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0014\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0014\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0014\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u001d\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0014\u00a2\u0006\u0002\u0010\u001cJ\u001c\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0 H\u0014J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\u001bH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "sourceClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "membersToMove", "", "Lorg/jetbrains/kotlin/idea/refactoring/memberInfo/KotlinMemberInfo;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtClass;Ljava/util/List;)V", "context", "Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownContext;", "createUsageViewDescriptor", "Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownProcessor$UsageViewDescriptorImpl;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownProcessor$UsageViewDescriptorImpl;", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "getAfterData", "Lcom/intellij/refactoring/listeners/RefactoringEventData;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/refactoring/listeners/RefactoringEventData;", "getBeforeData", "getCommandName", "", "performRefactoring", "", "([Lcom/intellij/usageView/UsageInfo;)V", "preprocessUsages", "", "refUsages", "Lcom/intellij/openapi/util/Ref;", "pushDownToClass", "targetClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "removeOriginalMembers", "SubclassUsage", "UsageViewDescriptorImpl", "idea"})
public final class KotlinPushDownProcessor
extends BaseRefactoringProcessor {
    private final KotlinPushDownContext context;

    @NotNull
    protected String getCommandName() {
        return KotlinPushDownHandlerKt.getPUSH_MEMBERS_DOWN();
    }

    @NotNull
    protected UsageViewDescriptorImpl createUsageViewDescriptor(@NotNull UsageInfo[] usages2) {
        Intrinsics.checkParameterIsNotNull((Object)usages2, (String)"usages");
        return new UsageViewDescriptorImpl();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected RefactoringEventData getBeforeData() {
        Collection<KtNamedDeclaration> collection;
        void $receiver$iv$iv;
        Collection $receiver$iv;
        RefactoringEventData refactoringEventData;
        RefactoringEventData $receiver = refactoringEventData = new RefactoringEventData();
        $receiver.addElement((PsiElement)this.context.getSourceClass());
        Iterable iterable = this.context.getMembersToMove();
        RefactoringEventData refactoringEventData2 = $receiver;
        void var5_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            KotlinMemberInfo kotlinMemberInfo = (KotlinMemberInfo)((Object)item$iv$iv);
            collection = destination$iv$iv;
            KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)it.getMember();
            collection.add(ktNamedDeclaration);
        }
        collection = (List)destination$iv$iv;
        Collection thisCollection$iv = $receiver$iv = (Collection)collection;
        KtNamedDeclaration[] ktNamedDeclarationArray = thisCollection$iv.toArray(new KtNamedDeclaration[thisCollection$iv.size()]);
        if (ktNamedDeclarationArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        collection = ktNamedDeclarationArray;
        refactoringEventData2.addElements((PsiElement[])collection);
        return refactoringEventData;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages2) {
        void $receiver$iv$iv;
        void $receiver$iv;
        RefactoringEventData refactoringEventData;
        Intrinsics.checkParameterIsNotNull((Object)usages2, (String)"usages");
        RefactoringEventData $receiver = refactoringEventData = new RefactoringEventData();
        Object[] objectArray = usages2;
        RefactoringEventData refactoringEventData2 = $receiver;
        void var6_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (int i = 0; i < ((void)$receiver$iv$iv$iv).length; ++i) {
            KtClassOrObject ktClassOrObject;
            void element$iv$iv$iv = $receiver$iv$iv$iv[i];
            void element$iv$iv = element$iv$iv$iv;
            UsageInfo it = (UsageInfo)element$iv$iv;
            PsiElement psiElement2 = it.getElement();
            if (!(psiElement2 instanceof KtClassOrObject)) {
                psiElement2 = null;
            }
            if ((KtClassOrObject)psiElement2 == null) continue;
            KtClassOrObject it$iv$iv = ktClassOrObject;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        refactoringEventData2.addElements((Collection)list2);
        return refactoringEventData;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected UsageInfo[] findUsages() {
        Iterable $receiver$iv$iv;
        PsiElement psiElement2 = this.context.getSourceClass();
        SearchScope searchScope2 = this.context.getSourceClass().getUseScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)searchScope2, (String)"context.sourceClass.useScope");
        Iterable $receiver$iv = (Iterable)ClassInheritorsSearchKt.searchInheritors(new HierarchySearchRequest<PsiElement>(psiElement2, searchScope2, false));
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            PsiElement psiElement3;
            Object element$iv$iv = element$iv$iv$iv;
            PsiClass it = (PsiClass)element$iv$iv;
            if (LightClassUtilsKt.getUnwrapped((PsiElement)it) == null) continue;
            PsiElement it$iv$iv = psiElement3;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            Object element$iv$iv$iv;
            element$iv$iv$iv = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            SubclassUsage subclassUsage = new SubclassUsage((PsiElement)p1);
            collection.add(subclassUsage);
        }
        $receiver$iv = (List)destination$iv$iv;
        Iterable thisCollection$iv = $receiver$iv;
        SubclassUsage[] subclassUsageArray = thisCollection$iv.toArray(new SubclassUsage[thisCollection$iv.size()]);
        if (subclassUsageArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return subclassUsageArray;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        String message2;
        int answer;
        Intrinsics.checkParameterIsNotNull(refUsages, (String)"refUsages");
        UsageInfo[] usageInfoArray = (UsageInfo[])refUsages.get();
        if (usageInfoArray == null) {
            usageInfoArray = UsageInfo.EMPTY_ARRAY;
        }
        UsageInfo[] usages2 = usageInfoArray;
        Object[] objectArray = usages2;
        if (objectArray.length == 0 && (answer = Messages.showYesNoDialog((String)StringsKt.capitalize((String)(message2 = PullUpConflictsUtilsKt.renderForConflicts(this.context.getSourceClassDescriptor()) + " doesn't have inheritors" + "\n" + "Pushing members down will result in them being deleted. Would you like to proceed?")), (String)KotlinPushDownHandlerKt.getPUSH_MEMBERS_DOWN(), (Icon)Messages.getWarningIcon())) == 1) {
            return false;
        }
        String string = RefactoringBundle.message((String)"detecting.possible.conflicts");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"RefactoringBundle.messag\u2026ting.possible.conflicts\")");
        MultiMap multiMap = (MultiMap)ProgressUtilKt.runSynchronouslyWithProgress(this.myProject, string, true, (Function0)new Function0<MultiMap<PsiElement, String>>(this, usages2){
            final /* synthetic */ KotlinPushDownProcessor this$0;
            final /* synthetic */ UsageInfo[] $usages;

            @NotNull
            public final MultiMap<PsiElement, String> invoke() {
                return (MultiMap)ApplicationUtilsKt.runReadAction((Function0)new Function0<MultiMap<PsiElement, String>>(this){
                    final /* synthetic */ preprocessUsages.conflicts.1 this$0;

                    @NotNull
                    public final MultiMap<PsiElement, String> invoke() {
                        KotlinPushDownContext kotlinPushDownContext = KotlinPushDownProcessor.access$getContext$p(this.this$0.this$0);
                        Intrinsics.checkExpressionValueIsNotNull((Object)this.this$0.$usages, (String)"usages");
                        return PushDownConflictsUtilsKt.analyzePushDownConflicts(kotlinPushDownContext, this.this$0.$usages);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = kotlinPushDownProcessor;
                this.$usages = usageInfoArray;
                super(0);
            }
        });
        if (multiMap == null) {
            return false;
        }
        MultiMap conflicts2 = multiMap;
        return this.showConflicts(conflicts2, usages2);
    }

    private final void pushDownToClass(KtClassOrObject targetClass) {
        DeclarationDescriptor declarationDescriptor = ResolutionFacade.DefaultImpls.resolveToDescriptor$default(this.context.getResolutionFacade(), targetClass, null, 2, null);
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        ClassDescriptor targetClassDescriptor = (ClassDescriptor)declarationDescriptor;
        SimpleType simpleType2 = this.context.getSourceClassDescriptor().getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"context.sourceClassDescriptor.defaultType");
        KotlinType kotlinType = simpleType2;
        SimpleType simpleType3 = targetClassDescriptor.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"targetClassDescriptor.defaultType");
        TypeSubstitutor typeSubstitutor2 = SubstitutionUtilsKt.getTypeSubstitutor(kotlinType, simpleType3);
        if (typeSubstitutor2 == null) {
            typeSubstitutor2 = TypeSubstitutor.EMPTY;
        }
        TypeSubstitutor substitutor3 = typeSubstitutor2;
        for (KotlinMemberInfo memberInfo : this.context.getMembersToMove()) {
            KtNamedDeclaration ktNamedDeclaration;
            DeclarationDescriptor memberDescriptor;
            KtNamedDeclaration member = (KtNamedDeclaration)memberInfo.getMember();
            if (this.context.getMemberDescriptors().get(member) == null) {
                continue;
            }
            KtNamedDeclaration ktNamedDeclaration2 = member;
            if (ktNamedDeclaration2 instanceof KtProperty || ktNamedDeclaration2 instanceof KtNamedFunction) {
                DeclarationDescriptor declarationDescriptor2 = memberDescriptor;
                if (declarationDescriptor2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
                }
                CallableMemberDescriptor cfr_ignored_0 = (CallableMemberDescriptor)declarationDescriptor2;
                KtNamedDeclaration ktNamedDeclaration3 = member;
                if (ktNamedDeclaration3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableDeclaration");
                }
                KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)ktNamedDeclaration3;
                CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)memberDescriptor;
                TypeSubstitutor typeSubstitutor3 = substitutor3;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeSubstitutor3, (String)"substitutor");
                ktNamedDeclaration = PushDownImplKt.moveCallableMemberToClass(ktCallableDeclaration, callableMemberDescriptor, targetClass, targetClassDescriptor, typeSubstitutor3, memberInfo.isToAbstract());
            } else {
                if (!(ktNamedDeclaration2 instanceof KtClassOrObject) && !(ktNamedDeclaration2 instanceof KtPsiClassWrapper)) continue;
                if (memberInfo.getOverrides() != null) {
                    DeclarationDescriptor declarationDescriptor3 = memberDescriptor;
                    if (declarationDescriptor3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                    }
                    if (PullUpUtilsKt.getSuperTypeEntryByDescriptor(this.context.getSourceClass(), (ClassDescriptor)declarationDescriptor3, this.context.getSourceClassContext()) != null) {
                        KtSuperTypeListEntry ktSuperTypeListEntry;
                        KtSuperTypeListEntry it = ktSuperTypeListEntry;
                        BindingContext bindingContext2 = this.context.getSourceClassContext();
                        TypeSubstitutor typeSubstitutor4 = substitutor3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)typeSubstitutor4, (String)"substitutor");
                        PullUpUtilsKt.addSuperTypeEntry(it, targetClass, targetClassDescriptor, bindingContext2, typeSubstitutor4);
                    }
                    continue;
                }
                ktNamedDeclaration = PullUpUtilsKt.addMemberToTarget(member, targetClass);
            }
            KtNamedDeclaration movedMember = ktNamedDeclaration;
            TypeSubstitutor typeSubstitutor5 = substitutor3;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeSubstitutor5, (String)"substitutor");
            MarkingUtilsKt.applyMarking(movedMember, typeSubstitutor5, targetClassDescriptor);
        }
    }

    private final void removeOriginalMembers() {
        for (KotlinMemberInfo memberInfo : this.context.getMembersToMove()) {
            DeclarationDescriptor memberDescriptor;
            KtNamedDeclaration member = (KtNamedDeclaration)memberInfo.getMember();
            if (this.context.getMemberDescriptors().get(member) == null) {
                continue;
            }
            KtNamedDeclaration ktNamedDeclaration = member;
            if (ktNamedDeclaration instanceof KtProperty || ktNamedDeclaration instanceof KtNamedFunction) {
                KtNamedDeclaration ktNamedDeclaration2 = member;
                if (ktNamedDeclaration2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableDeclaration");
                }
                KtCallableDeclaration cfr_ignored_0 = (KtCallableDeclaration)ktNamedDeclaration2;
                DeclarationDescriptor declarationDescriptor = memberDescriptor;
                if (declarationDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
                }
                CallableMemberDescriptor cfr_ignored_1 = (CallableMemberDescriptor)declarationDescriptor;
                if (Intrinsics.areEqual((Object)((Object)((CallableMemberDescriptor)memberDescriptor).getModality()), (Object)((Object)Modality.ABSTRACT)) ^ true && memberInfo.isToAbstract()) {
                    if (member.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
                        member.addModifier(KtTokens.PROTECTED_KEYWORD);
                    }
                    KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)member;
                    CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)memberDescriptor;
                    TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.EMPTY;
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeSubstitutor2, (String)"TypeSubstitutor.EMPTY");
                    PullUpUtilsKt.makeAbstract(ktCallableDeclaration, callableMemberDescriptor, typeSubstitutor2, this.context.getSourceClass());
                    KtTypeReference ktTypeReference = ((KtCallableDeclaration)member).getTypeReference();
                    if (ktTypeReference != null) {
                        DelayedRequestsWaitingSetKt.addToShorteningWaitSet$default(ktTypeReference, null, 1, null);
                    }
                    continue;
                }
                member.delete();
                continue;
            }
            if (!(ktNamedDeclaration instanceof KtClassOrObject) && !(ktNamedDeclaration instanceof KtPsiClassWrapper)) continue;
            if (memberInfo.getOverrides() != null) {
                DeclarationDescriptor declarationDescriptor = memberDescriptor;
                if (declarationDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                }
                if (PullUpUtilsKt.getSuperTypeEntryByDescriptor(this.context.getSourceClass(), (ClassDescriptor)declarationDescriptor, this.context.getSourceClassContext()) != null) {
                    KtSuperTypeListEntry ktSuperTypeListEntry;
                    KtSuperTypeListEntry it = ktSuperTypeListEntry;
                    this.context.getSourceClass().removeSuperTypeListEntry(it);
                }
                continue;
            }
            member.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRefactoring(@NotNull UsageInfo[] usages2) {
        Intrinsics.checkParameterIsNotNull((Object)usages2, (String)"usages");
        ArrayList markedElements = new ArrayList();
        try {
            Collection collection;
            KotlinMemberInfo it;
            Object[] $receiver$iv = (Object[])this.context.getMembersToMove();
            for (Object t : $receiver$iv) {
                it = (KotlinMemberInfo)((Object)t);
                collection = markedElements;
                KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)it.getMember();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktNamedDeclaration, (String)"it.member");
                Iterable iterable = MarkingUtilsKt.markElements(ktNamedDeclaration, this.context.getSourceClassContext(), this.context.getSourceClassDescriptor(), null);
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            }
            $receiver$iv = usages2;
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object object = $receiver$iv[i];
                it = (UsageInfo)object;
                PsiElement psiElement2 = it.getElement();
                if (!(psiElement2 instanceof KtClassOrObject)) {
                    psiElement2 = null;
                }
                if ((KtClassOrObject)psiElement2 == null) continue;
                Collection it2 = collection;
                this.pushDownToClass((KtClassOrObject)((Object)it2));
            }
            this.removeOriginalMembers();
        }
        finally {
            MarkingUtilsKt.clearMarking(markedElements);
        }
    }

    public KotlinPushDownProcessor(@NotNull Project project, @NotNull KtClass sourceClass, @NotNull List<KotlinMemberInfo> membersToMove) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)sourceClass, (String)"sourceClass");
        Intrinsics.checkParameterIsNotNull(membersToMove, (String)"membersToMove");
        super(project);
        this.context = new KotlinPushDownContext(sourceClass, membersToMove);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0013\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownProcessor$UsageViewDescriptorImpl;", "Lcom/intellij/usageView/UsageViewDescriptor;", "(Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownProcessor;)V", "getCodeReferencesText", "", "kotlin.jvm.PlatformType", "usagesCount", "", "filesCount", "getCommentReferencesText", "", "getElements", "", "Lorg/jetbrains/kotlin/psi/KtClass;", "()[Lorg/jetbrains/kotlin/psi/KtClass;", "getProcessedElementsHeader", "idea"})
    public final class UsageViewDescriptorImpl
    implements UsageViewDescriptor {
        public String getProcessedElementsHeader() {
            return RefactoringBundle.message((String)"push.down.members.elements.header");
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public KtClass[] getElements() {
            void var1_1;
            KtClass[] elements$iv = new KtClass[]{KotlinPushDownProcessor.this.context.getSourceClass()};
            return var1_1;
        }

        public String getCodeReferencesText(int usagesCount, int filesCount) {
            return RefactoringBundle.message((String)"classes.to.push.down.members.to", (Object[])new Object[]{UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount)});
        }

        @Nullable
        public Void getCommentReferencesText(int usagesCount, int filesCount) {
            return null;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownProcessor$SubclassUsage;", "Lcom/intellij/usageView/UsageInfo;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)V", "idea"})
    public static final class SubclassUsage
    extends UsageInfo {
        public SubclassUsage(@NotNull PsiElement element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            super(element2);
        }
    }
}

