/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsObjectScope;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.util.Maps;

public abstract class JsScope {
    @NotNull
    private final String description;
    private Map<String, JsName> names;
    private Map<JsName, Object> temporaryNames;
    private Set<JsName> readonlyTemporaryNames;
    private final JsScope parent;
    private static final Pattern FRESH_NAME_SUFFIX = Pattern.compile("[\\$_]\\d+$");

    public JsScope(JsScope parent2, @NotNull String description) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "org/jetbrains/kotlin/js/backend/ast/JsScope", "<init>"));
        }
        this.names = Collections.emptyMap();
        this.readonlyTemporaryNames = null;
        this.description = description;
        this.parent = parent2;
    }

    protected JsScope(@NotNull String description) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "org/jetbrains/kotlin/js/backend/ast/JsScope", "<init>"));
        }
        this.names = Collections.emptyMap();
        this.readonlyTemporaryNames = null;
        this.description = description;
        this.parent = null;
    }

    public Set<JsName> getTemporaryNames() {
        if (this.temporaryNames == null) {
            return Collections.emptySet();
        }
        if (this.readonlyTemporaryNames == null) {
            this.readonlyTemporaryNames = Collections.unmodifiableSet(this.temporaryNames.keySet());
        }
        return this.readonlyTemporaryNames;
    }

    @NotNull
    public JsScope innerObjectScope(@NotNull String scopeName) {
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "org/jetbrains/kotlin/js/backend/ast/JsScope", "innerObjectScope"));
        }
        JsObjectScope jsObjectScope = new JsObjectScope(this, scopeName);
        if (jsObjectScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsScope", "innerObjectScope"));
        }
        return jsObjectScope;
    }

    @NotNull
    public JsName declareName(@NotNull String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "org/jetbrains/kotlin/js/backend/ast/JsScope", "declareName"));
        }
        JsName name2 = this.findOwnName(identifier);
        JsName jsName = name2 != null ? name2 : this.doCreateName(identifier);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsScope", "declareName"));
        }
        return jsName;
    }

    @NotNull
    public JsName declareFreshName(@NotNull String suggestedName) {
        if (suggestedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedName", "org/jetbrains/kotlin/js/backend/ast/JsScope", "declareFreshName"));
        }
        assert (!suggestedName.isEmpty());
        String ident = this.getFreshIdent(suggestedName);
        JsName jsName = this.doCreateName(ident);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsScope", "declareFreshName"));
        }
        return jsName;
    }

    @NotNull
    public JsName declareTemporaryName(@NotNull String suggestedName) {
        if (suggestedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedName", "org/jetbrains/kotlin/js/backend/ast/JsScope", "declareTemporaryName"));
        }
        assert (!suggestedName.isEmpty());
        JsName name2 = new JsName(this, suggestedName, true);
        if (this.temporaryNames == null) {
            this.temporaryNames = new WeakHashMap<JsName, Object>();
        }
        this.temporaryNames.put(name2, this);
        JsName jsName = name2;
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsScope", "declareTemporaryName"));
        }
        return jsName;
    }

    @NotNull
    public JsName declareTemporary() {
        JsName jsName = this.declareTemporaryName("tmp$");
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsScope", "declareTemporary"));
        }
        return jsName;
    }

    @Nullable
    public final JsName findName(@NotNull String ident) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "org/jetbrains/kotlin/js/backend/ast/JsScope", "findName"));
        }
        JsName name2 = this.findOwnName(ident);
        if (name2 == null && this.parent != null) {
            return this.parent.findName(ident);
        }
        return name2;
    }

    public boolean hasOwnName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/backend/ast/JsScope", "hasOwnName"));
        }
        return this.names.containsKey(name2);
    }

    private boolean hasName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/backend/ast/JsScope", "hasName"));
        }
        return this.hasOwnName(name2) || this.parent != null && this.parent.hasName(name2);
    }

    public final JsScope getParent() {
        return this.parent;
    }

    public JsProgram getProgram() {
        assert (this.parent != null) : "Subclasses must override getProgram() if they do not set a parent";
        return this.parent.getProgram();
    }

    public final String toString() {
        if (this.parent != null) {
            return this.description + "->" + this.parent;
        }
        return this.description;
    }

    public void copyOwnNames(JsScope other) {
        this.names = new HashMap<String, JsName>(this.names);
        this.names.putAll(other.names);
    }

    @NotNull
    public String getDescription() {
        String string = this.description;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsScope", "getDescription"));
        }
        return string;
    }

    @NotNull
    protected JsName doCreateName(@NotNull String ident) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "org/jetbrains/kotlin/js/backend/ast/JsScope", "doCreateName"));
        }
        JsName name2 = new JsName(this, ident, false);
        this.names = Maps.put(this.names, ident, name2);
        JsName jsName = name2;
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsScope", "doCreateName"));
        }
        return jsName;
    }

    protected JsName findOwnName(@NotNull String ident) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "org/jetbrains/kotlin/js/backend/ast/JsScope", "findOwnName"));
        }
        return this.names.get(ident);
    }

    @NotNull
    protected String getFreshIdent(@NotNull String suggestedIdent) {
        if (suggestedIdent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedIdent", "org/jetbrains/kotlin/js/backend/ast/JsScope", "getFreshIdent"));
        }
        char sep = '_';
        String baseName = suggestedIdent;
        int counter = 0;
        Matcher matcher2 = FRESH_NAME_SUFFIX.matcher(suggestedIdent);
        if (matcher2.find()) {
            String group = matcher2.group();
            baseName = matcher2.replaceAll("");
            sep = group.charAt(0);
            counter = Integer.valueOf(group.substring(1));
        }
        String freshName = suggestedIdent;
        while (this.hasName(freshName)) {
            freshName = baseName + sep + counter++;
        }
        String string = freshName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsScope", "getFreshIdent"));
        }
        return string;
    }
}

