/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.descriptors;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassConstructorDescriptorImpl;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.UtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.KotlinType;

public class JavaClassConstructorDescriptor
extends ClassConstructorDescriptorImpl
implements JavaCallableMemberDescriptor {
    private Boolean hasStableParameterNames;
    private Boolean hasSynthesizedParameterNames;

    protected JavaClassConstructorDescriptor(@NotNull ClassDescriptor containingDeclaration, @Nullable JavaClassConstructorDescriptor original, @NotNull Annotations annotations2, boolean isPrimary, @NotNull CallableMemberDescriptor.Kind kind2, @NotNull SourceElement source) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/load/java/descriptors/JavaClassConstructorDescriptor", "<init>"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/load/java/descriptors/JavaClassConstructorDescriptor", "<init>"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/load/java/descriptors/JavaClassConstructorDescriptor", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/load/java/descriptors/JavaClassConstructorDescriptor", "<init>"));
        }
        super(containingDeclaration, original, annotations2, isPrimary, kind2, source);
        this.hasStableParameterNames = null;
        this.hasSynthesizedParameterNames = null;
    }

    @NotNull
    public static JavaClassConstructorDescriptor createJavaConstructor(@NotNull ClassDescriptor containingDeclaration, @NotNull Annotations annotations2, boolean isPrimary, @NotNull SourceElement source) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/load/java/descriptors/JavaClassConstructorDescriptor", "createJavaConstructor"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/load/java/descriptors/JavaClassConstructorDescriptor", "createJavaConstructor"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/load/java/descriptors/JavaClassConstructorDescriptor", "createJavaConstructor"));
        }
        JavaClassConstructorDescriptor javaClassConstructorDescriptor = new JavaClassConstructorDescriptor(containingDeclaration, null, annotations2, isPrimary, CallableMemberDescriptor.Kind.DECLARATION, source);
        if (javaClassConstructorDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/descriptors/JavaClassConstructorDescriptor", "createJavaConstructor"));
        }
        return javaClassConstructorDescriptor;
    }

    @Override
    public boolean hasStableParameterNames() {
        assert (this.hasStableParameterNames != null) : "hasStableParameterNames was not set: " + this;
        return this.hasStableParameterNames;
    }

    @Override
    public void setHasStableParameterNames(boolean hasStableParameterNames) {
        this.hasStableParameterNames = hasStableParameterNames;
    }

    @Override
    public boolean hasSynthesizedParameterNames() {
        assert (this.hasSynthesizedParameterNames != null) : "hasSynthesizedParameterNames was not set: " + this;
        return this.hasSynthesizedParameterNames;
    }

    @Override
    public void setHasSynthesizedParameterNames(boolean hasSynthesizedParameterNames) {
        this.hasSynthesizedParameterNames = hasSynthesizedParameterNames;
    }

    @Override
    @NotNull
    protected JavaClassConstructorDescriptor createSubstitutedCopy(@NotNull DeclarationDescriptor newOwner, @Nullable FunctionDescriptor original, @NotNull CallableMemberDescriptor.Kind kind2, @Nullable Name newName2, @NotNull Annotations annotations2, @NotNull SourceElement source) {
        if (newOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newOwner", "org/jetbrains/kotlin/load/java/descriptors/JavaClassConstructorDescriptor", "createSubstitutedCopy"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/load/java/descriptors/JavaClassConstructorDescriptor", "createSubstitutedCopy"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/load/java/descriptors/JavaClassConstructorDescriptor", "createSubstitutedCopy"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/load/java/descriptors/JavaClassConstructorDescriptor", "createSubstitutedCopy"));
        }
        if (kind2 != CallableMemberDescriptor.Kind.DECLARATION && kind2 != CallableMemberDescriptor.Kind.SYNTHESIZED) {
            throw new IllegalStateException("Attempt at creating a constructor that is not a declaration: \ncopy from: " + this + "\nnewOwner: " + newOwner + "\nkind: " + (Object)((Object)kind2));
        }
        assert (newName2 == null) : "Attempt to rename constructor: " + this;
        JavaClassConstructorDescriptor result2 = this.createDescriptor((ClassDescriptor)newOwner, (JavaClassConstructorDescriptor)original, kind2, source, annotations2);
        result2.setHasStableParameterNames(this.hasStableParameterNames());
        result2.setHasSynthesizedParameterNames(this.hasSynthesizedParameterNames());
        JavaClassConstructorDescriptor javaClassConstructorDescriptor = result2;
        if (javaClassConstructorDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/descriptors/JavaClassConstructorDescriptor", "createSubstitutedCopy"));
        }
        return javaClassConstructorDescriptor;
    }

    @NotNull
    protected JavaClassConstructorDescriptor createDescriptor(@NotNull ClassDescriptor newOwner, @Nullable JavaClassConstructorDescriptor original, @NotNull CallableMemberDescriptor.Kind kind2, @NotNull SourceElement sourceElement, @NotNull Annotations annotations2) {
        if (newOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newOwner", "org/jetbrains/kotlin/load/java/descriptors/JavaClassConstructorDescriptor", "createDescriptor"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/load/java/descriptors/JavaClassConstructorDescriptor", "createDescriptor"));
        }
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "org/jetbrains/kotlin/load/java/descriptors/JavaClassConstructorDescriptor", "createDescriptor"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/load/java/descriptors/JavaClassConstructorDescriptor", "createDescriptor"));
        }
        JavaClassConstructorDescriptor javaClassConstructorDescriptor = new JavaClassConstructorDescriptor(newOwner, original, annotations2, this.isPrimary, kind2, sourceElement);
        if (javaClassConstructorDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/descriptors/JavaClassConstructorDescriptor", "createDescriptor"));
        }
        return javaClassConstructorDescriptor;
    }

    @Override
    @NotNull
    public JavaClassConstructorDescriptor enhance(@Nullable KotlinType enhancedReceiverType, @NotNull List<KotlinType> enhancedValueParametersTypes, @NotNull KotlinType enhancedReturnType) {
        if (enhancedValueParametersTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enhancedValueParametersTypes", "org/jetbrains/kotlin/load/java/descriptors/JavaClassConstructorDescriptor", "enhance"));
        }
        if (enhancedReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enhancedReturnType", "org/jetbrains/kotlin/load/java/descriptors/JavaClassConstructorDescriptor", "enhance"));
        }
        JavaClassConstructorDescriptor enhanced = this.createSubstitutedCopy(this.getContainingDeclaration(), null, this.getKind(), null, this.getAnnotations(), this.getSource());
        enhanced.initialize(enhancedReceiverType, this.getDispatchReceiverParameter(), this.getTypeParameters(), UtilKt.copyValueParameters(enhancedValueParametersTypes, this.getValueParameters(), enhanced), enhancedReturnType, this.getModality(), this.getVisibility());
        JavaClassConstructorDescriptor javaClassConstructorDescriptor = enhanced;
        if (javaClassConstructorDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/descriptors/JavaClassConstructorDescriptor", "enhance"));
        }
        return javaClassConstructorDescriptor;
    }
}

