/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclarationStub;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeConstraintList;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinParameterStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersKt;

public class KtParameter
extends KtNamedDeclarationStub<KotlinParameterStub>
implements KtCallableDeclaration,
KtValVarKeywordOwner {
    private static final TokenSet VAL_VAR_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD});

    public KtParameter(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtParameter", "<init>"));
        }
        super(node);
    }

    public KtParameter(@NotNull KotlinParameterStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/KtParameter", "<init>"));
        }
        super(stub, KtStubElementTypes.VALUE_PARAMETER);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtParameter", "accept"));
        }
        return visitor2.visitParameter(this, data);
    }

    @Override
    @Nullable
    public KtTypeReference getTypeReference() {
        return (KtTypeReference)this.getStubOrPsiChild(KtStubElementTypes.TYPE_REFERENCE);
    }

    @Override
    @Nullable
    public KtTypeReference setTypeReference(@Nullable KtTypeReference typeRef) {
        return TypeRefHelpersKt.setTypeReference(this, this.getNameIdentifier(), typeRef);
    }

    @Override
    @Nullable
    public PsiElement getColon() {
        return this.findChildByType(KtTokens.COLON);
    }

    @Nullable
    public PsiElement getEqualsToken() {
        return this.findChildByType(KtTokens.EQ);
    }

    public boolean hasDefaultValue() {
        KotlinParameterStub stub = (KotlinParameterStub)this.getStub();
        if (stub != null) {
            return stub.hasDefaultValue();
        }
        return this.getDefaultValue() != null;
    }

    @Nullable
    public KtExpression getDefaultValue() {
        KotlinParameterStub stub = (KotlinParameterStub)this.getStub();
        if (stub != null && !stub.hasDefaultValue()) {
            return null;
        }
        PsiElement equalsToken = this.getEqualsToken();
        return equalsToken != null ? (KtExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)equalsToken, KtExpression.class) : null;
    }

    public boolean isMutable() {
        KotlinParameterStub stub = (KotlinParameterStub)this.getStub();
        if (stub != null) {
            return stub.isMutable();
        }
        return this.findChildByType(KtTokens.VAR_KEYWORD) != null;
    }

    public boolean isVarArg() {
        KtModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifier(KtTokens.VARARG_KEYWORD);
    }

    public boolean hasValOrVar() {
        KotlinParameterStub stub = (KotlinParameterStub)this.getStub();
        if (stub != null) {
            return stub.hasValOrVar();
        }
        return this.getValOrVarKeyword() != null;
    }

    @Override
    @Nullable
    public PsiElement getValOrVarKeyword() {
        KotlinParameterStub stub = (KotlinParameterStub)this.getStub();
        if (stub != null && !stub.hasValOrVar()) {
            return null;
        }
        return this.findChildByType(VAL_VAR_TOKEN_SET);
    }

    @Nullable
    public KtDestructuringDeclaration getDestructuringDeclaration() {
        if (this.getStub() != null) {
            return null;
        }
        return (KtDestructuringDeclaration)this.findChildByType(KtNodeTypes.DESTRUCTURING_DECLARATION);
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public boolean isLoopParameter() {
        return this.getParent() instanceof KtForExpression;
    }

    @Override
    @Nullable
    public KtParameterList getValueParameterList() {
        return null;
    }

    @Override
    @NotNull
    public List<KtParameter> getValueParameters() {
        List<KtParameter> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtParameter", "getValueParameters"));
        }
        return list2;
    }

    @Override
    @Nullable
    public KtTypeReference getReceiverTypeReference() {
        return null;
    }

    @Override
    @Nullable
    public KtTypeParameterList getTypeParameterList() {
        return null;
    }

    @Override
    @Nullable
    public KtTypeConstraintList getTypeConstraintList() {
        return null;
    }

    @Override
    @NotNull
    public List<KtTypeConstraint> getTypeConstraints() {
        List<KtTypeConstraint> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtParameter", "getTypeConstraints"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<KtTypeParameter> getTypeParameters() {
        List<KtTypeParameter> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtParameter", "getTypeParameters"));
        }
        return list2;
    }

    @Nullable
    public KtFunction getOwnerFunction() {
        PsiElement parent2 = this.getParentByStub();
        if (!(parent2 instanceof KtParameterList)) {
            return null;
        }
        return ((KtParameterList)parent2).getOwnerFunction();
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        KtExpression owner = this.getOwnerFunction();
        if (owner instanceof KtPrimaryConstructor) {
            if (this.hasValOrVar()) {
                SearchScope searchScope2 = super.getUseScope();
                if (searchScope2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtParameter", "getUseScope"));
                }
                return searchScope2;
            }
            owner = ((KtPrimaryConstructor)owner).getContainingClassOrObject();
        }
        if (owner == null) {
            owner = (KtExpression)PsiTreeUtil.getParentOfType((PsiElement)this, KtExpression.class);
        }
        LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)(owner != null ? owner : this));
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtParameter", "getUseScope"));
        }
        return localSearchScope;
    }
}

