/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore$WhenMappings;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001IB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u001e\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0017\u0012\u0004\u0012\u00020\u00180\u000bH\u0002J(\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(J6\u0010)\u001a\u00020 2\u0006\u0010#\u001a\u00020$2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020+00H\u0002J.\u00101\u001a\u0002022\u0006\u0010#\u001a\u00020$2\u0006\u00103\u001a\u00020+2\u0006\u0010'\u001a\u00020(2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\b05H\u0002J8\u00106\u001a\u00020 2\u0006\u00107\u001a\u0002082\u0006\u0010#\u001a\u00020$2\b\u00109\u001a\u0004\u0018\u00010&2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\b052\u0006\u0010'\u001a\u00020(H\u0002J\"\u0010:\u001a\u0002022\u0006\u0010#\u001a\u00020$2\u0006\u00103\u001a\u00020+2\b\u00109\u001a\u0004\u0018\u00010&H\u0002J&\u0010;\u001a\u0002022\u0006\u0010#\u001a\u00020$2\u0006\u00103\u001a\u00020+2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\b05H\u0002J\u0018\u0010<\u001a\u00020\u00182\u0006\u0010=\u001a\u00020\f2\u0006\u0010>\u001a\u00020\fH\u0002J9\u0010?\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0017\u0012\u0004\u0012\u00020\u00180\u000b2\u0012\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0@\"\u00020\fH\u0002\u00a2\u0006\u0002\u0010AJA\u0010B\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0017\u0012\u0004\u0012\u00020\u00180\u000b2\u0006\u0010<\u001a\u00020\u00182\u0012\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0@\"\u00020\fH\u0002\u00a2\u0006\u0002\u0010CJ9\u0010D\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0017\u0012\u0004\u0012\u00020\u00180\u000b2\u0012\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0@\"\u00020\fH\u0002\u00a2\u0006\u0002\u0010AJ9\u0010E\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0017\u0012\u0004\u0012\u00020\u00180\u000b2\u0012\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0@\"\u00020\fH\u0002\u00a2\u0006\u0002\u0010AJ0\u0010F\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0017\u0012\u0004\u0012\u00020\u00180\u000b2\u0006\u0010G\u001a\u00020\f2\u0006\u0010H\u001a\u00020\fH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0006\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u0011\u001a\u0016\u0012\f\u0012\n \t*\u0004\u0018\u00010\f0\f\u0012\u0004\u0012\u00020\u00120\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR#\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR&\u0010\u0016\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0017\u0012\u0004\u0012\u00020\u00180\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000fR#\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000fR \u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlin/resolve/ModifierCheckerCore;", "", "()V", "MODIFIER_KEYWORD_SET", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "defaultVisibilityTargets", "Ljava/util/EnumSet;", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "kotlin.jvm.PlatformType", "deprecatedParentTargetMap", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "", "getDeprecatedParentTargetMap", "()Ljava/util/Map;", "deprecatedTargetMap", "featureDependencies", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "getFeatureDependencies", "featureDependenciesTargets", "getFeatureDependenciesTargets", "mutualCompatibility", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/resolve/ModifierCheckerCore$Compatibility;", "possibleParentTargetMap", "getPossibleParentTargetMap", "possibleTargetMap", "getPossibleTargetMap", "redundantTargetMap", "buildCompatibilityMap", "check", "", "listOwner", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkCompatibility", "firstNode", "Lcom/intellij/lang/ASTNode;", "secondNode", "owner", "Lcom/intellij/psi/PsiElement;", "incorrectNodes", "", "checkLanguageLevelSupport", "", "node", "actualTargets", "", "checkModifierList", "list", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "parentDescriptor", "checkParent", "checkTarget", "compatibility", "first", "second", "compatibilityForClassesRegister", "", "([Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Ljava/util/Map;", "compatibilityRegister", "(Lorg/jetbrains/kotlin/resolve/ModifierCheckerCore$Compatibility;[Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Ljava/util/Map;", "deprecationRegister", "incompatibilityRegister", "redundantRegister", "sufficient", "redundant", "Compatibility", "frontend"})
public final class ModifierCheckerCore {
    private static final EnumSet<KotlinTarget> defaultVisibilityTargets;
    @NotNull
    private static final Map<KtModifierKeywordToken, Set<KotlinTarget>> possibleTargetMap;
    @NotNull
    private static final Map<KtModifierKeywordToken, LanguageFeature> featureDependencies;
    @NotNull
    private static final Map<LanguageFeature, Set<KotlinTarget>> featureDependenciesTargets;
    private static final Map<KtModifierKeywordToken, Set<KotlinTarget>> deprecatedTargetMap;
    private static final Map<KtModifierKeywordToken, Set<KotlinTarget>> redundantTargetMap;
    @NotNull
    private static final Map<KtModifierKeywordToken, Set<KotlinTarget>> possibleParentTargetMap;
    @NotNull
    private static final Map<KtModifierKeywordToken, Set<KotlinTarget>> deprecatedParentTargetMap;
    private static final Map<Pair<KtModifierKeywordToken, KtModifierKeywordToken>, Compatibility> mutualCompatibility;
    private static final TokenSet MODIFIER_KEYWORD_SET;
    public static final ModifierCheckerCore INSTANCE;

    @NotNull
    public final Map<KtModifierKeywordToken, Set<KotlinTarget>> getPossibleTargetMap() {
        return possibleTargetMap;
    }

    @NotNull
    public final Map<KtModifierKeywordToken, LanguageFeature> getFeatureDependencies() {
        return featureDependencies;
    }

    @NotNull
    public final Map<LanguageFeature, Set<KotlinTarget>> getFeatureDependenciesTargets() {
        return featureDependenciesTargets;
    }

    @NotNull
    public final Map<KtModifierKeywordToken, Set<KotlinTarget>> getPossibleParentTargetMap() {
        return possibleParentTargetMap;
    }

    @NotNull
    public final Map<KtModifierKeywordToken, Set<KotlinTarget>> getDeprecatedParentTargetMap() {
        return deprecatedParentTargetMap;
    }

    private final Map<Pair<KtModifierKeywordToken, KtModifierKeywordToken>, Compatibility> buildCompatibilityMap() {
        HashMap result2 = new HashMap();
        Map map2 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.IN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"IN_KEYWORD");
        ktModifierKeywordTokenArray[0] = ktModifierKeywordToken;
        KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.OUT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken2), (String)"OUT_KEYWORD");
        ktModifierKeywordTokenArray[1] = ktModifierKeywordToken2;
        Map<Pair<KtModifierKeywordToken, KtModifierKeywordToken>, Compatibility> map3 = this.incompatibilityRegister(ktModifierKeywordTokenArray);
        map2.putAll(map3);
        map2 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray2 = new KtModifierKeywordToken[4];
        KtModifierKeywordToken ktModifierKeywordToken3 = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken3), (String)"PRIVATE_KEYWORD");
        ktModifierKeywordTokenArray2[0] = ktModifierKeywordToken3;
        KtModifierKeywordToken ktModifierKeywordToken4 = KtTokens.PROTECTED_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken4), (String)"PROTECTED_KEYWORD");
        ktModifierKeywordTokenArray2[1] = ktModifierKeywordToken4;
        KtModifierKeywordToken ktModifierKeywordToken5 = KtTokens.PUBLIC_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken5), (String)"PUBLIC_KEYWORD");
        ktModifierKeywordTokenArray2[2] = ktModifierKeywordToken5;
        KtModifierKeywordToken ktModifierKeywordToken6 = KtTokens.INTERNAL_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken6), (String)"INTERNAL_KEYWORD");
        ktModifierKeywordTokenArray2[3] = ktModifierKeywordToken6;
        map3 = this.incompatibilityRegister(ktModifierKeywordTokenArray2);
        map2.putAll(map3);
        map2 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray3 = new KtModifierKeywordToken[4];
        KtModifierKeywordToken ktModifierKeywordToken7 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken7), (String)"ABSTRACT_KEYWORD");
        ktModifierKeywordTokenArray3[0] = ktModifierKeywordToken7;
        KtModifierKeywordToken ktModifierKeywordToken8 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken8), (String)"OPEN_KEYWORD");
        ktModifierKeywordTokenArray3[1] = ktModifierKeywordToken8;
        KtModifierKeywordToken ktModifierKeywordToken9 = KtTokens.FINAL_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken9), (String)"FINAL_KEYWORD");
        ktModifierKeywordTokenArray3[2] = ktModifierKeywordToken9;
        KtModifierKeywordToken ktModifierKeywordToken10 = KtTokens.SEALED_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken10), (String)"SEALED_KEYWORD");
        ktModifierKeywordTokenArray3[3] = ktModifierKeywordToken10;
        map3 = this.incompatibilityRegister(ktModifierKeywordTokenArray3);
        map2.putAll(map3);
        map2 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray4 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken11 = KtTokens.DATA_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken11), (String)"DATA_KEYWORD");
        ktModifierKeywordTokenArray4[0] = ktModifierKeywordToken11;
        KtModifierKeywordToken ktModifierKeywordToken12 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken12), (String)"OPEN_KEYWORD");
        ktModifierKeywordTokenArray4[1] = ktModifierKeywordToken12;
        map3 = this.incompatibilityRegister(ktModifierKeywordTokenArray4);
        map2.putAll(map3);
        map2 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray5 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken13 = KtTokens.DATA_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken13), (String)"DATA_KEYWORD");
        ktModifierKeywordTokenArray5[0] = ktModifierKeywordToken13;
        KtModifierKeywordToken ktModifierKeywordToken14 = KtTokens.INNER_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken14), (String)"INNER_KEYWORD");
        ktModifierKeywordTokenArray5[1] = ktModifierKeywordToken14;
        map3 = this.incompatibilityRegister(ktModifierKeywordTokenArray5);
        map2.putAll(map3);
        map2 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray6 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken15 = KtTokens.DATA_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken15), (String)"DATA_KEYWORD");
        ktModifierKeywordTokenArray6[0] = ktModifierKeywordToken15;
        KtModifierKeywordToken ktModifierKeywordToken16 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken16), (String)"ABSTRACT_KEYWORD");
        ktModifierKeywordTokenArray6[1] = ktModifierKeywordToken16;
        map3 = this.incompatibilityRegister(ktModifierKeywordTokenArray6);
        map2.putAll(map3);
        map2 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray7 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken17 = KtTokens.DATA_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken17), (String)"DATA_KEYWORD");
        ktModifierKeywordTokenArray7[0] = ktModifierKeywordToken17;
        KtModifierKeywordToken ktModifierKeywordToken18 = KtTokens.SEALED_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken18), (String)"SEALED_KEYWORD");
        ktModifierKeywordTokenArray7[1] = ktModifierKeywordToken18;
        map3 = this.incompatibilityRegister(ktModifierKeywordTokenArray7);
        map2.putAll(map3);
        map2 = result2;
        KtModifierKeywordToken ktModifierKeywordToken19 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken19), (String)"ABSTRACT_KEYWORD");
        KtModifierKeywordToken ktModifierKeywordToken20 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken20), (String)"OPEN_KEYWORD");
        map3 = this.redundantRegister(ktModifierKeywordToken19, ktModifierKeywordToken20);
        map2.putAll(map3);
        map2 = result2;
        KtModifierKeywordToken ktModifierKeywordToken21 = KtTokens.SEALED_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken21), (String)"SEALED_KEYWORD");
        KtModifierKeywordToken ktModifierKeywordToken22 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken22), (String)"ABSTRACT_KEYWORD");
        map3 = this.redundantRegister(ktModifierKeywordToken21, ktModifierKeywordToken22);
        map2.putAll(map3);
        map2 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray8 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken23 = KtTokens.CONST_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken23), (String)"CONST_KEYWORD");
        ktModifierKeywordTokenArray8[0] = ktModifierKeywordToken23;
        KtModifierKeywordToken ktModifierKeywordToken24 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken24), (String)"ABSTRACT_KEYWORD");
        ktModifierKeywordTokenArray8[1] = ktModifierKeywordToken24;
        map3 = this.incompatibilityRegister(ktModifierKeywordTokenArray8);
        map2.putAll(map3);
        map2 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray9 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken25 = KtTokens.CONST_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken25), (String)"CONST_KEYWORD");
        ktModifierKeywordTokenArray9[0] = ktModifierKeywordToken25;
        KtModifierKeywordToken ktModifierKeywordToken26 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken26), (String)"OPEN_KEYWORD");
        ktModifierKeywordTokenArray9[1] = ktModifierKeywordToken26;
        map3 = this.incompatibilityRegister(ktModifierKeywordTokenArray9);
        map2.putAll(map3);
        map2 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray10 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken27 = KtTokens.CONST_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken27), (String)"CONST_KEYWORD");
        ktModifierKeywordTokenArray10[0] = ktModifierKeywordToken27;
        KtModifierKeywordToken ktModifierKeywordToken28 = KtTokens.OVERRIDE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken28), (String)"OVERRIDE_KEYWORD");
        ktModifierKeywordTokenArray10[1] = ktModifierKeywordToken28;
        map3 = this.incompatibilityRegister(ktModifierKeywordTokenArray10);
        map2.putAll(map3);
        map2 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray11 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken29 = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken29), (String)"PRIVATE_KEYWORD");
        ktModifierKeywordTokenArray11[0] = ktModifierKeywordToken29;
        KtModifierKeywordToken ktModifierKeywordToken30 = KtTokens.OVERRIDE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken30), (String)"OVERRIDE_KEYWORD");
        ktModifierKeywordTokenArray11[1] = ktModifierKeywordToken30;
        map3 = this.incompatibilityRegister(ktModifierKeywordTokenArray11);
        map2.putAll(map3);
        map2 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray12 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken31 = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken31), (String)"PRIVATE_KEYWORD");
        ktModifierKeywordTokenArray12[0] = ktModifierKeywordToken31;
        KtModifierKeywordToken ktModifierKeywordToken32 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken32), (String)"OPEN_KEYWORD");
        ktModifierKeywordTokenArray12[1] = ktModifierKeywordToken32;
        map3 = this.compatibilityForClassesRegister(ktModifierKeywordTokenArray12);
        map2.putAll(map3);
        map2 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray13 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken33 = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken33), (String)"PRIVATE_KEYWORD");
        ktModifierKeywordTokenArray13[0] = ktModifierKeywordToken33;
        KtModifierKeywordToken ktModifierKeywordToken34 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken34), (String)"ABSTRACT_KEYWORD");
        ktModifierKeywordTokenArray13[1] = ktModifierKeywordToken34;
        map3 = this.compatibilityForClassesRegister(ktModifierKeywordTokenArray13);
        map2.putAll(map3);
        map2 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray14 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken35 = KtTokens.CROSSINLINE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken35), (String)"CROSSINLINE_KEYWORD");
        ktModifierKeywordTokenArray14[0] = ktModifierKeywordToken35;
        KtModifierKeywordToken ktModifierKeywordToken36 = KtTokens.NOINLINE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken36), (String)"NOINLINE_KEYWORD");
        ktModifierKeywordTokenArray14[1] = ktModifierKeywordToken36;
        map3 = this.incompatibilityRegister(ktModifierKeywordTokenArray14);
        map2.putAll(map3);
        map2 = result2;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray15 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken37 = KtTokens.SEALED_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken37), (String)"SEALED_KEYWORD");
        ktModifierKeywordTokenArray15[0] = ktModifierKeywordToken37;
        KtModifierKeywordToken ktModifierKeywordToken38 = KtTokens.INNER_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken38), (String)"INNER_KEYWORD");
        ktModifierKeywordTokenArray15[1] = ktModifierKeywordToken38;
        map3 = this.incompatibilityRegister(ktModifierKeywordTokenArray15);
        map2.putAll(map3);
        return result2;
    }

    private final Map<Pair<KtModifierKeywordToken, KtModifierKeywordToken>, Compatibility> redundantRegister(KtModifierKeywordToken sufficient, KtModifierKeywordToken redundant) {
        return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)new Pair((Object)sufficient, (Object)redundant), (Object)((Object)Compatibility.REDUNDANT)), TuplesKt.to((Object)new Pair((Object)redundant, (Object)sufficient), (Object)((Object)Compatibility.REVERSE_REDUNDANT))});
    }

    private final Map<Pair<KtModifierKeywordToken, KtModifierKeywordToken>, Compatibility> compatibilityRegister(Compatibility compatibility, KtModifierKeywordToken ... list2) {
        HashMap result2 = new HashMap();
        for (int i = 0; i < list2.length; ++i) {
            KtModifierKeywordToken first = list2[i];
            for (int j = 0; j < list2.length; ++j) {
                KtModifierKeywordToken second = list2[j];
                if (!(Intrinsics.areEqual((Object)((Object)first), (Object)((Object)second)) ^ true)) continue;
                Map map2 = result2;
                Pair pair2 = new Pair((Object)first, (Object)second);
                Compatibility compatibility2 = compatibility;
                map2.put(pair2, compatibility2);
            }
        }
        return result2;
    }

    private final Map<Pair<KtModifierKeywordToken, KtModifierKeywordToken>, Compatibility> compatibilityForClassesRegister(KtModifierKeywordToken ... list2) {
        return this.compatibilityRegister(Compatibility.COMPATIBLE_FOR_CLASSES_ONLY, Arrays.copyOf(list2, list2.length));
    }

    private final Map<Pair<KtModifierKeywordToken, KtModifierKeywordToken>, Compatibility> incompatibilityRegister(KtModifierKeywordToken ... list2) {
        return this.compatibilityRegister(Compatibility.INCOMPATIBLE, Arrays.copyOf(list2, list2.length));
    }

    private final Map<Pair<KtModifierKeywordToken, KtModifierKeywordToken>, Compatibility> deprecationRegister(KtModifierKeywordToken ... list2) {
        return this.compatibilityRegister(Compatibility.DEPRECATED, Arrays.copyOf(list2, list2.length));
    }

    private final Compatibility compatibility(KtModifierKeywordToken first, KtModifierKeywordToken second) {
        if (Intrinsics.areEqual((Object)((Object)first), (Object)((Object)second))) {
            return Compatibility.REPEATED;
        }
        Compatibility compatibility = mutualCompatibility.get(new Pair((Object)first, (Object)second));
        if (compatibility == null) {
            compatibility = Compatibility.COMPATIBLE;
        }
        return compatibility;
    }

    private final void checkCompatibility(BindingTrace trace, ASTNode firstNode, ASTNode secondNode, PsiElement owner, Set<ASTNode> incorrectNodes) {
        IElementType iElementType = firstNode.getElementType();
        if (iElementType == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
        }
        KtModifierKeywordToken first = (KtModifierKeywordToken)iElementType;
        IElementType iElementType2 = secondNode.getElementType();
        if (iElementType2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
        }
        KtModifierKeywordToken second = (KtModifierKeywordToken)iElementType2;
        Compatibility compatibility = this.compatibility(first, second);
        switch (ModifierCheckerCore$WhenMappings.$EnumSwitchMapping$0[compatibility.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                if (!incorrectNodes.add(secondNode)) break;
                trace.report(Errors.REPEATED_MODIFIER.on(secondNode.getPsi(), first));
                break;
            }
            case 3: {
                trace.report(Errors.REDUNDANT_MODIFIER.on(secondNode.getPsi(), second, first));
                break;
            }
            case 4: {
                trace.report(Errors.REDUNDANT_MODIFIER.on(firstNode.getPsi(), first, second));
                break;
            }
            case 5: {
                trace.report(Errors.DEPRECATED_MODIFIER_PAIR.on(firstNode.getPsi(), first, second));
                trace.report(Errors.DEPRECATED_MODIFIER_PAIR.on(secondNode.getPsi(), second, first));
                break;
            }
            case 6: 
            case 7: {
                if (Intrinsics.areEqual((Object)((Object)compatibility), (Object)((Object)Compatibility.COMPATIBLE_FOR_CLASSES_ONLY)) && owner instanceof KtClassOrObject) {
                    return;
                }
                if (incorrectNodes.add(firstNode)) {
                    trace.report(Errors.INCOMPATIBLE_MODIFIERS.on(firstNode.getPsi(), first, second));
                }
                if (!incorrectNodes.add(secondNode)) break;
                trace.report(Errors.INCOMPATIBLE_MODIFIERS.on(secondNode.getPsi(), second, first));
            }
        }
    }

    private final boolean checkTarget(BindingTrace trace, ASTNode node, List<? extends KotlinTarget> actualTargets) {
        boolean bl;
        KotlinTarget it;
        Iterable $receiver$iv;
        Set redundantTargets;
        KtModifierKeywordToken modifier;
        block15: {
            Set set;
            Set deprecatedTargets;
            boolean bl2;
            block14: {
                IElementType iElementType = node.getElementType();
                if (iElementType == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
                }
                modifier = (KtModifierKeywordToken)iElementType;
                Set set2 = possibleTargetMap.get((Object)modifier);
                if (set2 == null) {
                    set2 = SetsKt.emptySet();
                }
                Set possibleTargets = set2;
                Iterable $receiver$iv2 = actualTargets;
                for (Object element$iv : $receiver$iv2) {
                    KotlinTarget it2 = (KotlinTarget)((Object)element$iv);
                    if (!possibleTargets.contains((Object)it2)) continue;
                    bl2 = true;
                    break block14;
                }
                bl2 = false;
            }
            if (!bl2) {
                PsiElement psiElement2 = node.getPsi();
                Object object = (KotlinTarget)((Object)CollectionsKt.firstOrNull(actualTargets));
                if (object == null || (object = object.getDescription()) == null) {
                    object = "this";
                }
                trace.report(Errors.WRONG_MODIFIER_TARGET.on(psiElement2, modifier, (String)object));
                return false;
            }
            Set set3 = deprecatedTargetMap.get((Object)modifier);
            if (set3 == null) {
                set3 = deprecatedTargets = SetsKt.emptySet();
            }
            if ((set = redundantTargetMap.get((Object)modifier)) == null) {
                set = SetsKt.emptySet();
            }
            redundantTargets = set;
            $receiver$iv = actualTargets;
            for (Object element$iv : $receiver$iv) {
                it = (KotlinTarget)((Object)element$iv);
                if (!deprecatedTargets.contains((Object)it)) continue;
                bl = true;
                break block15;
            }
            bl = false;
        }
        if (bl) {
            PsiElement psiElement3 = node.getPsi();
            Object object = (KotlinTarget)((Object)CollectionsKt.firstOrNull(actualTargets));
            if (object == null || (object = object.getDescription()) == null) {
                object = "this";
            }
            trace.report(Errors.DEPRECATED_MODIFIER_FOR_TARGET.on(psiElement3, modifier, (String)object));
        } else {
            boolean bl3;
            block16: {
                $receiver$iv = actualTargets;
                for (Object element$iv : $receiver$iv) {
                    it = (KotlinTarget)((Object)element$iv);
                    if (!redundantTargets.contains((Object)it)) continue;
                    bl3 = true;
                    break block16;
                }
                bl3 = false;
            }
            if (bl3) {
                PsiElement psiElement4 = node.getPsi();
                Object object = (KotlinTarget)((Object)CollectionsKt.firstOrNull(actualTargets));
                if (object == null || (object = object.getDescription()) == null) {
                    object = "this";
                }
                trace.report(Errors.REDUNDANT_MODIFIER_FOR_TARGET.on(psiElement4, modifier, (String)object));
            }
        }
        return true;
    }

    private final boolean checkLanguageLevelSupport(BindingTrace trace, ASTNode node, LanguageVersionSettings languageVersionSettings, List<? extends KotlinTarget> actualTargets) {
        IElementType iElementType = node.getElementType();
        if (iElementType == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
        }
        KtModifierKeywordToken modifier = (KtModifierKeywordToken)iElementType;
        LanguageFeature languageFeature = featureDependencies.get((Object)modifier);
        if (languageFeature == null) {
            return true;
        }
        LanguageFeature dependency = languageFeature;
        LanguageFeature.State featureSupport = languageVersionSettings.getFeatureSupport(dependency);
        Pair diagnosticData = TuplesKt.to((Object)((Object)dependency), (Object)languageVersionSettings);
        if (Intrinsics.areEqual((Object)featureSupport, (Object)LanguageFeature.State.ENABLED_WITH_ERROR) || Intrinsics.areEqual((Object)featureSupport, (Object)LanguageFeature.State.DISABLED)) {
            Set<KotlinTarget> restrictedTargets = featureDependenciesTargets.get((Object)dependency);
            if (restrictedTargets != null && CollectionsKt.intersect((Iterable)actualTargets, (Iterable)restrictedTargets).isEmpty()) {
                return true;
            }
            if (Intrinsics.areEqual((Object)featureSupport, (Object)LanguageFeature.State.DISABLED)) {
                trace.report(Errors.UNSUPPORTED_FEATURE.on(node.getPsi(), (Pair<LanguageFeature, LanguageVersionSettings>)diagnosticData));
            } else {
                trace.report(Errors.EXPERIMENTAL_FEATURE_ERROR.on(node.getPsi(), (Pair<LanguageFeature, LanguageVersionSettings>)diagnosticData));
            }
            return false;
        }
        if (Intrinsics.areEqual((Object)featureSupport, (Object)LanguageFeature.State.ENABLED_WITH_WARNING)) {
            trace.report(Errors.EXPERIMENTAL_FEATURE_WARNING.on(node.getPsi(), (Pair<LanguageFeature, LanguageVersionSettings>)diagnosticData));
        }
        return true;
    }

    private final boolean checkParent(BindingTrace trace, ASTNode node, DeclarationDescriptor parentDescriptor) {
        boolean bl;
        List actualParents;
        KtModifierKeywordToken modifier;
        block11: {
            IElementType iElementType = node.getElementType();
            if (iElementType == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
            }
            modifier = (KtModifierKeywordToken)iElementType;
            DeclarationDescriptor declarationDescriptor = parentDescriptor;
            actualParents = declarationDescriptor instanceof ClassDescriptor ? KotlinTarget.Companion.classActualTargets((ClassDescriptor)parentDescriptor) : (declarationDescriptor instanceof FunctionDescriptor ? CollectionsKt.listOf((Object)((Object)KotlinTarget.FUNCTION)) : CollectionsKt.listOf((Object)((Object)KotlinTarget.FILE)));
            Set<KotlinTarget> deprecatedParents = deprecatedParentTargetMap.get((Object)modifier);
            if (deprecatedParents != null) {
                boolean bl2;
                block10: {
                    Iterable $receiver$iv = actualParents;
                    for (Object element$iv : $receiver$iv) {
                        KotlinTarget it = (KotlinTarget)((Object)element$iv);
                        if (!deprecatedParents.contains((Object)it)) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = false;
                }
                if (bl2) {
                    PsiElement psiElement2 = node.getPsi();
                    Object object = (KotlinTarget)((Object)CollectionsKt.firstOrNull((List)actualParents));
                    if (object == null || (object = object.getDescription()) == null) {
                        object = "this scope";
                    }
                    trace.report(Errors.DEPRECATED_MODIFIER_CONTAINING_DECLARATION.on(psiElement2, modifier, (String)object));
                    return true;
                }
            }
            Set<KotlinTarget> set = possibleParentTargetMap.get((Object)modifier);
            if (set == null) {
                return true;
            }
            Set<KotlinTarget> possibleParents = set;
            if (Intrinsics.areEqual(possibleParents, KotlinTarget.Companion.getALL_TARGET_SET())) {
                return true;
            }
            Iterable $receiver$iv = actualParents;
            for (Object element$iv : $receiver$iv) {
                KotlinTarget it = (KotlinTarget)((Object)element$iv);
                if (!possibleParents.contains((Object)it)) continue;
                bl = true;
                break block11;
            }
            bl = false;
        }
        if (bl) {
            return true;
        }
        PsiElement psiElement3 = node.getPsi();
        Object object = (KotlinTarget)((Object)CollectionsKt.firstOrNull((List)actualParents));
        if (object == null || (object = object.getDescription()) == null) {
            object = "this scope";
        }
        trace.report(Errors.WRONG_MODIFIER_CONTAINING_DECLARATION.on(psiElement3, modifier, (String)object));
        return false;
    }

    private final void checkModifierList(KtModifierList list2, BindingTrace trace, DeclarationDescriptor parentDescriptor, List<? extends KotlinTarget> actualTargets, LanguageVersionSettings languageVersionSettings) {
        HashSet incorrectNodes = new HashSet();
        ASTNode[] children2 = list2.getNode().getChildren(MODIFIER_KEYWORD_SET);
        for (int i = 0; i < children2.length; ++i) {
            Collection collection;
            ASTNode first;
            ASTNode second = children2[i];
            for (int j = 0; j < children2.length && !Intrinsics.areEqual((Object)(first = children2[j]), (Object)second); ++j) {
                ASTNode aSTNode = first;
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"first");
                ASTNode aSTNode2 = second;
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"second");
                PsiElement psiElement2 = list2.getOwner();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"list.owner");
                this.checkCompatibility(trace, aSTNode, aSTNode2, psiElement2, incorrectNodes);
            }
            if (!(incorrectNodes.contains(second) ^ true)) continue;
            ASTNode aSTNode = second;
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"second");
            if (!this.checkTarget(trace, aSTNode, actualTargets)) {
                collection = incorrectNodes;
                collection.add(second);
                continue;
            }
            ASTNode aSTNode3 = second;
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode3, (String)"second");
            if (!this.checkParent(trace, aSTNode3, parentDescriptor)) {
                collection = incorrectNodes;
                collection.add(second);
                continue;
            }
            ASTNode aSTNode4 = second;
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode4, (String)"second");
            if (this.checkLanguageLevelSupport(trace, aSTNode4, languageVersionSettings, actualTargets)) continue;
            collection = incorrectNodes;
            collection.add(second);
        }
    }

    public final void check(@NotNull KtModifierListOwner listOwner, @NotNull BindingTrace trace, @Nullable DeclarationDescriptor descriptor2, @NotNull LanguageVersionSettings languageVersionSettings) {
        KtModifierList list2;
        Intrinsics.checkParameterIsNotNull((Object)listOwner, (String)"listOwner");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (listOwner instanceof KtDeclarationWithBody) {
            for (KtParameter parameter : ((KtDeclarationWithBody)listOwner).getValueParameters()) {
                if (parameter.hasValOrVar()) continue;
                KtParameter ktParameter = parameter;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"parameter");
                this.check(ktParameter, trace, null, languageVersionSettings);
            }
        }
        KtElement ktElement = listOwner;
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        List<KotlinTarget> actualTargets = AnnotationChecker.Companion.getDeclarationSiteActualTargetList(ktElement, (ClassDescriptor)declarationDescriptor, trace);
        KtModifierList ktModifierList = listOwner.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList ktModifierList2 = list2 = ktModifierList;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktModifierList2, (String)"list");
        DeclarationDescriptor declarationDescriptor2 = descriptor2;
        this.checkModifierList(ktModifierList2, trace, declarationDescriptor2 != null ? declarationDescriptor2.getContainingDeclaration() : null, actualTargets, languageVersionSettings);
    }

    private ModifierCheckerCore() {
        INSTANCE = this;
        defaultVisibilityTargets = EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, new KotlinTarget[]{KotlinTarget.OBJECT, KotlinTarget.INTERFACE, KotlinTarget.ENUM_CLASS, KotlinTarget.ANNOTATION_CLASS, KotlinTarget.MEMBER_FUNCTION, KotlinTarget.TOP_LEVEL_FUNCTION, KotlinTarget.PROPERTY_GETTER, KotlinTarget.PROPERTY_SETTER, KotlinTarget.MEMBER_PROPERTY, KotlinTarget.TOP_LEVEL_PROPERTY, KotlinTarget.CONSTRUCTOR, KotlinTarget.TYPEALIAS});
        possibleTargetMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)KtTokens.ENUM_KEYWORD), EnumSet.of((Enum)KotlinTarget.ENUM_CLASS)), TuplesKt.to((Object)((Object)KtTokens.ABSTRACT_KEYWORD), EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, (Enum)KotlinTarget.LOCAL_CLASS, (Enum)KotlinTarget.INTERFACE, (Enum)KotlinTarget.MEMBER_PROPERTY, (Enum)KotlinTarget.MEMBER_FUNCTION)), TuplesKt.to((Object)((Object)KtTokens.OPEN_KEYWORD), EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, (Enum)KotlinTarget.LOCAL_CLASS, (Enum)KotlinTarget.INTERFACE, (Enum)KotlinTarget.MEMBER_PROPERTY, (Enum)KotlinTarget.MEMBER_FUNCTION)), TuplesKt.to((Object)((Object)KtTokens.FINAL_KEYWORD), EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, new KotlinTarget[]{KotlinTarget.LOCAL_CLASS, KotlinTarget.ENUM_CLASS, KotlinTarget.OBJECT, KotlinTarget.MEMBER_PROPERTY, KotlinTarget.MEMBER_FUNCTION})), TuplesKt.to((Object)((Object)KtTokens.SEALED_KEYWORD), EnumSet.of((Enum)KotlinTarget.CLASS_ONLY)), TuplesKt.to((Object)((Object)KtTokens.INNER_KEYWORD), EnumSet.of((Enum)KotlinTarget.CLASS_ONLY)), TuplesKt.to((Object)((Object)KtTokens.OVERRIDE_KEYWORD), EnumSet.of((Enum)KotlinTarget.MEMBER_PROPERTY, (Enum)KotlinTarget.MEMBER_FUNCTION)), TuplesKt.to((Object)((Object)KtTokens.PRIVATE_KEYWORD), defaultVisibilityTargets), TuplesKt.to((Object)((Object)KtTokens.PUBLIC_KEYWORD), defaultVisibilityTargets), TuplesKt.to((Object)((Object)KtTokens.INTERNAL_KEYWORD), defaultVisibilityTargets), TuplesKt.to((Object)((Object)KtTokens.PROTECTED_KEYWORD), EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, new KotlinTarget[]{KotlinTarget.OBJECT, KotlinTarget.INTERFACE, KotlinTarget.ENUM_CLASS, KotlinTarget.ANNOTATION_CLASS, KotlinTarget.MEMBER_FUNCTION, KotlinTarget.PROPERTY_GETTER, KotlinTarget.PROPERTY_SETTER, KotlinTarget.MEMBER_PROPERTY, KotlinTarget.CONSTRUCTOR, KotlinTarget.TYPEALIAS})), TuplesKt.to((Object)((Object)KtTokens.IN_KEYWORD), EnumSet.of((Enum)KotlinTarget.TYPE_PARAMETER, (Enum)KotlinTarget.TYPE_PROJECTION)), TuplesKt.to((Object)((Object)KtTokens.OUT_KEYWORD), EnumSet.of((Enum)KotlinTarget.TYPE_PARAMETER, (Enum)KotlinTarget.TYPE_PROJECTION)), TuplesKt.to((Object)((Object)KtTokens.REIFIED_KEYWORD), EnumSet.of((Enum)KotlinTarget.TYPE_PARAMETER)), TuplesKt.to((Object)((Object)KtTokens.VARARG_KEYWORD), EnumSet.of((Enum)KotlinTarget.VALUE_PARAMETER, (Enum)KotlinTarget.PROPERTY_PARAMETER)), TuplesKt.to((Object)((Object)KtTokens.COMPANION_KEYWORD), EnumSet.of((Enum)KotlinTarget.OBJECT)), TuplesKt.to((Object)((Object)KtTokens.LATEINIT_KEYWORD), EnumSet.of((Enum)KotlinTarget.MEMBER_PROPERTY)), TuplesKt.to((Object)((Object)KtTokens.DATA_KEYWORD), EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, (Enum)KotlinTarget.LOCAL_CLASS)), TuplesKt.to((Object)((Object)KtTokens.INLINE_KEYWORD), EnumSet.of((Enum)KotlinTarget.FUNCTION, (Enum)KotlinTarget.PROPERTY, (Enum)KotlinTarget.PROPERTY_GETTER, (Enum)KotlinTarget.PROPERTY_SETTER)), TuplesKt.to((Object)((Object)KtTokens.NOINLINE_KEYWORD), EnumSet.of((Enum)KotlinTarget.VALUE_PARAMETER)), TuplesKt.to((Object)((Object)KtTokens.TAILREC_KEYWORD), EnumSet.of((Enum)KotlinTarget.FUNCTION)), TuplesKt.to((Object)((Object)KtTokens.SUSPEND_KEYWORD), EnumSet.of((Enum)KotlinTarget.MEMBER_FUNCTION, (Enum)KotlinTarget.TOP_LEVEL_FUNCTION)), TuplesKt.to((Object)((Object)KtTokens.EXTERNAL_KEYWORD), EnumSet.of((Enum)KotlinTarget.FUNCTION, (Enum)KotlinTarget.PROPERTY, (Enum)KotlinTarget.PROPERTY_GETTER, (Enum)KotlinTarget.PROPERTY_SETTER, (Enum)KotlinTarget.CLASS)), TuplesKt.to((Object)((Object)KtTokens.ANNOTATION_KEYWORD), EnumSet.of((Enum)KotlinTarget.ANNOTATION_CLASS)), TuplesKt.to((Object)((Object)KtTokens.CROSSINLINE_KEYWORD), EnumSet.of((Enum)KotlinTarget.VALUE_PARAMETER)), TuplesKt.to((Object)((Object)KtTokens.CONST_KEYWORD), EnumSet.of((Enum)KotlinTarget.MEMBER_PROPERTY, (Enum)KotlinTarget.TOP_LEVEL_PROPERTY)), TuplesKt.to((Object)((Object)KtTokens.OPERATOR_KEYWORD), EnumSet.of((Enum)KotlinTarget.FUNCTION)), TuplesKt.to((Object)((Object)KtTokens.INFIX_KEYWORD), EnumSet.of((Enum)KotlinTarget.FUNCTION)), TuplesKt.to((Object)((Object)KtTokens.HEADER_KEYWORD), EnumSet.of((Enum)KotlinTarget.TOP_LEVEL_FUNCTION, new KotlinTarget[]{KotlinTarget.TOP_LEVEL_PROPERTY_WITHOUT_FIELD_OR_DELEGATE, KotlinTarget.CLASS_ONLY, KotlinTarget.OBJECT, KotlinTarget.INTERFACE, KotlinTarget.ENUM_CLASS, KotlinTarget.ANNOTATION_CLASS})), TuplesKt.to((Object)((Object)KtTokens.IMPL_KEYWORD), EnumSet.of((Enum)KotlinTarget.TOP_LEVEL_FUNCTION, new KotlinTarget[]{KotlinTarget.MEMBER_FUNCTION, KotlinTarget.TOP_LEVEL_PROPERTY, KotlinTarget.MEMBER_PROPERTY, KotlinTarget.CONSTRUCTOR, KotlinTarget.CLASS_ONLY, KotlinTarget.OBJECT, KotlinTarget.INTERFACE, KotlinTarget.ENUM_CLASS, KotlinTarget.ANNOTATION_CLASS, KotlinTarget.TYPEALIAS}))});
        featureDependencies = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)KtTokens.SUSPEND_KEYWORD), (Object)((Object)LanguageFeature.Coroutines)), TuplesKt.to((Object)((Object)KtTokens.INLINE_KEYWORD), (Object)((Object)LanguageFeature.InlineProperties)), TuplesKt.to((Object)((Object)KtTokens.HEADER_KEYWORD), (Object)((Object)LanguageFeature.MultiPlatformProjects)), TuplesKt.to((Object)((Object)KtTokens.IMPL_KEYWORD), (Object)((Object)LanguageFeature.MultiPlatformProjects))});
        featureDependenciesTargets = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)LanguageFeature.InlineProperties), (Object)SetsKt.setOf((Object[])new KotlinTarget[]{KotlinTarget.PROPERTY, KotlinTarget.PROPERTY_GETTER, KotlinTarget.PROPERTY_SETTER})));
        deprecatedTargetMap = MapsKt.emptyMap();
        redundantTargetMap = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)KtTokens.OPEN_KEYWORD), EnumSet.of((Enum)KotlinTarget.INTERFACE)));
        possibleParentTargetMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)KtTokens.INNER_KEYWORD), EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, (Enum)KotlinTarget.LOCAL_CLASS, (Enum)KotlinTarget.ENUM_CLASS)), TuplesKt.to((Object)((Object)KtTokens.OVERRIDE_KEYWORD), EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, new KotlinTarget[]{KotlinTarget.LOCAL_CLASS, KotlinTarget.OBJECT, KotlinTarget.OBJECT_LITERAL, KotlinTarget.INTERFACE, KotlinTarget.ENUM_CLASS, KotlinTarget.ENUM_ENTRY})), TuplesKt.to((Object)((Object)KtTokens.PROTECTED_KEYWORD), EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, (Enum)KotlinTarget.LOCAL_CLASS, (Enum)KotlinTarget.ENUM_CLASS, (Enum)KotlinTarget.COMPANION_OBJECT)), TuplesKt.to((Object)((Object)KtTokens.INTERNAL_KEYWORD), EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, new KotlinTarget[]{KotlinTarget.LOCAL_CLASS, KotlinTarget.OBJECT, KotlinTarget.OBJECT_LITERAL, KotlinTarget.ENUM_CLASS, KotlinTarget.ENUM_ENTRY, KotlinTarget.FILE})), TuplesKt.to((Object)((Object)KtTokens.PRIVATE_KEYWORD), EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, new KotlinTarget[]{KotlinTarget.LOCAL_CLASS, KotlinTarget.OBJECT, KotlinTarget.OBJECT_LITERAL, KotlinTarget.INTERFACE, KotlinTarget.ENUM_CLASS, KotlinTarget.ENUM_ENTRY, KotlinTarget.FILE})), TuplesKt.to((Object)((Object)KtTokens.COMPANION_KEYWORD), EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, (Enum)KotlinTarget.ENUM_CLASS, (Enum)KotlinTarget.INTERFACE)), TuplesKt.to((Object)((Object)KtTokens.FINAL_KEYWORD), EnumSet.of((Enum)KotlinTarget.CLASS_ONLY, new KotlinTarget[]{KotlinTarget.LOCAL_CLASS, KotlinTarget.OBJECT, KotlinTarget.OBJECT_LITERAL, KotlinTarget.ENUM_CLASS, KotlinTarget.ENUM_ENTRY, KotlinTarget.ANNOTATION_CLASS, KotlinTarget.FILE}))});
        deprecatedParentTargetMap = MapsKt.emptyMap();
        mutualCompatibility = this.buildCompatibilityMap();
        MODIFIER_KEYWORD_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{KtTokens.SOFT_KEYWORDS, TokenSet.create((IElementType[])new IElementType[]{KtTokens.IN_KEYWORD})});
    }

    static {
        new ModifierCheckerCore();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/resolve/ModifierCheckerCore$Compatibility;", "", "(Ljava/lang/String;I)V", "COMPATIBLE", "REDUNDANT", "REVERSE_REDUNDANT", "REPEATED", "DEPRECATED", "INCOMPATIBLE", "COMPATIBLE_FOR_CLASSES_ONLY", "frontend"})
    private static final class Compatibility
    extends Enum<Compatibility> {
        public static final /* enum */ Compatibility COMPATIBLE;
        public static final /* enum */ Compatibility REDUNDANT;
        public static final /* enum */ Compatibility REVERSE_REDUNDANT;
        public static final /* enum */ Compatibility REPEATED;
        public static final /* enum */ Compatibility DEPRECATED;
        public static final /* enum */ Compatibility INCOMPATIBLE;
        public static final /* enum */ Compatibility COMPATIBLE_FOR_CLASSES_ONLY;
        private static final /* synthetic */ Compatibility[] $VALUES;

        static {
            Compatibility[] compatibilityArray = new Compatibility[7];
            Compatibility[] compatibilityArray2 = compatibilityArray;
            compatibilityArray[0] = COMPATIBLE = new Compatibility();
            compatibilityArray[1] = REDUNDANT = new Compatibility();
            compatibilityArray[2] = REVERSE_REDUNDANT = new Compatibility();
            compatibilityArray[3] = REPEATED = new Compatibility();
            compatibilityArray[4] = DEPRECATED = new Compatibility();
            compatibilityArray[5] = INCOMPATIBLE = new Compatibility();
            compatibilityArray[6] = COMPATIBLE_FOR_CLASSES_ONLY = new Compatibility();
            $VALUES = compatibilityArray;
        }

        public static Compatibility[] values() {
            return (Compatibility[])$VALUES.clone();
        }

        public static Compatibility valueOf(String string) {
            return Enum.valueOf(Compatibility.class, string);
        }
    }
}

