/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.access;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.access.DbCredentialManager;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.util.DbImplUtil;
import com.intellij.ide.passwordSafe.ui.PasswordPromptComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.PasswordUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseCredentials {
    private static final String DB_SSH_PWD = "db:ssh:pwd@";
    private static final String DB_SSH_PHR = "db:ssh:phr@";
    private static final DatabaseCredentials ourInstance = new DatabaseCredentials();
    private final DbCredentialManager dbCredentialManager = new DbCredentialManager();
    private static final Object ourEDTLock = new Object();

    public static DatabaseCredentials getInstance() {
        return ourInstance;
    }

    public static DatabaseCredentials newUIInstance() {
        return new DatabaseCredentials(){
            boolean myForceMemoryProvider;

            @Override
            public void persistCredentials(@NotNull DatabaseSystem info) {
                if (info == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/access/DatabaseCredentials$1", "persistCredentials"));
                }
                if (this.myForceMemoryProvider && info instanceof LocalDataSource && ((LocalDataSource)info).isUseMasterKeyStorage()) {
                    ((LocalDataSource)info).setUseMasterKeyStorage(false);
                }
                super.persistCredentials(info);
            }
        };
    }

    @Nullable
    private static LocalDataSource getLocalDataSource(@Nullable DatabaseSystem info) {
        if (!(info instanceof LocalDataSource)) {
            return null;
        }
        if (!DbImplUtil.isAuthRequired((LocalDataSource)info)) {
            return null;
        }
        return (LocalDataSource)info;
    }

    protected static boolean isUseCredentialStore(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials", "isUseCredentialStore"));
        }
        return dataSource.getUniqueId() != null;
    }

    @Nullable
    public Credentials getCredentials(@NotNull DatabaseSystem info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/access/DatabaseCredentials", "getCredentials"));
        }
        LocalDataSource dataSource = DatabaseCredentials.getLocalDataSource(info);
        if (dataSource == null) {
            return null;
        }
        if (dataSource.getUniqueId() == null) {
            return new Credentials(dataSource.getUsername(), dataSource.getPassword());
        }
        return new Credentials(dataSource.getUsername(), this.dbCredentialManager.getPasswordAsString(dataSource, null));
    }

    @NotNull
    public CompletionStage<Credentials> getCredentialsAsync(@NotNull DatabaseSystem info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/access/DatabaseCredentials", "getCredentialsAsync"));
        }
        LocalDataSource dataSource = DatabaseCredentials.getLocalDataSource(info);
        if (dataSource == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "getCredentialsAsync"));
            }
            return completableFuture;
        }
        if (dataSource.getUniqueId() == null) {
            CompletableFuture<Credentials> completableFuture = CompletableFuture.completedFuture(new Credentials(dataSource.getUsername(), dataSource.getPassword()));
            if (completableFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "getCredentialsAsync"));
            }
            return completableFuture;
        }
        CompletionStage<Credentials> completionStage = this.dbCredentialManager.getPasswordAsStringAsync(dataSource, null).thenApply(p -> new Credentials(dataSource.getUsername(), p));
        if (completionStage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "getCredentialsAsync"));
        }
        return completionStage;
    }

    public boolean setCredentials(@NotNull DatabaseSystem info, @NotNull Credentials credentials) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/access/DatabaseCredentials", "setCredentials"));
        }
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/intellij/database/access/DatabaseCredentials", "setCredentials"));
        }
        LocalDataSource dataSource = DatabaseCredentials.getLocalDataSource(info);
        if (dataSource == null) {
            return false;
        }
        dataSource.setUsername(credentials.getUserName());
        if (dataSource.getUniqueId() == null) {
            dataSource.setPassword(credentials.getPasswordAsString());
        } else {
            this.dbCredentialManager.set(dataSource, credentials, dataSource.isUseMasterKeyStorage());
        }
        return true;
    }

    public boolean removeCredentials(@NotNull DatabaseSystem info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/access/DatabaseCredentials", "removeCredentials"));
        }
        LocalDataSource dataSource = DatabaseCredentials.getLocalDataSource(info);
        if (dataSource == null) {
            return false;
        }
        if (DatabaseCredentials.isUseCredentialStore(dataSource)) {
            this.dbCredentialManager.set(dataSource, null);
        } else {
            dataSource.setPassword(null);
        }
        return true;
    }

    public void copyCredentials(@NotNull DatabaseSystem from, @NotNull DatabaseSystem to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/access/DatabaseCredentials", "copyCredentials"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/access/DatabaseCredentials", "copyCredentials"));
        }
        Credentials credentials = this.getCredentials(from);
        if (credentials != null && credentials.getUserName() != null) {
            this.setCredentials(to, credentials);
        }
    }

    public void persistCredentials(@NotNull DatabaseSystem info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/access/DatabaseCredentials", "persistCredentials"));
        }
        LocalDataSource dataSource = DatabaseCredentials.getLocalDataSource(info);
        if (dataSource == null) {
            return;
        }
        String uid = dataSource.getUsername();
        String pwd = dataSource.getPassword();
        dataSource.setPassword(null);
        dataSource.setUsername(uid);
        if (dataSource.getUniqueId() == null) {
            dataSource.setPassword(pwd);
        } else {
            this.dbCredentialManager.set(dataSource, new Credentials(uid, pwd), dataSource.isUseMasterKeyStorage());
        }
    }

    @NotNull
    public CompletionStage<Credentials> askCredentialsWhenFailed(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull String message, String userNameDef) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/access/DatabaseCredentials", "askCredentialsWhenFailed"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials", "askCredentialsWhenFailed"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/access/DatabaseCredentials", "askCredentialsWhenFailed"));
        }
        if (DatabaseCredentials.getLocalDataSource((DatabaseSystem)dataSource) == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "askCredentialsWhenFailed"));
            }
            return completableFuture;
        }
        if (project.isDefault()) {
            CompletableFuture<Credentials> completableFuture = AsyncUtil.cancelled();
            if (completableFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "askCredentialsWhenFailed"));
            }
            return completableFuture;
        }
        Credentials c1 = this.getCredentials((DatabaseSystem)dataSource);
        CompletableFuture<Credentials> completableFuture = CompletableFuture.supplyAsync(AsyncUtil.captureIndicator(() -> {
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials", "lambda$askCredentialsWhenFailed$1"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/access/DatabaseCredentials", "lambda$askCredentialsWhenFailed$1"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/access/DatabaseCredentials", "lambda$askCredentialsWhenFailed$1"));
            }
            Credentials c2 = this.getCredentials((DatabaseSystem)dataSource);
            if (!Comparing.equal((Object)c1, (Object)c2)) {
                return c2;
            }
            PasswordPromptComponent component = new PasswordPromptComponent(dataSource.getUniqueId() == null, message);
            component.setUserName(StringUtil.notNullize((String)userNameDef));
            DialogBuilder builder = new DialogBuilder(project);
            builder.setTitle("Connecting to '" + dataSource.getName() + "'...");
            builder.setCenterPanel(component.getComponent());
            builder.setPreferredFocusComponent(component.getPreferredFocusedComponent());
            builder.addOkAction();
            builder.addCancelAction();
            if (builder.show() != 0) {
                return null;
            }
            Credentials credentials = new Credentials(component.getUserName(), component.getPassword());
            dataSource.setUsername(credentials.getUserName());
            if (dataSource.getUniqueId() == null) {
                dataSource.setPassword(new String(component.getPassword()));
            } else {
                boolean remember = component.isRememberSelected();
                dataSource.setUseMasterKeyStorage(remember);
                this.dbCredentialManager.set(dataSource, credentials, remember);
            }
            return credentials;
        }), this::invokeLater);
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "askCredentialsWhenFailed"));
        }
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(@NotNull Runnable r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/access/DatabaseCredentials", "invokeLater"));
        }
        Application app = ApplicationManager.getApplication();
        if (app.isDispatchThread()) {
            r.run();
            return;
        }
        ProgressIndicator asyncProgress = AsyncUtil.getAsyncFriendlyIndicator();
        Runnable wrapped = () -> {
            if (r == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/access/DatabaseCredentials", "lambda$invokeLater$2"));
            }
            AsyncUtil.underProgress(r, asyncProgress);
        };
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        Object object = ourEDTLock;
        synchronized (object) {
            if (indicator != null && indicator.isModal()) {
                UIUtil.invokeLaterIfNeeded((Runnable)wrapped);
            } else {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(wrapped);
            }
        }
    }

    public void setSshCredentials(@NotNull LocalDataSource dataSource, char[] pwd, char[] phr, boolean useMasterKey) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials", "setSshCredentials"));
        }
        DataSourceSshTunnelConfiguration ssh = dataSource.getSshConfiguration();
        if (ssh == null || dataSource.getUniqueId() == null) {
            return;
        }
        this.dbCredentialManager.set(dataSource, new Credentials(dataSource.getUsername(), pwd), useMasterKey, DB_SSH_PWD);
        this.dbCredentialManager.set(dataSource, new Credentials(dataSource.getUsername(), phr), useMasterKey, DB_SSH_PHR);
    }

    public void removeSshCredentials(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials", "removeSshCredentials"));
        }
        if (DatabaseCredentials.isUseCredentialStore(dataSource)) {
            this.dbCredentialManager.set(dataSource, null, true, DB_SSH_PWD);
            this.dbCredentialManager.set(dataSource, null, true, DB_SSH_PHR);
        }
    }

    @NotNull
    public Pair<String, String> getSshCredentials(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials", "getSshCredentials"));
        }
        DataSourceSshTunnelConfiguration ssh = dataSource.getSshConfiguration();
        if (ssh == null) {
            Pair pair = Pair.create((Object)"", (Object)"");
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "getSshCredentials"));
            }
            return pair;
        }
        if (DatabaseCredentials.isUseCredentialStore(dataSource)) {
            String pwd = this.dbCredentialManager.getPasswordAsString(dataSource, DB_SSH_PWD);
            String phr = this.dbCredentialManager.getPasswordAsString(dataSource, DB_SSH_PHR);
            Pair pair = Pair.create((Object)StringUtil.notNullize((String)pwd), (Object)StringUtil.notNullize((String)phr));
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "getSshCredentials"));
            }
            return pair;
        }
        Pair pair = Pair.create((Object)PasswordUtil.decodePassword((String)ssh.getPassword()), (Object)PasswordUtil.decodePassword((String)ssh.getPassphrase()));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "getSshCredentials"));
        }
        return pair;
    }

    @NotNull
    public CompletionStage<Pair<String, String>> getSshCredentialsAsync(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials", "getSshCredentialsAsync"));
        }
        DataSourceSshTunnelConfiguration ssh = dataSource.getSshConfiguration();
        if (ssh == null) {
            CompletableFuture<Pair<String, String>> completableFuture = CompletableFuture.completedFuture(Pair.create((Object)"", (Object)""));
            if (completableFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "getSshCredentialsAsync"));
            }
            return completableFuture;
        }
        if (DatabaseCredentials.isUseCredentialStore(dataSource)) {
            CompletionStage<Pair<String, String>> completionStage = this.dbCredentialManager.getPasswordAsStringAsync(dataSource, DB_SSH_PWD).thenCombine(this.dbCredentialManager.getPasswordAsStringAsync(dataSource, DB_SSH_PHR), (pwd, phr) -> Pair.create((Object)StringUtil.notNullize((String)pwd), (Object)StringUtil.notNullize((String)phr)));
            if (completionStage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "getSshCredentialsAsync"));
            }
            return completionStage;
        }
        CompletableFuture<Pair<String, String>> completableFuture = CompletableFuture.completedFuture(Pair.create((Object)PasswordUtil.decodePassword((String)ssh.getPassword()), (Object)PasswordUtil.decodePassword((String)ssh.getPassphrase())));
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "getSshCredentialsAsync"));
        }
        return completableFuture;
    }
}

