/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.actions.AddDataSourceFromUrl;
import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.dataSource.DataSourceTemplate;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiManager;
import com.intellij.database.vfs.DbStorageFileType;
import com.intellij.database.view.DatabaseView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeView;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TripleFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.EnumSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AddDataSourceFromPath
extends AnAction
implements DumbAware {
    final DatabaseViewActions.DataSourceFactory myFactory;

    @Nullable
    private static DbPsiFacade getFacade(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/actions/AddDataSourceFromPath", "getFacade"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        return project == null || project.isDisposed() ? null : DbPsiFacade.getInstance((Project)project);
    }

    public AddDataSourceFromPath(@NotNull String text, @NotNull String desc, @NotNull Icon icon, @NotNull DatabaseViewActions.DataSourceFactory factory) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/actions/AddDataSourceFromPath", "<init>"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "com/intellij/database/actions/AddDataSourceFromPath", "<init>"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/database/actions/AddDataSourceFromPath", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/database/actions/AddDataSourceFromPath", "<init>"));
        }
        super(text, desc, icon);
        this.myFactory = factory;
    }

    @NotNull
    private static String getPath(@Nullable String base, @NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/actions/AddDataSourceFromPath", "getPath"));
        }
        String string = base == null || FileUtil.isAbsolute((String)path) ? path : FileUtil.join((String[])new String[]{base, path});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/AddDataSourceFromPath", "getPath"));
        }
        return string;
    }

    @NotNull
    private static String getRelative(@Nullable String base, @NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/actions/AddDataSourceFromPath", "getRelative"));
        }
        String string = base == null ? path : (String)ObjectUtils.chooseNotNull((Object)FileUtil.getRelativePath((File)new File(base), (File)new File(path)), (Object)path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/AddDataSourceFromPath", "getRelative"));
        }
        return string;
    }

    @Nullable
    private static String chooseFile(@NotNull Project project, @Nullable String cur) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/AddDataSourceFromPath", "chooseFile"));
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, false);
        descriptor.setTitle("Select Database Location");
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, cur == null ? null : LocalFileSystem.getInstance().findFileByPath(cur));
        return file == null ? null : file.getCanonicalPath();
    }

    public static void newDataSourceFromFileInput(final @NotNull DbPsiFacade facade, final @Nullable String basePath, final @NotNull String path, @NotNull TripleFunction<DbPsiManager, DataSourceTemplate, String, Void> consumer) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/actions/AddDataSourceFromPath", "newDataSourceFromFileInput"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/actions/AddDataSourceFromPath", "newDataSourceFromFileInput"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/actions/AddDataSourceFromPath", "newDataSourceFromFileInput"));
        }
        new AddDataSourceFromUrl.FastDataSourceDialog(facade.getProject(), (manager, template, s) -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/actions/AddDataSourceFromPath", "lambda$newDataSourceFromFileInput$0"));
            }
            consumer.fun(manager, template, (Object)AddDataSourceFromPath.buildUrl((DatabaseDriver)template, AddDataSourceFromPath.getPath(basePath, s)));
            VirtualFileManager.getInstance().refreshWithoutFileWatcher(true);
            return null;
        }){
            {
                super(project, (TripleFunction<DbPsiManager, DataSourceTemplate, String, Void>)consumer);
                this.setTitle("New Data Source");
                this.getNameLabel().setText(UIUtil.replaceMnemonicAmpersand((String)"&Path:"));
                JComponent parent = (JComponent)this.getNameField().getParent();
                GridLayoutManager layout = (GridLayoutManager)parent.getLayout();
                GridConstraints constraints = layout.getConstraintsForComponent((Component)this.getNameField());
                Box panel = new Box(0);
                panel.add(this.getNameField());
                FixedSizeButton button = new FixedSizeButton((JComponent)this.getNameField());
                panel.add((Component)button);
                parent.add((Component)panel, constraints);
                if (!StringUtil.isEmpty((String)path)) {
                    this.getNameField().setText(path);
                }
                button.setAction(new AbstractAction(null, AllIcons.General.Ellipsis){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String file = AddDataSourceFromPath.chooseFile(facade.getProject(), AddDataSourceFromPath.getPath(basePath, this.getNameField().getText()));
                        if (file == null) {
                            return;
                        }
                        this.getNameField().setText(AddDataSourceFromPath.getRelative(basePath, file));
                    }
                });
            }

            @Override
            protected boolean looksLikeOk(@NotNull String str) {
                if (str == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/database/actions/AddDataSourceFromPath$1", "looksLikeOk"));
                }
                return StringUtil.isEmpty((String)path);
            }

            @Override
            @Nullable
            protected DatabaseDriver selectDriver(@NotNull String str) {
                if (str == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/database/actions/AddDataSourceFromPath$1", "selectDriver"));
                }
                String fullPath = AddDataSourceFromPath.getPath(basePath, str);
                DatabaseFamilyId family = this.getFamily(LocalFileSystem.getInstance().findFileByPath(fullPath));
                if (family == null) {
                    return null;
                }
                for (Pair driverPair : this.myDrivers) {
                    DatabaseFamilyId familyId;
                    SqlLanguageDialect lang = DatabaseDriverImpl.getLanguage((DatabaseDriver)driverPair.second);
                    if (lang == null || family != (familyId = lang.getDatabaseDialect().getFamilyId())) continue;
                    return (DatabaseDriver)driverPair.second;
                }
                return null;
            }

            @Nullable
            private DatabaseFamilyId getFamily(@Nullable VirtualFile file) {
                if (file == null) {
                    return null;
                }
                if (file.getFileType() instanceof DbStorageFileType.SqliteStorage) {
                    return DatabaseFamilyId.SQLITE;
                }
                if (file.getFileType() instanceof DbStorageFileType.H2Storage) {
                    return DatabaseFamilyId.H2;
                }
                return null;
            }

            @Override
            @NotNull
            protected List<Pair<DbPsiManager, DatabaseDriver>> extractDrivers(@NotNull DbPsiFacade facade2) {
                if (facade2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/actions/AddDataSourceFromPath$1", "extractDrivers"));
                }
                List list = ContainerUtil.filter(1.allDrivers(facade2), pair -> AddDataSourceFromPath.isGoodLocations(((DatabaseDriver)pair.second).getSupportedLocations()));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/AddDataSourceFromPath$1", "extractDrivers"));
                }
                return list;
            }
        }.show();
    }

    private static boolean isGoodLocations(@NotNull EnumSet<StatelessJdbcUrlParser.LocationType> locations) {
        if (locations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locations", "com/intellij/database/actions/AddDataSourceFromPath", "isGoodLocations"));
        }
        return locations.contains((Object)StatelessJdbcUrlParser.LocationType.DIRECTORY) || locations.contains((Object)StatelessJdbcUrlParser.LocationType.FILE);
    }

    @NotNull
    private static String buildUrl(@NotNull DatabaseDriver driver, @NotNull String path) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/actions/AddDataSourceFromPath", "buildUrl"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/actions/AddDataSourceFromPath", "buildUrl"));
        }
        for (StatelessJdbcUrlParser parser : driver.getJDBCUrlParsers()) {
            if (!AddDataSourceFromPath.isGoodLocations(parser.getPossibleLocations())) continue;
            JdbcUrlParser statefull = parser.createStatefull();
            for (String p : statefull.getParameters()) {
                String val = p.equals("file") || p.equals("path") ? path : statefull.getParameterDefValue(p);
                statefull.setParameter(p, StringUtil.notNullize((String)val));
            }
            String string = statefull.getUrlText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/AddDataSourceFromPath", "buildUrl"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/AddDataSourceFromPath", "buildUrl"));
        }
        return "";
    }

    public static class Here
    extends AddDataSourceFromPath {
        public Here(@NotNull DatabaseViewActions.DataSourceFactory factory) {
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/database/actions/AddDataSourceFromPath$Here", "<init>"));
            }
            super("Data Source", "Creates new data source here", DatabaseIcons.Dbms, factory);
        }

        public void update(AnActionEvent e) {
            IdeView view2 = (IdeView)LangDataKeys.IDE_VIEW.getData(e.getDataContext());
            boolean enabled = !ScratchFileService.isInScratchRoot((VirtualFile)((VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE))) && view2 != null && view2.getDirectories().length != 0;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            IdeView view2 = (IdeView)LangDataKeys.IDE_VIEW.getData(e.getDataContext());
            DbPsiFacade facade = AddDataSourceFromPath.getFacade(e.getDataContext());
            if (facade == null || view2 == null) {
                return;
            }
            PsiDirectory directory = view2.getOrChooseDirectory();
            if (directory == null) {
                return;
            }
            Here.newDataSourceFromFileInput(facade, directory.getVirtualFile().getCanonicalPath(), "", (TripleFunction<DbPsiManager, DataSourceTemplate, String, Void>)((TripleFunction)(manager, template, s) -> {
                this.myFactory.create(facade, (DbPsiManager)manager, (DataSourceTemplate)template, (String)s);
                return null;
            }));
        }
    }

    public static class FromThat
    extends AddDataSourceFromPath {
        public FromThat(@NotNull DatabaseViewActions.DataSourceFactory factory) {
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/database/actions/AddDataSourceFromPath$FromThat", "<init>"));
            }
            super("As Data Source...", "Creates new data source from selected file", DatabaseIcons.Dbms, factory);
        }

        public void update(AnActionEvent e) {
            boolean enabled;
            IdeView view2 = (IdeView)LangDataKeys.IDE_VIEW.getData(e.getDataContext());
            DbPsiFacade facade = AddDataSourceFromPath.getFacade(e.getDataContext());
            boolean bl = enabled = view2 != null && facade != null;
            if (enabled) {
                VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext());
                enabled = files != null && files.length == 1 && files[0].isInLocalFileSystem() && files[0].getFileType() instanceof DbStorageFileType;
            }
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext());
            if (files == null || files.length != 1) {
                return;
            }
            DbPsiFacade facade = AddDataSourceFromPath.getFacade(e.getDataContext());
            if (facade == null) {
                return;
            }
            FromThat.newDataSourceFromFileInput(facade, null, StringUtil.notNullize((String)files[0].getCanonicalPath()), (TripleFunction<DbPsiManager, DataSourceTemplate, String, Void>)((TripleFunction)(manager, template, s) -> {
                this.myFactory.create(facade, (DbPsiManager)manager, (DataSourceTemplate)template, (String)s);
                return null;
            }));
        }
    }

    public static class FromDialog
    extends AddDataSourceFromPath {
        public FromDialog(@NotNull DatabaseViewActions.DataSourceFactory factory) {
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/database/actions/AddDataSourceFromPath$FromDialog", "<init>"));
            }
            super("Data Source from Path", "Creates new data source from file", AllIcons.Actions.Menu_open, factory);
        }

        public void update(AnActionEvent e) {
            DatabaseView databaseView = (DatabaseView)((Object)DatabaseView.DATABASE_VIEW_KEY.getData(e.getDataContext()));
            DbPsiFacade facade = AddDataSourceFromPath.getFacade(e.getDataContext());
            e.getPresentation().setEnabledAndVisible(databaseView != null && facade != null);
        }

        public void actionPerformed(AnActionEvent e) {
            DbPsiFacade facade = AddDataSourceFromPath.getFacade(e.getDataContext());
            if (facade == null) {
                return;
            }
            String path = AddDataSourceFromPath.chooseFile(facade.getProject(), null);
            if (path == null) {
                return;
            }
            FromDialog.newDataSourceFromFileInput(facade, null, path, (TripleFunction<DbPsiManager, DataSourceTemplate, String, Void>)((TripleFunction)(manager, template, s) -> {
                this.myFactory.create(facade, (DbPsiManager)manager, (DataSourceTemplate)template, (String)s);
                return null;
            }));
        }
    }
}

