/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.basic.BasicScriptable;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.scripting.ScriptingFactory;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GenerateSqlActions {
    @NotNull
    private static String doGenerateDDL(@NotNull Collection<DbElement> selectedElements) {
        String script2;
        if (selectedElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedElements", "com/intellij/database/actions/GenerateSqlActions", "doGenerateDDL"));
        }
        ArrayList<BasicElement> list1 = new ArrayList<BasicElement>(selectedElements.size());
        ArrayList<DbElement> list2 = new ArrayList<DbElement>(selectedElements.size());
        for (DbElement e : selectedElements) {
            Object d = e.getDelegate();
            if (d != null && d instanceof BasicScriptable) {
                list1.add((BasicScriptable)d);
                continue;
            }
            if (d instanceof LocalDataSource) {
                LocalDataSource lds = (LocalDataSource)((Object)d);
                DasModel m = lds.getModel();
                if (!(m instanceof BasicModel)) continue;
                list1.add(((BasicModel)m).getRoot());
                continue;
            }
            list2.add(e);
        }
        String script1 = list1.isEmpty() ? null : GenerateSqlActions.doGenerateDDLUsingScriptingService(list1);
        String string = script2 = list2.isEmpty() ? null : GenerateSqlActions.doGenerateDDLUsingDDLBuilder(list2);
        if (script1 != null && script2 == null) {
            String string2 = script1;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/GenerateSqlActions", "doGenerateDDL"));
            }
            return string2;
        }
        if (script2 != null && script1 == null) {
            String string3 = script2;
            if (string3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/GenerateSqlActions", "doGenerateDDL"));
            }
            return string3;
        }
        if (script1 != null && script2 != null) {
            String string4 = script1 + "\n\n" + script2;
            if (string4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/GenerateSqlActions", "doGenerateDDL"));
            }
            return string4;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/GenerateSqlActions", "doGenerateDDL"));
        }
        return "";
    }

    @NotNull
    private static String doGenerateDDLUsingScriptingService(@NotNull Collection<BasicElement> selectedElements) {
        if (selectedElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedElements", "com/intellij/database/actions/GenerateSqlActions", "doGenerateDDLUsingScriptingService"));
        }
        Map<BasicModel, List<BasicElement>> groupedByModels = ModelFun.groupByModel(selectedElements);
        StringBuilder b = new StringBuilder();
        for (Map.Entry<BasicModel, List<BasicElement>> entry : groupedByModels.entrySet()) {
            List elements;
            BasicModel m = entry.getKey();
            String text = GenerateSqlActions.doGenerateDDLUsingScriptingService(m, elements = JBIterable.from((Iterable)entry.getValue()).toList());
            if (text.length() <= 0) continue;
            if (b.length() > 0) {
                b.append("\n\n");
            }
            b.append(text);
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/GenerateSqlActions", "doGenerateDDLUsingScriptingService"));
        }
        return string;
    }

    @NotNull
    private static String doGenerateDDLUsingScriptingService(@NotNull BasicModel model, @NotNull Iterable<? extends BasicElement> selectedElements) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/actions/GenerateSqlActions", "doGenerateDDLUsingScriptingService"));
        }
        if (selectedElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedElements", "com/intellij/database/actions/GenerateSqlActions", "doGenerateDDLUsingScriptingService"));
        }
        ScriptingFactory scriptingFactory = (ScriptingFactory)ServiceManager.getService(ScriptingFactory.class);
        ScriptingService scriptingService = scriptingFactory.createScriptingService(model, null, null);
        JBIterable selection = JBIterable.from(selectedElements);
        JBIterable visibleDatabasesOfRoot = selection.filter(BasicMultiDatabaseRoot.class).flatten(r -> r.getDatabases()).filter(BasicDatabase.class).filter(BasicNamespace::isVisible);
        JBIterable databasesSchemata = visibleDatabasesOfRoot.append((Iterable)selection.filter(BasicDatabase.class).filter(db -> !visibleDatabasesOfRoot.contains(db))).flatten(db -> db.getSchemas()).filter(BasicSchema.class).filter(s -> !s.isNameSurrogate()).filter(BasicMateNamespace::isVisible);
        JBIterable explicitSchemata = selection.filter(BasicSchema.class).filter(s -> !databasesSchemata.contains(s));
        List schemata = databasesSchemata.append((Iterable)explicitSchemata).toList();
        scriptingService.makeScript(ScriptingTask.CREATE_COMPLETE, schemata);
        List otherObjects = selection.filter(BasicSchemaObject.class).filter(o -> !schemata.contains(o.getSchema())).toList();
        scriptingService.makeScript(ScriptingTask.CREATE_COMPLETE, otherObjects, true);
        String string = scriptingService.getScriptText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/GenerateSqlActions", "doGenerateDDLUsingScriptingService"));
        }
        return string;
    }

    @NotNull
    private static String doGenerateDDLUsingDDLBuilder(@NotNull Collection<DbElement> selectedElements) {
        if (selectedElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedElements", "com/intellij/database/actions/GenerateSqlActions", "doGenerateDDLUsingDDLBuilder"));
        }
        final THashSet visited = ContainerUtil.newTroveSet();
        DdlBuilder builder = new DdlBuilder(){

            @Override
            @NotNull
            public DdlBuilder element(@NotNull DasObject element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/actions/GenerateSqlActions$1", "element"));
                }
                if (!visited.add((Object)element)) {
                    1 v0 = this;
                    if (v0 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/GenerateSqlActions$1", "element"));
                    }
                    return v0;
                }
                if (element.getKind() == ObjectKind.SCHEMA) {
                    JBIterable tables = element.getDbChildren(DbTable.class, ObjectKind.NONE);
                    tables.addAllTo((Collection)visited);
                    this.tables((Iterable<? extends DasTable>)tables);
                }
                DdlBuilder ddlBuilder = super.element(element);
                if (ddlBuilder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/GenerateSqlActions$1", "element"));
                }
                return ddlBuilder;
            }
        };
        DbElement item = (DbElement)ContainerUtil.getFirstItem(selectedElements);
        if (item != null) {
            builder.configureFor(item);
        }
        for (DbElement e : selectedElements) {
            int length = builder.length();
            String s = DbImplUtil.loadDefinitionFromStorage(e);
            if (s != null) {
                builder.plain(StringUtil.trimEnd((String)StringUtil.trimTrailing((String)s), (char)';'));
            } else {
                builder.element((DasObject)e);
            }
            if (builder.length() <= length) continue;
            builder.newStatement();
        }
        String string = builder.getStatement();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/GenerateSqlActions", "doGenerateDDLUsingDDLBuilder"));
        }
        return string;
    }

    static class OpenDdlInConsoleAction
    extends DumbAwareAction {
        OpenDdlInConsoleAction() {
        }

        public void update(AnActionEvent e) {
            Set<DbElement> objects = DatabaseView.getSelectedElements(e.getDataContext(), (Condition<DbElement>)((Condition)o -> o instanceof DasSchemaChild));
            e.getPresentation().setEnabledAndVisible(!objects.isEmpty());
        }

        public void actionPerformed(AnActionEvent e) {
            Set<DbElement> objects = DatabaseView.getSelectedElements(e.getDataContext(), (Condition<DbElement>)((Condition)o -> o instanceof DasSchemaChild));
            String ddl = GenerateSqlActions.doGenerateDDL(objects);
            if (StringUtil.isEmpty((String)ddl)) {
                return;
            }
            DbUIUtil.openInConsole(objects.iterator().next(), ddl);
        }
    }

    static class CopyDdlAction
    extends DumbAwareAction {
        CopyDdlAction() {
        }

        public void update(AnActionEvent e) {
            Set<DbElement> objects = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class);
            boolean enabled = !objects.isEmpty();
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(enabled || ActionPlaces.isToolbarPlace((String)e.getPlace()));
        }

        public void actionPerformed(AnActionEvent e) {
            Set<DbElement> objects = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class);
            if (objects.isEmpty()) {
                return;
            }
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(GenerateSqlActions.doGenerateDDL(objects)));
        }
    }
}

