/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.console.AbstractEngine;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.SuppressUserStackTrace;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.datagrid.mutating.QueryData;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.database.datagrid.mutating.RowQueryData;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteSavepoint;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.Alarm;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SingleAlarm;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TObjectHashingStrategy;
import java.io.EOFException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcEngine
extends AbstractEngine
implements DataProducer {
    private static final Logger LOG = Logger.getInstance(JdbcEngine.class);
    private static final Map<JdbcEngine, Statement> ourPendingStatements = ContainerUtil.newConcurrentMap((TObjectHashingStrategy)ContainerUtil.identityStrategy());
    private static final SingleAlarm ourPendingStatementsAlarm = new SingleAlarm(JdbcEngine::printAllWarnings, 1000, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)ApplicationManager.getApplication());
    private final JdbcDriverManager myDriverManager;
    private final LocalDataSource myDataSource;
    private final ThrowableComputable<Connection, Exception> myConnectionFactory;
    private volatile Connection myConnection;
    private DataRequest.TxMarker myTxMarker;
    private ConsoleRunConfiguration myConfiguration;
    private final AtomicReference<State> myState;
    private volatile SearchPath mySearchPath;
    private DatabaseDialectEx myDialect;
    private DatabaseFamilyId myFamilyId;

    public JdbcEngine(@NotNull Project project, @NotNull DataBus.Producing messageBus, LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/JdbcEngine", "<init>"));
        }
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/database/console/JdbcEngine", "<init>"));
        }
        super(project, messageBus);
        this.myState = new AtomicReference<State>(State.IDLE);
        this.myDataSource = dataSource;
        this.myDriverManager = JdbcDriverManager.getDriverManager(project);
        this.myConfiguration = configuration;
        this.myConnectionFactory = configuration == null ? () -> {
            this.myConfiguration = this.myDriverManager.getDefaultRunConfiguration(this.myDataSource);
            return DatabaseConnectionManager.getInstance().getConnectionSync(this.myDriverManager, this.myConfiguration, this.myDataSource);
        } : () -> DatabaseConnectionManager.getInstance().getConnectionSync(this.myDriverManager, this.myConfiguration, this.myDataSource);
        this.myTxMarker = DataRequest.getInitialTxMarker(this.myDataSource.isAutoCommit());
    }

    @Nullable
    public Connection getCurrentConnection() {
        return this.myConnection;
    }

    @Nullable
    public Connection getConnection() throws Exception {
        return this.getConnection(true);
    }

    @Nullable
    public SearchPath requestSearchPath() {
        try {
            Connection connection = this.getCurrentConnection();
            this.mySearchPath = connection == null ? null : this.myDialect.tryToLoadSearchPath((DatabaseSystem)this.myDataSource, connection);
            return this.mySearchPath;
        }
        catch (Exception exception) {
            return this.mySearchPath;
        }
    }

    @Nullable
    public SearchPath getSearchPath() {
        return this.mySearchPath;
    }

    void setSearchPath(@Nullable SearchPath searchPath) {
        this.mySearchPath = searchPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Connection getConnection(boolean setCurrentSchema) throws Exception {
        Connection connection = this.getCurrentConnection();
        boolean freshConnection = false;
        if (!this.isConnectionReady(connection)) {
            ThrowableComputable<Connection, Exception> throwableComputable = this.myConnectionFactory;
            synchronized (throwableComputable) {
                this.myConnection = connection = (Connection)this.myConnectionFactory.compute();
                freshConnection = true;
            }
            this.myFamilyId = DatabaseFamilyId.forDataSource((DatabaseSystem)this.myDataSource);
            this.myDialect = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect(this.myFamilyId), (Object)GenericDialect.INSTANCE);
        }
        if (!this.isConnectionReady(connection)) {
            connection = null;
            this.myConnection = null;
        }
        if (connection == null) {
            this.getDataAuditor().error(this.getRequestContext(), "Connection failed", null);
        } else {
            this.prepareConnection(connection, setCurrentSchema && freshConnection);
        }
        return connection;
    }

    @Override
    public boolean cancelPendingRequests() {
        super.cancelPendingRequests();
        DataRequest.Context context = this.getRequestContextIfAny();
        if (context == null) {
            return false;
        }
        if (this.myState.compareAndSet(State.STREAMING, State.CANCELED)) {
            this.getDataAuditor().print(context, "Cancelling...");
            return true;
        }
        if (this.myState.compareAndSet(State.RUNNING, State.CANCELED)) {
            Statement statement = ourPendingStatements.get(this);
            if (statement == null) {
                return true;
            }
            AppExecutorUtil.getAppExecutorService().submit(() -> {
                if (this.getRequestContextIfAny() == context) {
                    TimeoutUtil.sleep((long)500L);
                    if (this.getRequestContextIfAny() == context) {
                        this.getDataAuditor().print(context, "Cancelling...");
                        try {
                            statement.cancel();
                        }
                        catch (Throwable ex) {
                            context.reportException(ex, null);
                        }
                    }
                }
            });
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean completeTransaction(DataRequest.TxRequest r) throws Exception {
        if (this.myTxMarker.getOwner() == null || this.getCurrentConnection() == null) {
            return true;
        }
        Connection connection = this.getConnection();
        if (connection == null || !this.isConnectionReady(connection)) {
            return false;
        }
        boolean autoCommit = connection.getAutoCommit();
        try {
            if (!autoCommit && this.myTxMarker.getOwner() != null) {
                if (r.command == DataRequest.TxCommand.COMMIT) {
                    connection.commit();
                } else {
                    connection.rollback();
                }
                this.getDataAuditor().txCompleted(this.getRequestContext(), r.command == DataRequest.TxCommand.COMMIT);
            }
        }
        finally {
            this.myTxMarker = DataRequest.NONE;
            this.printWarnings(connection);
        }
        return true;
    }

    public LocalDataSource getDataSource() {
        return this.myDataSource;
    }

    public boolean isStarted() {
        return this.myDriverManager.getActiveConfigurations(this.myDataSource).contains((Object)this.myConfiguration);
    }

    @Override
    public void terminate() {
        super.terminate();
        this.myDriverManager.releaseDriver(this.myDataSource, this.myConfiguration);
        this.myConnection = null;
    }

    @Override
    public void visitQuery(@NotNull DataRequest.QueryRequest r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/console/JdbcEngine", "visitQuery"));
        }
        this.submitRequest(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            if (r == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/console/JdbcEngine", "lambda$visitQuery$3"));
            }
            return r instanceof DataRequest.ConditionQueryRequest ? this.executeConditionQueryRequest((DataRequest.ConditionQueryRequest)r) : this.executeQueryRequest(r);
        }));
    }

    @Override
    public void visitUpdate(@NotNull DataRequest.UpdateRequest r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/console/JdbcEngine", "visitUpdate"));
        }
        this.updateRows(r);
    }

    @Override
    public void visitInsert(@NotNull DataRequest.InsertRequest r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/console/JdbcEngine", "visitInsert"));
        }
        this.insertRows(r);
    }

    @Override
    public void visitDelete(@NotNull DataRequest.DeleteRequest r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/console/JdbcEngine", "visitDelete"));
        }
        this.deleteRows(r);
    }

    @Override
    public void visitComposite(DataRequest.CompositeRequest r) {
        final ArrayList infos = ContainerUtil.newArrayList();
        for (DataRequest.DmlRequest request : r.requests) {
            request.accept(new DataRequest.Visitor(){

                @Override
                public void visitInsert(DataRequest.InsertRequest r) {
                    infos.add(JdbcEngine.this.buildDataForInsert(r));
                }

                @Override
                public void visitUpdate(DataRequest.UpdateRequest r) {
                    infos.add(JdbcEngine.this.buildDataForUpdate(r));
                }

                @Override
                public void visitDelete(DataRequest.DeleteRequest r) {
                    infos.add(JdbcEngine.this.buildDataForDelete(r));
                }
            });
        }
        this.executeUpdateStatement(r, infos);
    }

    @Override
    public void visitTx(DataRequest.TxRequest r) {
        this.submitRequest(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> this.completeTransaction(r)));
    }

    @Override
    public void visitSchemaSwitch(@NotNull DataRequest.SchemaSwitchRequest r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/console/JdbcEngine", "visitSchemaSwitch"));
        }
        this.submitRequest(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            if (r == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/console/JdbcEngine", "lambda$visitSchemaSwitch$5"));
            }
            if (!DbImplUtil.supportsDynamicSchemaSwitching(this.myDataSource)) {
                return Boolean.FALSE;
            }
            Connection connection = this.getCurrentConnection();
            if (connection == null && !r.forced) {
                this.setSearchPath(r.path);
                return Boolean.TRUE;
            }
            connection = this.getConnection(false);
            return connection != null && this.performSchemaSwitch(connection, r.path, r);
        }));
    }

    @Override
    public void visitRaw(DataRequest.RawRequest r) {
        this.submitRequest(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            Connection connection = this.getConnection();
            if (connection == null) {
                return false;
            }
            try {
                this.getDataAuditor().requestStarted(this.getRequestContext());
                try {
                    r.processRaw(this.getRequestContext(), connection);
                    this.printWarnings(connection);
                }
                catch (ProcessCanceledException processCanceledException) {
                    this.printWarnings(connection);
                }
                catch (Throwable ex) {
                    try {
                        this.getRequestContext().reportException(ex, null);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.printWarnings(connection);
                    }
                }
            }
            finally {
                this.getDataAuditor().requestFinished(this.getRequestContext());
            }
            return true;
        }));
    }

    @Override
    @NotNull
    protected DataRequest.Context createRequestContext(@NotNull DataRequest request) {
        DataRequest.TxMarker marker;
        boolean ownerFailed;
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/console/JdbcEngine", "createRequestContext"));
        }
        if (!this.isConnectionReady(this.getCurrentConnection()) || this.myTxMarker == DataRequest.NONE) {
            this.myTxMarker = DataRequest.getInitialTxMarker(this.myTxMarker == DataRequest.AUTO_COMMIT || this.myTxMarker == DataRequest.NONE);
        }
        boolean bl = ownerFailed = this.myTxMarker.getOwner() != null && this.myTxMarker != request.txMarker;
        if (!(ownerFailed || request instanceof DataRequest.TxRequest || request.txMarker != DataRequest.START_NEW && this.myTxMarker != DataRequest.START_NEW || !((marker = (this.myTxMarker = DataRequest.newTxMarker("@" + request.owner.getDisplayName(), request.owner))).getOwner() instanceof Disposable))) {
            Disposer.register((Disposable)((Disposable)request.owner), (Disposable)new Disposable(){

                public void dispose() {
                    if (JdbcEngine.this.isDisposed()) {
                        return;
                    }
                    JdbcEngine.this.processRequest(DataRequest.newTxRollback(marker));
                }
            });
        }
        DataRequest.Context context = new DataRequest.Context(this, request, this.myTxMarker){

            @Override
            public void reportException(@NotNull Throwable th, Object parameter) {
                if (th == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "th", "com/intellij/database/console/JdbcEngine$3", "reportException"));
                }
                JdbcEngine.handleException(this, th, JdbcEngine.this.getDataAuditor(), (DatabaseSystem)JdbcEngine.this.getDataSource());
            }
        };
        if (ownerFailed) {
            ExecutionException th = new ExecutionException("locked by transaction: " + this.myTxMarker);
            context.reportException((Throwable)th, null);
            throw new ProcessCanceledException((Throwable)th);
        }
        DataRequest.Context context2 = context;
        if (context2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "createRequestContext"));
        }
        return context2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeQueryInner(@NotNull DataRequest.QueryRequest r, @NotNull String queryText, @NotNull ThrowableNotNullFunction<Connection, Statement, Exception> statementCreator) throws Exception {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/console/JdbcEngine", "executeQueryInner"));
        }
        if (queryText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryText", "com/intellij/database/console/JdbcEngine", "executeQueryInner"));
        }
        if (statementCreator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementCreator", "com/intellij/database/console/JdbcEngine", "executeQueryInner"));
        }
        Connection connection = this.getConnection();
        if (connection == null) {
            return false;
        }
        SavepointHelper savepointHelper = new SavepointHelper(connection.getAutoCommit() ? null : connection);
        Statement statement = null;
        DataRequest.Constraints constraints = r.constraints;
        try {
            statement = (Statement)statementCreator.fun((Object)connection);
            int maxRows = -1;
            if (constraints.offset >= 0 && !DbImplUtil.isPageSizeUnlimited(constraints.limit)) {
                Object type = null;
                try {
                    type = r instanceof ConsoleDataRequest ? ((ConsoleDataRequest)r).resultType : DbSqlUtil.parseQueryType(this.getProject(), DbSqlUtil.getSqlDialect(this.myDialect), DbSqlUtil.findAnyContext(this.getProject(), (DatabaseSystem)this.getDataSource(), this.getCurrentNamespace()), queryText, null);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
                if (type instanceof SqlTableType) {
                    maxRows = constraints.offset + constraints.limit + 1;
                    statement.setMaxRows(maxRows);
                }
            }
            int maxAllowedChunkSize = maxRows < 0 ? Integer.MAX_VALUE : maxRows;
            int defaultPrefetchSize = DatabaseSettings.getSettings().getPrefetchSize();
            int chunkSize = Math.min(maxAllowedChunkSize, Math.max(constraints.limit / 10, defaultPrefetchSize <= 0 ? 100 : defaultPrefetchSize));
            this.configurePreFetchSize(statement, chunkSize);
            try {
                Ref resultSetRef = Ref.create();
                boolean resultSetHere = statement instanceof PreparedStatement ? JdbcEngine.executePreparedStatement((PreparedStatement)statement, (Ref<ResultSet>)resultSetRef) : JdbcEngine.executeStatement(statement, (Ref<ResultSet>)resultSetRef, r, queryText);
                this.myState.compareAndSet(State.RUNNING, State.STREAMING);
                ResultSet resultSet = (ResultSet)resultSetRef.get();
                int updateCount = JdbcEngine.getUpdateCountSafe(statement);
                int resultSetIndex = 0;
                do {
                    this.checkCanceled();
                    if (r.constraints.resultSetNumber <= 0 || r.constraints.resultSetNumber == ++resultSetIndex) {
                        if (updateCount == -1 || resultSetHere) {
                            if (resultSet == null) {
                                resultSet = statement.getResultSet();
                            }
                            if (resultSet != null) {
                                this.checkCanceled();
                                int[] rowCount = new int[]{0};
                                try {
                                    this.getDataAuditor().fetchStarted(this.getRequestContext(), resultSetIndex);
                                    this.printResultSet(resultSet, resultSetIndex, constraints.offset, constraints.limit, chunkSize, rowCount);
                                }
                                finally {
                                    this.getDataAuditor().fetchFinished(this.getRequestContext(), resultSetIndex, rowCount[0]);
                                    this.printWarnings(resultSet);
                                }
                            }
                        } else {
                            this.getDataAuditor().updateCountReceived(this.getRequestContext(), updateCount);
                        }
                    }
                    resultSet = null;
                    resultSetHere = statement.getMoreResults();
                    updateCount = JdbcEngine.getUpdateCountSafe(statement);
                } while (resultSetHere || updateCount != -1);
                this.printWarnings(statement);
            }
            catch (Exception e) {
                this.printWarnings(statement);
                throw e;
            }
            savepointHelper.free(false);
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            this.getRequestContext().reportException(e, queryText);
            try {
                savepointHelper.free(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeStatement(statement);
            this.printWarnings(connection);
        }
    }

    private static boolean willScrollResultSet(DataRequest.Constraints constraints) {
        return constraints.offset != 0 && constraints.offset != 1;
    }

    private static boolean executePreparedStatement(@NotNull PreparedStatement statement, @NotNull Ref<ResultSet> ref) throws SQLException {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/console/JdbcEngine", "executePreparedStatement"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/database/console/JdbcEngine", "executePreparedStatement"));
        }
        ref.set((Object)statement.executeQuery());
        return !ref.isNull();
    }

    private static boolean executeStatement(@NotNull Statement statement, @NotNull Ref<ResultSet> ref, @NotNull DataRequest r, @NotNull String queryText) throws SQLException {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/console/JdbcEngine", "executeStatement"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/database/console/JdbcEngine", "executeStatement"));
        }
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/console/JdbcEngine", "executeStatement"));
        }
        if (queryText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryText", "com/intellij/database/console/JdbcEngine", "executeStatement"));
        }
        if (r instanceof ConsoleDataRequest && ((ConsoleDataRequest)r).resultType instanceof SqlTableType) {
            ref.set((Object)statement.executeQuery(queryText));
            return !ref.isNull();
        }
        return statement.execute(queryText);
    }

    @Nullable
    public ObjectPath getCurrentNamespace() {
        return SearchPath.getCurrent(this.mySearchPath);
    }

    private void configurePreFetchSize(Statement statement, int chunkSize) {
        try {
            DatabaseFamilyId familyId = this.myDialect.getFamilyId();
            if (familyId.isMysql()) {
                statement.setFetchSize(Integer.MIN_VALUE);
            } else {
                statement.setFetchSize(chunkSize);
            }
        }
        catch (SQLException e) {
            LOG.warn((Throwable)e);
        }
    }

    public static int getUpdateCountSafe(@NotNull Statement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/console/JdbcEngine", "getUpdateCountSafe"));
        }
        try {
            return statement.getUpdateCount();
        }
        catch (Exception ignored) {
            return -1;
        }
    }

    private void printWarnings(@Nullable Connection connection) {
        if (connection == null) {
            return;
        }
        this.printWarnings((ThrowableComputable<List<SQLWarning>, Throwable>)((ThrowableComputable)() -> ((RemoteConnection)RemoteUtil.castToRemoteNotNull((Object)connection, RemoteConnection.class)).getAllWarnings()));
    }

    private void printWarnings(@Nullable Statement statement) {
        if (statement == null) {
            return;
        }
        this.printWarnings((ThrowableComputable<List<SQLWarning>, Throwable>)((ThrowableComputable)() -> ((RemoteStatement)RemoteUtil.castToRemoteNotNull((Object)statement, RemoteStatement.class)).getAllWarnings()));
    }

    private void printWarnings(@Nullable ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        this.printWarnings((ThrowableComputable<List<SQLWarning>, Throwable>)((ThrowableComputable)() -> ((RemoteResultSet)RemoteUtil.castToRemoteNotNull((Object)resultSet, RemoteResultSet.class)).getAllWarnings()));
    }

    private void printWarnings(@NotNull ThrowableComputable<List<SQLWarning>, Throwable> producer) {
        if (producer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/console/JdbcEngine", "printWarnings"));
        }
        try {
            List warnings = (List)producer.compute();
            for (SQLWarning throwables : warnings) {
                this.getDataAuditor().warn(this.getRequestContext(), JdbcUtil.getLongMessage((Throwable)throwables));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void printAllWarnings() {
        for (JdbcEngine engine : ourPendingStatements.keySet()) {
            Statement statement;
            DatabaseFamilyId familyId;
            if (engine.myState.get() != State.RUNNING || (familyId = engine.myFamilyId) != DatabaseFamilyId.POSTGRES && familyId != DatabaseFamilyId.MSSQL || (statement = ourPendingStatements.get(engine)) == null) continue;
            try {
                engine.printWarnings(statement);
            }
            catch (Throwable throwable) {}
        }
        if (!ourPendingStatements.isEmpty()) {
            ourPendingStatementsAlarm.cancelAndRequest();
        }
    }

    private void changeCurrentStatement(@Nullable Statement oldValue, @Nullable Statement newValue) {
        if (newValue == null) {
            ourPendingStatements.remove(this);
            this.myState.set(State.IDLE);
        } else {
            ourPendingStatements.put(this, newValue);
            this.myState.set(State.RUNNING);
        }
        ourPendingStatementsAlarm.request();
    }

    private boolean isConnectionReady(@Nullable Connection connection) {
        if (connection == null) {
            return false;
        }
        try {
            if (this.myDialect.getFamilyId().isMysql()) {
                return connection.isValid(20);
            }
            return !connection.isClosed();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void prepareConnection(@NotNull Connection connection, boolean setCurrentSchema) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine", "prepareConnection"));
        }
        connection.setAutoCommit(this.myTxMarker == DataRequest.AUTO_COMMIT);
        try {
            if (this.myTxMarker == DataRequest.AUTO_COMMIT) {
                connection.setReadOnly(this.myDataSource.isReadOnly());
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        SearchPath schema = this.mySearchPath;
        if (setCurrentSchema && schema != null) {
            if (DbImplUtil.supportsDynamicSchemaSwitching(this.myDataSource) && DbImplUtil.autoSwitchSchema(DbImplUtil.getDatabaseDialect(this.myDataSource))) {
                this.performSchemaSwitch(connection, schema, null);
            }
        } else if (schema == null) {
            try {
                this.mySearchPath = this.myDialect.tryToLoadSearchPath((DatabaseSystem)this.myDataSource, connection);
            }
            catch (Exception e) {
                LOG.warn(this.myDataSource.getName() + ": prepareConnection: tryToLoadSearchPath failed:");
                LOG.warn(JdbcEngine.getErrorMessage(e, this.myDataSource.getName(), DatabaseFamilyId.forDataSource((DatabaseSystem)this.myDataSource)));
            }
        }
    }

    private boolean performSchemaSwitch(@NotNull Connection connection, @NotNull SearchPath to, @Nullable DataRequest.SchemaSwitchRequest request) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine", "performSchemaSwitch"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/console/JdbcEngine", "performSchemaSwitch"));
        }
        this.setSearchPath(to);
        String setSchemaSql = DbImplUtil.getSearchPath(to, this.myDataSource, this.myDialect);
        if (setSchemaSql == null) {
            return false;
        }
        return request == null ? this.performImplicitSchemaSwitch(connection, setSchemaSql) : this.performExplicitSchemaSwitch(connection, setSchemaSql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performImplicitSchemaSwitch(@NotNull Connection connection, @NotNull String setSchemaSql) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine", "performImplicitSchemaSwitch"));
        }
        if (setSchemaSql == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setSchemaSql", "com/intellij/database/console/JdbcEngine", "performImplicitSchemaSwitch"));
        }
        this.getDataAuditor().print(this.getRequestContext(), setSchemaSql);
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute(setSchemaSql);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.printWarnings(statement);
            String errorMessage = JdbcEngine.getErrorMessage(e, this.myDataSource.getName(), this.myDataSource.getFamilyId());
            this.getDataAuditor().print(this.getRequestContext(), "Failed to switch schema.\n" + errorMessage);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    this.getDataAuditor().print(this.getRequestContext(), JdbcEngine.getErrorMessage(e, this.myDataSource.getName(), this.myDataSource.getFamilyId()));
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performExplicitSchemaSwitch(@NotNull Connection connection, @NotNull String setSchemaSql) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine", "performExplicitSchemaSwitch"));
        }
        if (setSchemaSql == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setSchemaSql", "com/intellij/database/console/JdbcEngine", "performExplicitSchemaSwitch"));
        }
        Statement statement = null;
        try {
            statement = this.openStatement(connection, setSchemaSql, false);
            statement.execute(setSchemaSql);
            boolean bl = true;
            this.closeStatement(statement);
            return bl;
        }
        catch (SQLException e) {
            try {
                this.printWarnings(statement);
                this.getRequestContext().reportException(e, statement);
                this.closeStatement(statement);
            }
            catch (Throwable throwable) {
                this.closeStatement(statement);
                throw throwable;
            }
        }
        return false;
    }

    @Nullable
    private RowQueryData buildDataForSelect(@NotNull DataRequest.ConditionQueryRequest r) throws Exception {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/console/JdbcEngine", "buildDataForSelect"));
        }
        RowQueryData data = r.rowQueryData;
        String sql = data.getSql();
        String alias = DbImplUtil.findFreeAlias(this.getProject(), this.myDialect, sql, "a");
        DdlBuilder builder = DbImplUtil.wrapSelectQuery(this.getProject(), this.myDialect, sql, alias);
        if (builder == null) {
            return null;
        }
        builder.space().keyword("WHERE").space();
        Connection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        List<ColumnQueryData> newData = DbImplUtil.composeWhereConditionWithParameters(builder, data, alias, this.myDialect);
        return new RowQueryData(newData, data.getRow(), builder.getStatement());
    }

    @NotNull
    public QueryData buildDataForDelete(@NotNull DataRequest.DeleteRequest r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/console/JdbcEngine", "buildDataForDelete"));
        }
        List<RowMutation> mutations = r.context.getMutations();
        ArrayList rowQueryData = ContainerUtil.newArrayList();
        for (RowMutation mutation : mutations) {
            DdlBuilder builder = DbImplUtil.createBuilderForExec(this.myDialect);
            List<ColumnQueryData> filtered = DbImplUtil.getWhereClauseColumns(r.context.getTable(), mutation.getData(), this.myDialect);
            builder.keyword("DELETE").space().keyword("FROM").space().qualifiedRef((DasObject)r.context.getTable()).space();
            builder.keyword("WHERE").space();
            List<ColumnQueryData> whereData = DbImplUtil.composeWhereConditionWithParameters(builder, filtered, null, this.myDialect);
            String sql = builder.getStatement();
            rowQueryData.add(new RowQueryData(whereData, mutation.getRow(), sql));
        }
        QueryData queryData = new QueryData(rowQueryData);
        if (queryData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "buildDataForDelete"));
        }
        return queryData;
    }

    @NotNull
    public QueryData buildDataForUpdate(@NotNull DataRequest.UpdateRequest r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/console/JdbcEngine", "buildDataForUpdate"));
        }
        DatabaseFamilyId familyId = this.myDialect.getFamilyId();
        boolean alias = !familyId.isSqlite() && !familyId.isPostgres() && !familyId.isTransactSql();
        ArrayList rowsData = ContainerUtil.newArrayList();
        List<RowMutation> mutations = r.context.getMutations();
        for (RowMutation mutation : mutations) {
            DataConsumer.Row row = mutation.getRow();
            List keyColumns = DbImplUtil.getWhereClauseColumns(r.context.getTable(), (List)ObjectUtils.assertNotNull(r.context.getColumns()), this.myDialect);
            DdlBuilder builder = DbImplUtil.createBuilderForExec(this.myDialect);
            builder.keyword("UPDATE").space().qualifiedRef((DasObject)r.context.getTable()).space();
            if (alias) {
                builder.alias("t").space();
            }
            builder.keyword("SET").space();
            boolean first = true;
            ArrayList columnsData = ContainerUtil.newArrayList();
            for (ColumnQueryData data : mutation.getData()) {
                DataConsumer.Column targetColumn = data.getColumn();
                if (!first) {
                    builder.symbol(",").space();
                } else {
                    first = false;
                }
                if (alias) {
                    builder.alias("t").symbol(".");
                }
                builder.identifier(targetColumn.name).space().symbol("=").space();
                Object value = data.getObject();
                if (value == ReservedCellValue.DEFAULT) {
                    builder.keyword("DEFAULT");
                    continue;
                }
                builder.symbol("?");
                columnsData.add(data);
            }
            builder.space().keyword("WHERE").space();
            String s = alias ? "t" : null;
            List keyData = ContainerUtil.map(keyColumns, column -> new ColumnQueryData((DataConsumer.Column)column, column.getValue(row)));
            List<ColumnQueryData> whereData = DbImplUtil.composeWhereConditionWithParameters(builder, keyData, s, this.myDialect);
            String sql = builder.getStatement();
            columnsData.addAll(whereData);
            rowsData.add(new RowQueryData(columnsData, mutation.getRow(), sql));
        }
        QueryData queryData = new QueryData(rowsData);
        if (queryData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "buildDataForUpdate"));
        }
        return queryData;
    }

    @NotNull
    public QueryData buildDataForInsert(@NotNull DataRequest.InsertRequest r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/console/JdbcEngine", "buildDataForInsert"));
        }
        DatabaseDialectEx dialect = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect(this.myDataSource), (Object)GenericDialect.INSTANCE);
        ArrayList params2 = ContainerUtil.newArrayList();
        List<RowMutation> mutations = r.context.getMutations();
        DdlBuilder builder = DbImplUtil.createBuilderForExec(dialect);
        for (RowMutation mutation : mutations) {
            List<AutoValueDescriptor.DelegateDescriptor<ColumnQueryData>> delegateDescriptors = JdbcEngine.createDescriptors(mutation);
            Condition isDefault = d -> !d.isAutogenerated() && !d.hasDefault();
            List forInsert = ContainerUtil.filter(delegateDescriptors, (Condition)isDefault);
            List<String> placeholders = JdbcEngine.getPlaceholdersForInsert(delegateDescriptors, dialect);
            List<String> colNames = JdbcEngine.getColumnNamesForInsert(delegateDescriptors, dialect);
            dialect.sqlInsertInto(builder, r.context.getTable(), colNames, placeholders);
            String sql = builder.getStatement();
            params2.add(new RowQueryData(ContainerUtil.map((Collection)forInsert, AutoValueDescriptor.DelegateDescriptor::getDelegate), mutation.getRow(), sql));
            builder.clear();
        }
        QueryData queryData = new QueryData(params2);
        if (queryData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "buildDataForInsert"));
        }
        return queryData;
    }

    public void deleteRows(@NotNull DataRequest.DeleteRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/console/JdbcEngine", "deleteRows"));
        }
        this.executeUpdateStatement(request, ContainerUtil.list((Object[])new QueryData[]{this.buildDataForDelete(request)}));
    }

    public void updateRows(@NotNull DataRequest.UpdateRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/console/JdbcEngine", "updateRows"));
        }
        this.executeUpdateStatement(request, ContainerUtil.list((Object[])new QueryData[]{this.buildDataForUpdate(request)}));
    }

    public void insertRows(@NotNull DataRequest.InsertRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/console/JdbcEngine", "insertRows"));
        }
        this.executeUpdateStatement(request, ContainerUtil.list((Object[])new QueryData[]{this.buildDataForInsert(request)}));
    }

    @NotNull
    private static List<AutoValueDescriptor.DelegateDescriptor<ColumnQueryData>> createDescriptors(@NotNull RowMutation mutation) {
        if (mutation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutation", "com/intellij/database/console/JdbcEngine", "createDescriptors"));
        }
        DataConsumer.Row row = mutation.getRow();
        List list = JBIterable.from(mutation.getData()).map(data -> {
            DataConsumer.Column column = data.getColumn();
            Object value = column.getValue(row);
            boolean autogenerated = value == ReservedCellValue.GENERATED;
            boolean isDefault = value == ReservedCellValue.DEFAULT;
            return new AutoValueDescriptor.DelegateDescriptor<ColumnQueryData>((ColumnQueryData)data, autogenerated, isDefault);
        }).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "createDescriptors"));
        }
        return list;
    }

    public void executeUpdateStatement(@NotNull DataRequest request, @NotNull List<QueryData> infos) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/console/JdbcEngine", "executeUpdateStatement"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/database/console/JdbcEngine", "executeUpdateStatement"));
        }
        this.submitRequest(request, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            if (infos == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/database/console/JdbcEngine", "lambda$executeUpdateStatement$13"));
            }
            return this.executeUpdateStatementInner(infos);
        }));
    }

    private boolean executeConditionQueryRequest(@NotNull DataRequest.ConditionQueryRequest r) throws Exception {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/console/JdbcEngine", "executeConditionQueryRequest"));
        }
        RowQueryData data = this.buildDataForSelect(r);
        if (data == null) {
            return false;
        }
        return this.executeQueryInner(r, data.getSql(), (ThrowableNotNullFunction<Connection, Statement, Exception>)((ThrowableNotNullFunction)connection -> {
            this.getRequestContext().query.set(data.getSql());
            PreparedStatement statement = this.openPreparedStatement((Connection)connection, data.getSql());
            this.completeStatement(statement, data, 0);
            return statement;
        }));
    }

    private boolean executeQueryRequest(@NotNull DataRequest.QueryRequest r) throws Exception {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/console/JdbcEngine", "executeQueryRequest"));
        }
        return this.executeQueryInner(r, r.query, (ThrowableNotNullFunction<Connection, Statement, Exception>)((ThrowableNotNullFunction)connection -> {
            if (r == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/console/JdbcEngine", "lambda$executeQueryRequest$15"));
            }
            return this.openStatement((Connection)connection, r.query, JdbcEngine.willScrollResultSet(r.constraints));
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeUpdateStatementInner(@NotNull List<QueryData> queryData) throws Exception {
        if (queryData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryData", "com/intellij/database/console/JdbcEngine", "executeUpdateStatementInner"));
        }
        Connection connection = this.getConnection();
        if (connection == null) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        for (QueryData info : queryData) {
            sb.append(info.getFullSql());
        }
        int count = JdbcEngine.getExpectedUpdateCount(queryData);
        String sql = sb.toString();
        UnexpectedUpdatesGuard guard = connection.getAutoCommit() ? new AutoCommitGuard(connection, sql, count) : new AutoCommitOffGuard(connection, sql, count);
        try {
            this.startUpdate(sql);
            ArrayList updateCounts = ContainerUtil.newArrayList();
            for (QueryData data : queryData) {
                List<Integer> counts = this.executeUpdateStatementAndGetUpdateCounts(connection, data);
                if (counts == null) {
                    boolean bl = guard.updateComplete(null);
                    return bl;
                }
                updateCounts.addAll(counts);
            }
            int sum = updateCounts.stream().mapToInt(Integer::intValue).sum();
            this.getDataAuditor().updateCountReceived(this.getRequestContext(), sum);
            boolean bl = guard.updateComplete(updateCounts);
            return bl;
        }
        finally {
            this.endUpdate();
            guard.free();
            this.printWarnings(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private List<Integer> executeUpdateStatementAndGetUpdateCounts(@NotNull Connection connection, @NotNull QueryData data) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine", "executeUpdateStatementAndGetUpdateCounts"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/console/JdbcEngine", "executeUpdateStatementAndGetUpdateCounts"));
        }
        ArrayList updateCounts = ContainerUtil.newArrayListWithCapacity((int)data.size());
        PreparedStatement statement = null;
        try {
            for (RowQueryData rowInfo : data) {
                String sql = rowInfo.getSql();
                int escapeIdx = StringUtil.startsWithIgnoreCase((String)sql, (String)"update") ? 1 : (StringUtil.startsWithIgnoreCase((String)sql, (String)"delete") ? 0 : rowInfo.size());
                statement = this.openPreparedStatement(connection, sql);
                this.completeStatement(statement, rowInfo, escapeIdx);
                updateCounts.add(statement.executeUpdate());
                this.closeStatement(statement, false);
            }
        }
        catch (Exception e) {
            updateCounts = null;
            this.getRequestContext().reportException(e, statement);
        }
        finally {
            this.closeStatement(statement, false);
        }
        return updateCounts;
    }

    private void completeStatement(PreparedStatement statement, RowQueryData rowInfo, int escapeIdx) throws Exception {
        int idx = 0;
        for (ColumnQueryData updateData : rowInfo) {
            Object object = updateData.getObject();
            DbImplUtil.setStatementParameter(statement, updateData, object, this.myDialect, idx >= escapeIdx, ++idx);
        }
    }

    public static void handleException(@NotNull DataRequest.Context context, @NotNull Throwable th, @NotNull DataAuditor dataAuditor, @NotNull DatabaseSystem dataSource) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/console/JdbcEngine", "handleException"));
        }
        if (th == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "th", "com/intellij/database/console/JdbcEngine", "handleException"));
        }
        if (dataAuditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataAuditor", "com/intellij/database/console/JdbcEngine", "handleException"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/JdbcEngine", "handleException"));
        }
        if (th instanceof ProcessCanceledException) {
            return;
        }
        String message = JdbcEngine.getErrorMessage(th, dataSource.getName(), DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource));
        dataAuditor.error(context, message, null);
    }

    @NotNull
    public static String getErrorMessage(Throwable th, String sourceName, DatabaseFamilyId familyId) {
        StringBuilder sb = new StringBuilder();
        JdbcEngine.appendErrorMessage(sb, th, sourceName, familyId);
        String string = sb.toString().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "getErrorMessage"));
        }
        return string;
    }

    @NotNull
    public static <T extends AutoValueDescriptor> List<String> getColumnNamesForInsert(@NotNull Collection<T> descriptors, @NotNull DatabaseDialectEx dialect) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/database/console/JdbcEngine", "getColumnNamesForInsert"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/JdbcEngine", "getColumnNamesForInsert"));
        }
        List list = JdbcEngine.shouldParticipateInInsert(descriptors, dialect).map(ColumnDescriptor::getName).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "getColumnNamesForInsert"));
        }
        return list;
    }

    @NotNull
    public static <T extends AutoValueDescriptor> List<String> getPlaceholdersForInsert(@NotNull Collection<T> descriptors, @NotNull DatabaseDialectEx dialect) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/database/console/JdbcEngine", "getPlaceholdersForInsert"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/JdbcEngine", "getPlaceholdersForInsert"));
        }
        List list = JdbcEngine.shouldParticipateInInsert(descriptors, dialect).map(d -> d.isAutogenerated() || d.hasDefault() ? "DEFAULT" : "?").toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "getPlaceholdersForInsert"));
        }
        return list;
    }

    @NotNull
    private static <T extends AutoValueDescriptor> JBIterable<T> shouldParticipateInInsert(@NotNull Collection<T> descriptors, @NotNull DatabaseDialectEx dialect) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/database/console/JdbcEngine", "shouldParticipateInInsert"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/JdbcEngine", "shouldParticipateInInsert"));
        }
        JBIterable jBIterable = JBIterable.from(descriptors).filter(d -> {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/JdbcEngine", "lambda$shouldParticipateInInsert$17"));
            }
            return !d.isAutogenerated() || dialect.supportsInsertDefaultIntoAutoVal();
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "shouldParticipateInInsert"));
        }
        return jBIterable;
    }

    private static int getExpectedUpdateCount(@NotNull List<QueryData> data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/console/JdbcEngine", "getExpectedUpdateCount"));
        }
        return data.stream().mapToInt(QueryData::size).sum();
    }

    private static StringBuilder appendErrorMessage(@NotNull StringBuilder sb, @NotNull Throwable e, @NotNull String processName, @NotNull DatabaseFamilyId familyId) {
        String message;
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/console/JdbcEngine", "appendErrorMessage"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/JdbcEngine", "appendErrorMessage"));
        }
        if (processName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processName", "com/intellij/database/console/JdbcEngine", "appendErrorMessage"));
        }
        if (familyId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyId", "com/intellij/database/console/JdbcEngine", "appendErrorMessage"));
        }
        Throwable t = ExceptionUtil.getRootCause((Throwable)e);
        if (e != t && e instanceof SQLException && StringUtil.indexOf((CharSequence)sb, (CharSequence)(message = JdbcUtil.getMessage((Throwable)e))) == -1) {
            sb.append(JdbcUtil.getMessagePrefix((Throwable)e)).append(message).append("\n");
        }
        if (t instanceof SQLException) {
            SQLException next;
            message = JdbcUtil.getMessage((Throwable)t);
            if (StringUtil.indexOf((CharSequence)sb, (CharSequence)message) == -1) {
                sb.append(JdbcUtil.getMessagePrefix((Throwable)t)).append(message);
            }
            ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG);
            if (StringUtil.contains((CharSequence)sb, (CharSequence)"ORA-12705:")) {
                sb.append("\n").append(DatabaseMessages.message((String)"error.message.ora.nls", (Object[])new Object[]{processName}));
            }
            if ((next = ((SQLException)t).getNextException()) != null && next != t) {
                JdbcEngine.appendErrorMessage(sb.append("\n"), next, processName, familyId);
            }
        } else if (t instanceof RemoteException) {
            sb.append(t.toString());
            ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG);
        } else if (t instanceof EOFException && e instanceof RemoteException) {
            sb.append(processName).append(": process exited");
        } else if (t instanceof IOException) {
            sb.append(t.toString());
        } else if (t instanceof ExecutionException) {
            sb.append(JdbcUtil.getMessage((Throwable)t));
        } else if (t instanceof SuppressUserStackTrace) {
            sb.append(JdbcUtil.getMessage((Throwable)t));
            ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG);
        } else if (t instanceof UnsafeUpdateRolledBackException) {
            sb.append(t.getMessage());
        } else if (t instanceof OutOfMemoryError) {
            sb.append(DatabaseMessages.message((String)"error.message.remote.oomerror", (Object[])new Object[]{processName}));
            LOG.info(t);
        } else if (t instanceof RuntimeException && familyId.isDerby() && sb.length() > 0) {
            ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG);
        } else {
            sb.append(ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG));
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printResultSet(@NotNull ResultSet resultSet, int resultSetIndex, int start, int pageSize, int chunkSize, int[] rowCount) throws Exception {
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/database/console/JdbcEngine", "printResultSet"));
        }
        this.checkCanceled();
        DataRequest request = this.getRequestContext().request;
        DataConsumer handler = this.getDataConsumer();
        if (request instanceof DataRequest.IsolatedQueryRequest) {
            handler = (DataConsumer)((Object)request);
        }
        if (start < 0) {
            handler = new LastPageHandler(handler, start, pageSize);
            pageSize = -1;
        }
        RemoteResultSet remoteResultSet = (RemoteResultSet)RemoteUtil.castToRemoteNotNull((Object)resultSet, RemoteResultSet.class);
        DataConsumer.Column[] columnsDescr = JdbcEngine.getColumnDescriptors(resultSet, this.myDialect);
        handler.setColumns(this.getRequestContext(), resultSetIndex, columnsDescr, Math.max(1, start));
        rowCount[0] = 0;
        int rowNum = 0;
        boolean hasNext = true;
        ArrayList<DataConsumer.Row> rows = ContainerUtil.newArrayListWithCapacity((int)chunkSize);
        try {
            rowNum = remoteResultSet.scrollToPosition(0, start - 1);
            if (request instanceof DataRequest.RawQueryRequest) {
                while (hasNext = resultSet.next()) {
                    this.checkCanceled();
                    DataConsumer.Row row = JdbcEngine.getCurrentRow(resultSet, columnsDescr, rowNum++, this.myDialect);
                    handler.addRows(this.getRequestContext(), Collections.singletonList(row));
                    rowCount[0] = rowCount[0] + 1;
                    if (DbImplUtil.isPageSizeUnlimited(pageSize) || rowCount[0] < pageSize) continue;
                    break;
                }
                this.printWarnings(resultSet);
            } else {
                int maxLobLength = DatabaseSettings.getSettings().getMaxLobLength();
                while (hasNext) {
                    int rowsToLoad;
                    this.checkCanceled();
                    int n = rowsToLoad = DbImplUtil.isPageSizeUnlimited(pageSize) ? chunkSize : Math.min(chunkSize, pageSize - rowCount[0]);
                    if (rowsToLoad == 0) break;
                    List<Object[]> data = JdbcEngine.getObjects(resultSet, this.myDialect, this, maxLobLength, rowsToLoad);
                    this.printWarnings(resultSet);
                    hasNext = data.size() == rowsToLoad;
                    rowCount[0] = rowCount[0] + data.size();
                    for (Object[] rowData : data) {
                        rows.add(DataConsumer.Row.create(rowNum++, rowData));
                        if (rows.size() != chunkSize) continue;
                        handler.addRows(this.getRequestContext(), (List<DataConsumer.Row>)rows);
                        rows = new ArrayList<DataConsumer.Row>(chunkSize);
                    }
                }
                if (hasNext) {
                    hasNext = remoteResultSet.next();
                }
            }
        }
        finally {
            if (!rows.isEmpty()) {
                handler.addRows(this.getRequestContext(), (List<DataConsumer.Row>)rows);
            }
            if (start < 0) {
                rowCount[0] = ((LastPageHandler)handler).getRowCount();
            }
            try {
                if (hasNext && rowCount[0] != 0) {
                    ++rowNum;
                }
            }
            finally {
                handler.afterLastRowAdded(this.getRequestContext(), rowNum);
            }
        }
    }

    @NotNull
    public static List<Object[]> getObjects(@NotNull ResultSet resultSet, @NotNull DatabaseDialect dialect, @NotNull Object requestor, int maxLobLength, int rowsToLoad) throws Exception {
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/database/console/JdbcEngine", "getObjects"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/JdbcEngine", "getObjects"));
        }
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/database/console/JdbcEngine", "getObjects"));
        }
        RemoteResultSet remoteResultSet = (RemoteResultSet)RemoteUtil.castToRemoteNotNull((Object)resultSet, RemoteResultSet.class);
        List list = (List)RemoteUtil.handleRemoteResult((Object)remoteResultSet.getObjects(rowsToLoad, dialect.getClass().getSimpleName(), maxLobLength), List.class, (Object)requestor);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "getObjects"));
        }
        return list;
    }

    public static DataConsumer.Column[] getColumnDescriptors(@NotNull ResultSet resultSet, @NotNull DatabaseDialect dialect) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/database/console/JdbcEngine", "getColumnDescriptors"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/JdbcEngine", "getColumnDescriptors"));
        }
        ResultSetMetaData metaData = resultSet.getMetaData();
        int count = metaData.getColumnCount();
        DataConsumer.Column[] columnsDescr = new DataConsumer.Column[count];
        int columnNum = 0;
        for (int i2 = 1; i2 <= count; ++i2) {
            String name = null;
            try {
                name = metaData.getColumnLabel(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String typeName = null;
            try {
                typeName = metaData.getColumnTypeName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int type = 1111;
            try {
                type = metaData.getColumnType(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String clazz = null;
            try {
                clazz = metaData.getColumnClassName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String catalog = null;
            try {
                catalog = metaData.getCatalogName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String schema = null;
            try {
                schema = metaData.getSchemaName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String table = null;
            try {
                table = metaData.getTableName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int precision = -1;
            try {
                precision = metaData.getPrecision(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int scale = -1;
            try {
                scale = metaData.getScale(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dialect.getFamilyId().isMysql()) {
                if (type == 91 && "YEAR".equals(typeName) && "java.lang.Short".equals(clazz)) {
                    type = 5;
                }
            } else if (dialect.getFamilyId().isPostgres()) {
                if (Arrays.asList("bit", "varbit", "tid", "uuid").contains(typeName)) {
                    type = 12;
                } else if ("money".equals(typeName)) {
                    type = 1111;
                }
            } else if (dialect.getFamilyId().isOracle()) {
                if (type == -101 || type == -102) {
                    type = 93;
                } else if (type == 2007) {
                    type = 12;
                }
            } else if (dialect.getFamilyId().isSqlite()) {
                catalog = "";
            }
            columnsDescr[i2 - 1] = new DataConsumer.Column(columnNum++, name, type, typeName, clazz, precision, scale, catalog, schema, table);
        }
        return columnsDescr;
    }

    private void checkCanceled() {
        if (this.myState.get() == State.CANCELED) {
            throw new ProcessCanceledException();
        }
    }

    @NotNull
    private Statement openStatement(@NotNull Connection connection, @NotNull String sql, boolean withScrollableResultSet) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine", "openStatement"));
        }
        if (sql == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sql", "com/intellij/database/console/JdbcEngine", "openStatement"));
        }
        if (ourPendingStatements.get(this) != null) {
            throw new AssertionError();
        }
        this.getRequestContext().query.set(sql);
        this.getDataAuditor().requestStarted(this.getRequestContext());
        Statement statement = this.openStatement(connection, withScrollableResultSet);
        this.changeCurrentStatement(null, statement);
        Statement statement2 = statement;
        if (statement2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "openStatement"));
        }
        return statement2;
    }

    @NotNull
    private Statement openStatement(@NotNull Connection connection, boolean withScrollableResultSet) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine", "openStatement"));
        }
        Statement statement = withScrollableResultSet && Registry.is((String)"database.scrollable.result.sets") ? this.openStatementWithScrollableResultSetType(connection) : null;
        Statement statement2 = statement != null ? statement : connection.createStatement();
        if (statement2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "openStatement"));
        }
        return statement2;
    }

    @Nullable
    private Statement openStatementWithScrollableResultSetType(@NotNull Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine", "openStatementWithScrollableResultSetType"));
        }
        try {
            if (this.myFamilyId.isDb2()) {
                return null;
            }
            if (connection.getMetaData().supportsResultSetType(1004)) {
                return connection.createStatement(1004, 1007);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to create a statement with a scrollable result set type", (Throwable)e);
        }
        return null;
    }

    @NotNull
    private PreparedStatement openPreparedStatement(@NotNull Connection connection, @NotNull String sql) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine", "openPreparedStatement"));
        }
        if (sql == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sql", "com/intellij/database/console/JdbcEngine", "openPreparedStatement"));
        }
        if (ourPendingStatements.get(this) != null) {
            throw new AssertionError();
        }
        PreparedStatement statement = connection.prepareStatement(sql);
        this.changeCurrentStatement(null, statement);
        PreparedStatement preparedStatement = statement;
        if (preparedStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "openPreparedStatement"));
        }
        return preparedStatement;
    }

    private void startUpdate(@NotNull String sql) {
        if (sql == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sql", "com/intellij/database/console/JdbcEngine", "startUpdate"));
        }
        this.getRequestContext().query.set(sql);
        this.getDataAuditor().requestStarted(this.getRequestContext());
    }

    private void endUpdate() {
        try {
            this.getDataAuditor().requestFinished(this.getRequestContext());
        }
        finally {
            this.getRequestContext().query.set(null);
        }
    }

    private void closeStatement(Statement statement) {
        this.closeStatement(statement, true);
    }

    private void closeStatement(Statement statement, boolean shouldEndUpdate) {
        try {
            if (statement == null) {
                return;
            }
            this.changeCurrentStatement(statement, null);
            this.closeStatementWithReport(statement);
        }
        finally {
            if (shouldEndUpdate) {
                this.endUpdate();
            }
        }
    }

    private void closeStatementWithReport(@NotNull Statement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/console/JdbcEngine", "closeStatementWithReport"));
        }
        try {
            if (this.myConnection != null) {
                statement.close();
            }
        }
        catch (Exception e) {
            this.getRequestContext().reportException(e, statement);
        }
    }

    @Override
    protected void releaseConnection() {
        Connection connection = this.myConnection;
        this.myConnection = null;
        try {
            if (!connection.getAutoCommit()) {
                connection.rollback();
            }
        }
        catch (Exception exception) {
        }
        finally {
            JdbcUtil.closeConnectionSafe((Connection)connection);
        }
    }

    private static DataConsumer.Row getCurrentRow(ResultSet resultSet, DataConsumer.Column[] columnsDescr, int rowNum, DatabaseDialect dialect) throws SQLException {
        Object[] objects = new Object[columnsDescr.length];
        Set<Integer> longs = JdbcEngine.findOracleLongs(dialect, columnsDescr);
        for (Integer aLong : longs) {
            objects[aLong.intValue() - 1] = resultSet.getObject(aLong);
        }
        for (int i2 = 1; i2 <= columnsDescr.length; ++i2) {
            if (longs.contains(i2)) continue;
            DataConsumer.Column column = columnsDescr[i2 - 1];
            int jdbcType = ExtractorsUtil.guessJdbcType(column);
            objects[i2 - 1] = JdbcEngine.getObject(resultSet, dialect, column, i2, jdbcType);
        }
        return DataConsumer.Row.create(rowNum, objects);
    }

    private static Object getObject(ResultSet resultSet, DatabaseDialect dialect, DataConsumer.Column column, int index, int jdbcType) throws SQLException {
        if (jdbcType == 2004 || jdbcType == 2005) {
            return JdbcEngine.getBlobOrClob(resultSet, index, jdbcType);
        }
        if (dialect.getFamilyId().isPostgres() && ("bit".equals(column.typeName) || "varbit".equals(column.typeName))) {
            return resultSet.getString(index);
        }
        return resultSet.getObject(index);
    }

    private static Object getBlobOrClob(ResultSet resultSet, int i2, int jdbcType) throws SQLException {
        try {
            if (jdbcType == 2004) {
                return resultSet.getBlob(i2);
            }
            return resultSet.getClob(i2);
        }
        catch (SQLException e) {
            return resultSet.getObject(i2);
        }
    }

    private static Set<Integer> findOracleLongs(DatabaseDialect dialect, DataConsumer.Column[] columns) throws SQLException {
        if (!dialect.getFamilyId().isOracle()) {
            return ContainerUtil.set((Object[])new Integer[0]);
        }
        HashSet result = ContainerUtil.newHashSet();
        for (int i2 = 1; i2 <= columns.length; ++i2) {
            if (columns[i2 - 1].type != -1) continue;
            result.add(i2);
        }
        return result;
    }

    private static class UnsafeUpdateRolledBackException
    extends Exception {
        public UnsafeUpdateRolledBackException(String message) {
            super(message);
        }
    }

    private static class SavepointHelper {
        final RemoteSavepoint mySavepoint;
        final Connection myGuardedConnection;

        SavepointHelper(@Nullable Connection connection) {
            this.myGuardedConnection = connection;
            this.mySavepoint = this.createSavepoint();
        }

        boolean isAvailable() {
            return this.mySavepoint != null;
        }

        public void free(boolean rollback) throws Exception {
            RemoteConnection connection;
            RemoteConnection remoteConnection = connection = this.myGuardedConnection == null ? null : (RemoteConnection)RemoteUtil.castToRemote((Object)this.myGuardedConnection, RemoteConnection.class);
            if (connection == null || this.mySavepoint == null) {
                return;
            }
            try {
                if (rollback) {
                    connection.rollback(this.mySavepoint);
                }
            }
            catch (SQLException e) {
                throw new SQLException(DatabaseMessages.message((String)"message.text.error.failed.to.rollback.to.a.savepoint", (Object[])new Object[0]), e);
            }
            finally {
                try {
                    connection.releaseSavepoint(this.mySavepoint);
                }
                catch (SQLException sQLException) {}
            }
        }

        @Nullable
        private RemoteSavepoint createSavepoint() {
            RemoteConnection connection;
            RemoteConnection remoteConnection = connection = this.myGuardedConnection == null ? null : (RemoteConnection)RemoteUtil.castToRemote((Object)this.myGuardedConnection, RemoteConnection.class);
            if (connection == null) {
                return null;
            }
            try {
                if (!connection.getMetaData().supportsSavepoints()) {
                    return null;
                }
                return connection.setSavepoint();
            }
            catch (Exception e) {
                LOG.info("Exception while setting an unnamed savepoint", (Throwable)e);
                return null;
            }
        }
    }

    class AutoCommitOffGuard
    extends UnexpectedUpdatesGuard {
        private final SavepointHelper mySavepoint;
        private boolean myRollback;

        public AutoCommitOffGuard(@NotNull Connection connection, String statement, int expectedUpdateCount) {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine$AutoCommitOffGuard", "<init>"));
            }
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/console/JdbcEngine$AutoCommitOffGuard", "<init>"));
            }
            super(statement, expectedUpdateCount);
            this.myRollback = true;
            this.mySavepoint = new SavepointHelper(connection);
        }

        @Override
        public boolean updateComplete(@Nullable List<Integer> updateCounts) {
            Trinity<Integer, Integer, Integer> counts = updateCounts != null ? this.getActualExpectedAndStatementNumber(updateCounts) : null;
            boolean unexpectedUpdateCount = updateCounts != null && this.hasUnexpectedUpdateCount(counts);
            boolean bl = this.myRollback = updateCounts == null || unexpectedUpdateCount;
            if (unexpectedUpdateCount) {
                if (this.mySavepoint.isAvailable()) {
                    this.reportChangesWillBeRolledBack(counts);
                } else {
                    this.reportUnexpectedUpdateCount(counts);
                }
            }
            return !this.myRollback;
        }

        @Override
        public void free() throws Exception {
            this.mySavepoint.free(this.myRollback);
        }

        private void reportUnexpectedUpdateCount(@NotNull Trinity<Integer, Integer, Integer> trinity) {
            if (trinity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trinity", "com/intellij/database/console/JdbcEngine$AutoCommitOffGuard", "reportUnexpectedUpdateCount"));
            }
            String message = DatabaseMessages.message((String)"message.text.error.unexpected.update.count", (Object[])new Object[0]) + this.getDiffString(trinity) + ". Rollback the current transaction to undo changes made by: \n" + this.myStatement;
            JdbcEngine.this.getDataAuditor().print(JdbcEngine.this.getRequestContext(), message);
        }
    }

    class AutoCommitGuard
    extends UnexpectedUpdatesGuard {
        final Connection myGuardedConnection;
        private boolean myRollback;

        public AutoCommitGuard(@NotNull Connection connection, String statement, int expectedUpdateCount) throws SQLException {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine$AutoCommitGuard", "<init>"));
            }
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/console/JdbcEngine$AutoCommitGuard", "<init>"));
            }
            super(statement, expectedUpdateCount);
            this.myRollback = true;
            this.myGuardedConnection = connection;
            this.myGuardedConnection.setAutoCommit(false);
        }

        @Override
        public boolean updateComplete(@Nullable List<Integer> updateCounts) {
            Trinity<Integer, Integer, Integer> counts = updateCounts != null ? this.getActualExpectedAndStatementNumber(updateCounts) : null;
            boolean unexpectedUpdateCount = this.hasUnexpectedUpdateCount(counts);
            boolean bl = this.myRollback = updateCounts == null || unexpectedUpdateCount;
            if (unexpectedUpdateCount) {
                this.reportChangesWillBeRolledBack(counts);
            }
            return !this.myRollback;
        }

        @Override
        public void free() throws Exception {
            if (this.myRollback) {
                this.myGuardedConnection.rollback();
            } else {
                this.myGuardedConnection.commit();
            }
            this.myGuardedConnection.setAutoCommit(true);
        }
    }

    private abstract class UnexpectedUpdatesGuard {
        protected final String myStatement;
        private final int myExpectedUpdateCount;

        public UnexpectedUpdatesGuard(String statement, int expectedUpdateCount) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/console/JdbcEngine$UnexpectedUpdatesGuard", "<init>"));
            }
            this.myStatement = statement;
            this.myExpectedUpdateCount = expectedUpdateCount;
        }

        public abstract boolean updateComplete(@Nullable List<Integer> var1);

        public abstract void free() throws Exception;

        protected final boolean hasUnexpectedUpdateCount(@Nullable Trinity<Integer, Integer, Integer> trinity) {
            return trinity != null && !Comparing.equal((Object)trinity.getFirst(), (Object)trinity.getSecond());
        }

        @NotNull
        protected final Trinity<Integer, Integer, Integer> getActualExpectedAndStatementNumber(@NotNull List<Integer> updateCounts) {
            if (updateCounts == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateCounts", "com/intellij/database/console/JdbcEngine$UnexpectedUpdatesGuard", "getActualExpectedAndStatementNumber"));
            }
            int sum = 0;
            int size = updateCounts.size();
            for (int i2 = 0; i2 < size; ++i2) {
                Integer count = updateCounts.get(i2);
                if (count > 1 && size > 1) {
                    Trinity trinity = Trinity.create((Object)count, (Object)1, (Object)(i2 + 1));
                    if (trinity == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine$UnexpectedUpdatesGuard", "getActualExpectedAndStatementNumber"));
                    }
                    return trinity;
                }
                sum += count.intValue();
            }
            Trinity trinity = Trinity.create((Object)sum, (Object)this.myExpectedUpdateCount, null);
            if (trinity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine$UnexpectedUpdatesGuard", "getActualExpectedAndStatementNumber"));
            }
            return trinity;
        }

        protected final void reportChangesWillBeRolledBack(@NotNull Trinity<Integer, Integer, Integer> trinity) {
            if (trinity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trinity", "com/intellij/database/console/JdbcEngine$UnexpectedUpdatesGuard", "reportChangesWillBeRolledBack"));
            }
            String message = DatabaseMessages.message((String)"message.text.error.unexpected.update.count", (Object[])new Object[0]) + this.getDiffString(trinity) + "Changes will be rolled back. SQL: \n" + this.myStatement;
            JdbcEngine.this.getRequestContext().reportException(new UnsafeUpdateRolledBackException(message), null);
        }

        @NotNull
        protected final String getDiffString(@NotNull Trinity<Integer, Integer, Integer> trinity) {
            if (trinity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trinity", "com/intellij/database/console/JdbcEngine$UnexpectedUpdatesGuard", "getDiffString"));
            }
            int actual = (Integer)trinity.getFirst();
            int expected = (Integer)trinity.getSecond();
            Integer statementNumber = (Integer)trinity.getThird();
            String diffString = (statementNumber == null ? "" : " in statement %s") + " (Actual: %s, Expected: %s). ";
            String string = statementNumber == null ? String.format(diffString, actual, expected) : String.format(diffString, statementNumber, actual, expected);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine$UnexpectedUpdatesGuard", "getDiffString"));
            }
            return string;
        }
    }

    private static class LastPageHandler
    implements DataConsumer {
        private final DataConsumer delegate;
        private int resultSetIndex;
        private DataConsumer.Column[] columnInfos;
        private RowsCyclicBuffer myBuffer;

        public LastPageHandler(DataConsumer handler, int start, int size) {
            this.delegate = handler;
            this.myBuffer = new RowsCyclicBuffer(Math.max(size, -start));
        }

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column[] infos, int firstRowNum) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/console/JdbcEngine$LastPageHandler", "setColumns"));
            }
            this.resultSetIndex = resultSetIndex;
            this.columnInfos = infos;
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<DataConsumer.Row> rows) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/console/JdbcEngine$LastPageHandler", "addRows"));
            }
            this.myBuffer.addRows(rows);
        }

        @Override
        public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/console/JdbcEngine$LastPageHandler", "afterLastRowAdded"));
            }
            List<DataConsumer.Row> rows = this.myBuffer.getRows();
            if (rows.isEmpty()) {
                this.delegate.setColumns(context, this.resultSetIndex, this.columnInfos, 0);
                this.delegate.afterLastRowAdded(context, 0);
                return;
            }
            this.delegate.setColumns(context, this.resultSetIndex, this.columnInfos, rows.get((int)0).rowNum);
            this.delegate.addRows(context, rows);
            this.delegate.afterLastRowAdded(context, total);
        }

        public int getRowCount() {
            return this.myBuffer.getRows().size();
        }

        private static class RowsCyclicBuffer {
            private final DataConsumer.Row[] myBuffer;
            private int myFirstIdx = 0;
            private int myLastIdx = -1;

            public RowsCyclicBuffer(int bufferSize) {
                this.myBuffer = new DataConsumer.Row[bufferSize];
            }

            public void addRows(@NotNull Iterable<DataConsumer.Row> rows) {
                if (rows == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/console/JdbcEngine$LastPageHandler$RowsCyclicBuffer", "addRows"));
                }
                for (DataConsumer.Row row : rows) {
                    if (this.myLastIdx != -1 && this.nextIdx(this.myLastIdx) == this.myFirstIdx) {
                        this.myFirstIdx = this.nextIdx(this.myFirstIdx);
                    }
                    this.myLastIdx = this.nextIdx(this.myLastIdx);
                    this.myBuffer[this.myLastIdx] = row;
                }
            }

            @NotNull
            public List<DataConsumer.Row> getRows() {
                if (this.myLastIdx == -1) {
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine$LastPageHandler$RowsCyclicBuffer", "getRows"));
                    }
                    return list;
                }
                if (this.myFirstIdx == 0) {
                    List list = ContainerUtil.newArrayList((Object[])this.myBuffer, (int)0, (int)(this.myLastIdx + 1));
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine$LastPageHandler$RowsCyclicBuffer", "getRows"));
                    }
                    return list;
                }
                ArrayList rows = ContainerUtil.newArrayListWithCapacity((int)this.myBuffer.length);
                ImmutableList bufferAsList = ContainerUtil.immutableList((Object[])this.myBuffer);
                rows.addAll(bufferAsList.subList(this.myFirstIdx, this.myBuffer.length));
                rows.addAll(bufferAsList.subList(0, this.myLastIdx + 1));
                ArrayList arrayList = rows;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine$LastPageHandler$RowsCyclicBuffer", "getRows"));
                }
                return arrayList;
            }

            private int nextIdx(int idx) {
                return (idx + 1) % this.myBuffer.length;
            }
        }
    }

    private static enum State {
        IDLE,
        RUNNING,
        STREAMING,
        CANCELED;

    }
}

