/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvFormatter {
    private final CsvFormat myFormat;

    public CsvFormatter(@NotNull CsvFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/csv/CsvFormatter", "<init>"));
        }
        this.myFormat = format;
    }

    @NotNull
    public CsvFormat getFormat() {
        CsvFormat csvFormat = this.myFormat;
        if (csvFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/CsvFormatter", "getFormat"));
        }
        return csvFormat;
    }

    @NotNull
    public String formatValue(@Nullable Object value) {
        String string = this.formatValue(this.myFormat.dataRecord, value);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/CsvFormatter", "formatValue"));
        }
        return string;
    }

    @NotNull
    public String formatHeaderValue(@Nullable Object value) {
        String string = this.formatValue((CsvRecordFormat)ObjectUtils.notNull((Object)this.myFormat.headerRecord, (Object)this.myFormat.dataRecord), value);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/CsvFormatter", "formatHeaderValue"));
        }
        return string;
    }

    @NotNull
    public String valueSeparator() {
        String string = CsvFormatter.valueSeparator(this.myFormat.dataRecord);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/CsvFormatter", "valueSeparator"));
        }
        return string;
    }

    @NotNull
    public String headerValueSeparator() {
        String string = CsvFormatter.valueSeparator((CsvRecordFormat)ObjectUtils.notNull((Object)this.myFormat.headerRecord, (Object)this.myFormat.dataRecord));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/CsvFormatter", "headerValueSeparator"));
        }
        return string;
    }

    @NotNull
    public String recordSeparator() {
        String string = this.myFormat.dataRecord.recordSeparator;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/CsvFormatter", "recordSeparator"));
        }
        return string;
    }

    @NotNull
    public String formatRecord(@NotNull List<?> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/csv/CsvFormatter", "formatRecord"));
        }
        String string = this.formatRecord(this.myFormat.dataRecord, values);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/CsvFormatter", "formatRecord"));
        }
        return string;
    }

    public String formatHeader(@NotNull List<?> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/csv/CsvFormatter", "formatHeader"));
        }
        return this.formatRecord((CsvRecordFormat)ObjectUtils.notNull((Object)this.myFormat.headerRecord, (Object)this.myFormat.dataRecord), values);
    }

    public boolean requiresRowNumbers() {
        return this.myFormat.rowNumbers;
    }

    @NotNull
    protected String valueToRawText(@Nullable Object value) {
        String string = String.valueOf(value);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/CsvFormatter", "valueToRawText"));
        }
        return string;
    }

    @NotNull
    private String formatRecord(@NotNull CsvRecordFormat recordTemplate, @NotNull List<?> values) {
        if (recordTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recordTemplate", "com/intellij/database/csv/CsvFormatter", "formatRecord"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/csv/CsvFormatter", "formatRecord"));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtil.notNullize((String)recordTemplate.prefix));
        for (Object value : values) {
            sb.append(this.formatValue(recordTemplate, value)).append(CsvFormatter.valueSeparator(recordTemplate));
        }
        sb.setLength(values.isEmpty() ? sb.length() : sb.length() - CsvFormatter.valueSeparator(recordTemplate).length());
        sb.append(StringUtil.notNullize((String)recordTemplate.suffix));
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/CsvFormatter", "formatRecord"));
        }
        return string;
    }

    @NotNull
    private String formatValue(@NotNull CsvRecordFormat recordTemplate, @Nullable Object value) {
        if (recordTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recordTemplate", "com/intellij/database/csv/CsvFormatter", "formatValue"));
        }
        String valueText = value == null ? recordTemplate.nullText : this.valueToRawText(value);
        valueText = recordTemplate.trimWhitespace ? StringUtil.trimLeading((String)StringUtil.trimTrailing((String)valueText)) : valueText;
        CsvRecordFormat.QuotationPolicy quotationPolicy = recordTemplate.quotationPolicy;
        CsvRecordFormat.Quotes quotes = null;
        if (quotationPolicy == CsvRecordFormat.QuotationPolicy.ALWAYS) {
            quotes = (CsvRecordFormat.Quotes)ContainerUtil.getFirstItem(recordTemplate.quotes);
        } else if (quotationPolicy == CsvRecordFormat.QuotationPolicy.AS_NEEDED) {
            if (CsvFormatter.shouldQuote(recordTemplate, valueText)) {
                quotes = (CsvRecordFormat.Quotes)ContainerUtil.getFirstItem(recordTemplate.quotes);
            }
        } else {
            throw new AssertionError((Object)("Unhandled quotation policy: " + (Object)((Object)quotationPolicy)));
        }
        String string = quotes != null ? quotes.leftQuote + CsvFormatter.escapeQuotes(valueText, quotes) + quotes.rightQuote : valueText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/CsvFormatter", "formatValue"));
        }
        return string;
    }

    @NotNull
    private static String escapeQuotes(@NotNull CharSequence s, @NotNull CsvRecordFormat.Quotes quotes) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/csv/CsvFormatter", "escapeQuotes"));
        }
        if (quotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotes", "com/intellij/database/csv/CsvFormatter", "escapeQuotes"));
        }
        String[] escapedQuotes = new String[]{quotes.leftQuoteEscaped, quotes.rightQuoteEscaped};
        String[] unescapedQuotes = new String[]{quotes.leftQuote, quotes.rightQuote};
        String string = StringUtil.replace((String)s.toString(), (String[])unescapedQuotes, (String[])escapedQuotes);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/CsvFormatter", "escapeQuotes"));
        }
        return string;
    }

    @NotNull
    private static String valueSeparator(@NotNull CsvRecordFormat template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/csv/CsvFormatter", "valueSeparator"));
        }
        String string = template.valueSeparator;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/CsvFormatter", "valueSeparator"));
        }
        return string;
    }

    private static boolean shouldQuote(@NotNull CsvRecordFormat recordTemplate, @NotNull String valueText) {
        if (recordTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recordTemplate", "com/intellij/database/csv/CsvFormatter", "shouldQuote"));
        }
        if (valueText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueText", "com/intellij/database/csv/CsvFormatter", "shouldQuote"));
        }
        return StringUtil.contains((CharSequence)valueText, (CharSequence)recordTemplate.valueSeparator) || StringUtil.contains((CharSequence)valueText, (CharSequence)recordTemplate.recordSeparator) || StringUtil.isNotEmpty((String)recordTemplate.prefix) && StringUtil.contains((CharSequence)valueText, (CharSequence)recordTemplate.prefix) || StringUtil.isNotEmpty((String)recordTemplate.suffix) && StringUtil.contains((CharSequence)valueText, (CharSequence)recordTemplate.suffix);
    }
}

