/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.registry;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.PgNumber2Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.dialects.PostgresDialect;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class PostgresDomains
extends DomainRegistry {
    private static final double MAX_REAL = 1.0E37;
    private static final double MIN_REAL = 1.0E-37;
    private static final double MAX_DOUBLE = 1.0E308;
    private static final double MIN_DOUBLE = 1.0E-307;
    private static final int MAX_FRACTION = 6;
    private static final int MAX_CHAR = 0xA00000;
    private static final int MAX_BIT = 0x5000000;
    private static final int MAX_PRECISION = 1000;
    private static final int MONEY_SCALE = 2;

    public PostgresDomains() {
        super(PostgresDialect.INSTANCE);
        this.add(new MyZonedDomain(new FractionDomain("timestamp with time zone", ConversionPoint.TIMESTAMP_WITH_TIMEZONE, PhysicalDomainType.TIMESTAMP, 6, 6, true), "timestamp"));
        this.add(new MyZonedDomain(new FractionDomain("time with time zone", ConversionPoint.TIME_WITH_TIMEZONE, PhysicalDomainType.TIME, 6, 6, true), "TIME"));
        this.add(new PgNumber2Domain("numeric", ConversionPoint.BIG_DECIMAL, 1000, 1000, true));
        this.add(new Number2Domain("money", ConversionPoint.MONEY, 1000, 2, false));
        this.add(new PgNumber2Domain("decimal", ConversionPoint.BIG_DECIMAL, 1000, 1000, true));
        this.add(new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("serial", ConversionPoint.SERIAL_NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("int4", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new IntegerDomain("smallserial", ConversionPoint.SERIAL_NUMBER, -32768.0, 32767.0));
        this.add(new IntegerDomain("int2", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new IntegerDomain("bigserial", ConversionPoint.SERIAL_NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new IntegerDomain("int8", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new FloatDomain("double precision", ConversionPoint.DOUBLE_PRECISION, 1.0E-307, 1.0E308));
        this.add(new FloatDomain("float8", ConversionPoint.DOUBLE_PRECISION, 1.0E-307, 1.0E308));
        this.add(new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, 1.0E-37, 1.0E37));
        this.add(new FloatDomain("float4", ConversionPoint.SINGLE_PRECISION, 1.0E-37, 1.0E37));
        this.add(new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE));
        this.add(new MyTextPreferrableDomain("int4range", ConversionPoint.NUMBER_RANGE, PhysicalDomainType.TEXT));
        this.add(new MyTextPreferrableDomain("int8range", ConversionPoint.NUMBER_RANGE, PhysicalDomainType.TEXT));
        this.add(new MyTextPreferrableDomain("numrange", ConversionPoint.NUMBER_RANGE, PhysicalDomainType.TEXT));
        this.add(new SimpleDomain("json", ConversionPoint.JSON, PhysicalDomainType.TEXT));
        this.add(new MyTextPreferrableDomain("daterange", ConversionPoint.DATE_RANGE, PhysicalDomainType.TEXT));
        this.add(new MyTextPreferrableDomain("tsrange", ConversionPoint.TIMESTAMP_RANGE, PhysicalDomainType.TEXT));
        this.add(new MyTextPreferrableDomain("tstzrange", ConversionPoint.TIMESTAMP_TZ_RANGE, PhysicalDomainType.TEXT));
        this.add(new MyTextPreferrableDomain("point", ConversionPoint.POINT, PhysicalDomainType.TEXT));
        this.add(new MyTextPreferrableDomain("interval", ConversionPoint.INTERVAL, PhysicalDomainType.TEXT));
        this.add(new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 6, 6, true));
        this.add(new FractionDomain("timestamptz", ConversionPoint.TIMESTAMP_WITH_TIMEZONE, PhysicalDomainType.TIMESTAMP, 6, 6, true));
        this.add(new FractionDomain("time", ConversionPoint.TIME, PhysicalDomainType.TIME, 6, 6, true));
        this.add(new FractionDomain("timetz", ConversionPoint.TIME_WITH_TIMEZONE, PhysicalDomainType.TIME, 6, 6, true));
        this.add(new TextDomain("text", ConversionPoint.TEXT, Integer.MAX_VALUE));
        this.add(new TextDomain("tid", ConversionPoint.TEXT_ID, Integer.MAX_VALUE));
        this.add(new TextDomain("char", ConversionPoint.CHAR, 0xA00000L, -1L, true));
        this.add(new TextDomain("bpchar", ConversionPoint.CHAR, 0xA00000L, -1L, true));
        this.add(new TextDomain("character", ConversionPoint.CHAR, 0xA00000L, -1L, true));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, 0xA00000L, -1L, true));
        this.add(new TextDomain("character varying", ConversionPoint.VARCHAR, 0xA00000L, -1L, true));
        this.add(new BooleanDomain("boolean", ConversionPoint.BOOLEAN));
        this.add(new BooleanDomain("bool", ConversionPoint.BOOLEAN));
        this.add(new BinaryDomain("bytea", ConversionPoint.BLOB, Integer.MAX_VALUE));
        this.add(new TextDomain("bit", ConversionPoint.BINARY_STRING, 0x5000000L, -1L, true));
        this.add(new TextDomain("bit varying", ConversionPoint.BINARY_STRING, 0x5000000L, -1L, true));
        this.add(new TextDomain("xml", ConversionPoint.XML, Integer.MAX_VALUE));
        this.add(new SimpleDomain("uuid", ConversionPoint.UUID, PhysicalDomainType.TEXT));
    }

    private static class MyZonedDomain
    extends FractionDomain {
        private final String myPrefix;

        public MyZonedDomain(@NotNull FractionDomain domain, @NotNull String prefix) {
            if (domain == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/registry/PostgresDomains$MyZonedDomain", "<init>"));
            }
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/database/data/types/registry/PostgresDomains$MyZonedDomain", "<init>"));
            }
            super(domain.simpleName(), domain.getPoint(), domain.getDomainType(), domain.getMax(), domain.getDefaultValue(), true);
            this.myPrefix = prefix;
        }

        @Override
        @NotNull
        public Domain narrow(@NotNull Domain domain) {
            if (domain == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/registry/PostgresDomains$MyZonedDomain", "narrow"));
            }
            MyZonedDomain myZonedDomain = new MyZonedDomain((FractionDomain)super.narrow(domain), this.myPrefix);
            if (myZonedDomain == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/registry/PostgresDomains$MyZonedDomain", "narrow"));
            }
            return myZonedDomain;
        }

        @Override
        @NotNull
        public Domain narrow(@NotNull SizeProvider provider) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/data/types/registry/PostgresDomains$MyZonedDomain", "narrow"));
            }
            MyZonedDomain myZonedDomain = new MyZonedDomain((FractionDomain)super.narrow(provider), this.myPrefix);
            if (myZonedDomain == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/registry/PostgresDomains$MyZonedDomain", "narrow"));
            }
            return myZonedDomain;
        }

        @Override
        @NotNull
        public String name() {
            String string = this.shouldParametrize() ? StringUtil.toUpperCase((String)this.myPrefix) + "(" + this.getMax() + ") WITH TIME ZONE" : super.name();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/registry/PostgresDomains$MyZonedDomain", "name"));
            }
            return string;
        }
    }

    private static class MyTextPreferrableDomain
    extends SimpleDomain
    implements TextDomain.TextPreferrable {
        public MyTextPreferrableDomain(@NotNull String name, @NotNull ConversionPoint descriptor, @NotNull PhysicalDomainType type) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/data/types/registry/PostgresDomains$MyTextPreferrableDomain", "<init>"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/registry/PostgresDomains$MyTextPreferrableDomain", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/data/types/registry/PostgresDomains$MyTextPreferrableDomain", "<init>"));
            }
            super(name, descriptor, type);
        }

        @Override
        @NotNull
        public LogicalType getFakeType() {
            LogicalType logicalType = LogicalType.TEXT;
            if (logicalType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/registry/PostgresDomains$MyTextPreferrableDomain", "getFakeType"));
            }
            return logicalType;
        }

        @Override
        @NotNull
        public Compatibility getCompatibility(@NotNull Domain domain) {
            if (domain == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/registry/PostgresDomains$MyTextPreferrableDomain", "getCompatibility"));
            }
            Compatibility compatibility = domain instanceof MyTextPreferrableDomain ? (StringUtil.equals((CharSequence)this.simpleName(), (CharSequence)domain.simpleName()) ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.uncompatible()) : super.getCompatibility(domain);
            if (compatibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/registry/PostgresDomains$MyTextPreferrableDomain", "getCompatibility"));
            }
            return compatibility;
        }
    }
}

