/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DataSource;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.dbm.common.IntrospectionScope;
import com.intellij.dbm.common.IntrospectionScopes;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDataSource
extends DataSource {
    private boolean myReadOnly;
    private String myUniqueId;
    @NotNull
    private String myName = "";
    private String myComment;
    private boolean myGlobal;

    public void init() {
        if (this.getUniqueId() == null) {
            this.myUniqueId = UUID.randomUUID().toString();
        }
    }

    protected void setUniqueId(String uniqueId) {
        this.myUniqueId = uniqueId;
    }

    @NotNull
    public IntrospectionScope getIntrospectionScope() {
        IntrospectionScope introspectionScope = IntrospectionScopes.EMPTY_SCOPE;
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/AbstractDataSource", "getIntrospectionScope"));
        }
        return introspectionScope;
    }

    @Nullable
    protected String getTablePattern() {
        return null;
    }

    @Nullable
    public RawConnectionConfig getConnectionConfig() {
        return null;
    }

    public boolean isReadOnly() {
        return this.myReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.myReadOnly = readOnly;
    }

    public String getUniqueId() {
        return this.myUniqueId;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/AbstractDataSource", "getName"));
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/AbstractDataSource", "setName"));
        }
        this.myName = name;
    }

    public boolean isGlobal() {
        return this.myGlobal;
    }

    public void setGlobal(boolean global) {
        this.myGlobal = global;
    }

    @Nullable
    public String getComment() {
        return this.myComment;
    }

    public void setComment(@Nullable String comment) {
        this.myComment = comment;
    }
}

