/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiManagerSpi;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDataSourceConfigurable<M extends DbPsiManagerSpi, T extends DatabaseSystem>
extends AbstractDatabaseConfigurable<T> {
    protected final M myManager;
    protected final T myDataSource;

    public AbstractDataSourceConfigurable(@NotNull M manager, @NotNull T dataSource, @NotNull Project project) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/dataSource/AbstractDataSourceConfigurable", "<init>"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/AbstractDataSourceConfigurable", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/AbstractDataSourceConfigurable", "<init>"));
        }
        super(project, dataSource);
        this.myManager = manager;
        this.myDataSource = dataSource;
    }

    @NotNull
    public T getDataSource() {
        T t = this.myDataSource;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/AbstractDataSourceConfigurable", "getDataSource"));
        }
        return t;
    }

    @Override
    @NotNull
    public T getTempTarget() {
        T t = this.getTempDataSource();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/AbstractDataSourceConfigurable", "getTempTarget"));
        }
        return t;
    }

    public DatabaseCredentials getSecretService() {
        return this.myController.getSecretService();
    }

    @NotNull
    public abstract T getTempDataSource();

    protected String createUniqueName(String baseName) {
        return this.myController != null ? this.myController.generateObjectName(this.getDataSource(), baseName) : DbUtil.createNewDataSourceName((Project)this.myProject, (String)baseName);
    }

    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        return this.isNewDataSource();
    }

    protected boolean isNewDataSource() {
        for (DbDataSource ds : this.myManager.getDataSources()) {
            if (ds.getDelegate() != this.myDataSource) continue;
            return false;
        }
        return true;
    }

    public void beforeShowNotify() {
    }

    public void onUserActivity() {
    }
}

