/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.project.ProjectKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class DataSourceStorageLocal {
    private static final String STATE_FILE_PATH = "dataSources.local.xml";
    public static final String COMPONENT_NAME = "dataSourceStorageLocal";
    private Element myState;

    public static DataSourceStorageLocal getGlobalInstance() {
        return (DataSourceStorageLocal)ServiceManager.getService(App.class);
    }

    public static DataSourceStorageLocal getProjectInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DataSourceStorageLocal", "getProjectInstance"));
        }
        return (DataSourceStorageLocal)ServiceManager.getService((Project)project, Prj.class);
    }

    public static DataSourceStorageLocal getInstance(Project project) {
        return project == null ? DataSourceStorageLocal.getGlobalInstance() : DataSourceStorageLocal.getProjectInstance(project);
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dataSource/DataSourceStorageLocal", "loadState"));
        }
        this.myState = state.clone();
    }

    public Element getState() {
        return this.myState;
    }

    @State(name="dataSourceStorageLocal", storages={@Storage(value="dataSources.local.xml", roamingType=RoamingType.DISABLED)})
    public static class Prj
    extends DataSourceStorageLocal
    implements PersistentStateComponent<Element> {
    }

    private static class DbeIgnoredFileProvider
    implements IgnoredFileProvider {
        private DbeIgnoredFileProvider() {
        }

        public boolean isIgnoredFile(@NotNull Project project, @NotNull FilePath filePath) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DataSourceStorageLocal$DbeIgnoredFileProvider", "isIgnoredFile"));
            }
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/database/dataSource/DataSourceStorageLocal$DbeIgnoredFileProvider", "isIgnoredFile"));
            }
            return ProjectKt.isEqualToProjectFileStorePath((Project)project, (String)filePath.getPath(), (String)DataSourceStorageLocal.STATE_FILE_PATH);
        }
    }

    @State(name="dataSourceStorageLocal", storages={@Storage(value="dataSources.local.xml", roamingType=RoamingType.DISABLED)})
    public static class App
    extends DataSourceStorageLocal
    implements PersistentStateComponent<Element> {
    }
}

